/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Arrays;
import jcifs.BufferCache;
import jcifs.Configuration;

public class BufferCacheImpl
implements BufferCache {
    private final Object[] cache;
    private final int bufferSize;
    private int freeBuffers = 0;

    public BufferCacheImpl(Configuration cfg) {
        this(cfg.getBufferCacheSize(), cfg.getMaximumBufferSize());
    }

    public BufferCacheImpl(int maxBuffers, int maxSize) {
        this.cache = new Object[maxBuffers];
        this.bufferSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBuffer() {
        Object[] objectArray = this.cache;
        synchronized (this.cache) {
            if (this.freeBuffers > 0) {
                int i = 0;
                while (i < this.cache.length) {
                    if (this.cache[i] != null) {
                        byte[] buf = (byte[])this.cache[i];
                        this.cache[i] = null;
                        --this.freeBuffers;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return buf;
                    }
                    ++i;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new byte[this.bufferSize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseBuffer(byte[] buf) {
        if (buf == null) {
            return;
        }
        Arrays.fill(buf, (byte)0);
        Object[] objectArray = this.cache;
        synchronized (this.cache) {
            if (this.freeBuffers < this.cache.length) {
                int i = 0;
                while (i < this.cache.length) {
                    if (this.cache[i] == null) {
                        this.cache[i] = buf;
                        ++this.freeBuffers;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    ++i;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

