/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import jcifs.CIFSContext;
import jcifs.context.SingletonContext;
import jcifs.smb.SmbFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler
extends URLStreamHandler {
    private static final Logger log = LoggerFactory.getLogger(Handler.class);
    private CIFSContext transportContext;

    public Handler() {
    }

    public Handler(CIFSContext tc) {
        this.transportContext = tc;
    }

    @Override
    protected int getDefaultPort() {
        return 445;
    }

    @Override
    public URLConnection openConnection(URL u) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Opening file " + u);
        }
        return new SmbFile(u, this.getTransportContext());
    }

    private CIFSContext getTransportContext() {
        if (this.transportContext == null) {
            this.transportContext = SingletonContext.getInstance();
        }
        return this.transportContext;
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        int port;
        String host = u.getHost();
        if (spec.equals("smb://")) {
            spec = "smb:////";
            limit += 2;
        } else if (!spec.startsWith("smb://") && host != null && host.length() == 0) {
            spec = "//" + spec;
            limit += 2;
        }
        super.parseURL(u, spec, start, limit);
        String path = u.getPath();
        String ref = u.getRef();
        if (ref != null) {
            path = String.valueOf(path) + '#' + ref;
        }
        if ((port = u.getPort()) == -1) {
            port = this.getDefaultPort();
        }
        this.setURL(u, "smb", u.getHost(), port, u.getAuthority(), u.getUserInfo(), path, u.getQuery(), null);
    }
}

