/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Objects;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

class MIEName {
    private static byte[] TOK_ID = new byte[]{4, 1};
    private static int TOK_ID_SIZE = 2;
    private static int MECH_OID_LEN_SIZE = 2;
    private static int NAME_LEN_SIZE = 4;
    private ASN1ObjectIdentifier oid;
    private String name;

    MIEName(byte[] buf) {
        if (buf.length < TOK_ID_SIZE + MECH_OID_LEN_SIZE) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < TOK_ID.length) {
            if (TOK_ID[i] != buf[i]) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        int len = 0xFF00 & buf[i++] << 8;
        if (buf.length < i + (len |= 0xFF & buf[i++])) {
            throw new IllegalArgumentException();
        }
        byte[] bo = new byte[len];
        System.arraycopy(buf, i, bo, 0, len);
        this.oid = ASN1ObjectIdentifier.getInstance((Object)bo);
        if (buf.length < (i += len) + NAME_LEN_SIZE) {
            throw new IllegalArgumentException();
        }
        len = 0xFF000000 & buf[i++] << 24;
        len |= 0xFF0000 & buf[i++] << 16;
        len |= 0xFF00 & buf[i++] << 8;
        if (buf.length < i + (len |= 0xFF & buf[i++])) {
            throw new IllegalArgumentException();
        }
        this.name = new String(buf, i, len);
    }

    MIEName(ASN1ObjectIdentifier oid, String name) {
        this.oid = oid;
        this.name = name;
    }

    public boolean equals(Object other) {
        if (other instanceof MIEName) {
            MIEName terg = (MIEName)other;
            if (Objects.equals(this.oid, terg.oid) && (this.name == null && terg.name == null || this.name != null && this.name.equalsIgnoreCase(terg.name))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

