/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import javax.security.auth.Subject;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Credentials;
import jcifs.RuntimeCIFSException;
import jcifs.smb.CredentialsInternal;
import jcifs.smb.NtlmContext;
import jcifs.smb.NtlmUtil;
import jcifs.smb.SSPContext;
import jcifs.smb.SmbException;
import jcifs.smb.SmbUnsupportedOperationException;
import jcifs.smb.SpnegoContext;
import jcifs.spnego.NegTokenInit;
import jcifs.util.Crypto;
import jcifs.util.Strings;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmPasswordAuthenticator
implements Principal,
CredentialsInternal,
Serializable {
    private static final long serialVersionUID = -4090263879887877186L;
    private static final Logger log = LoggerFactory.getLogger(NtlmPasswordAuthenticator.class);
    private AuthenticationType type;
    private String domain;
    private String username;
    private String password;
    private byte[] clientChallenge = null;

    public NtlmPasswordAuthenticator() {
        this(AuthenticationType.NULL);
    }

    public NtlmPasswordAuthenticator(AuthenticationType type) {
        this.domain = "";
        this.username = "";
        this.password = "";
        this.type = type;
    }

    public NtlmPasswordAuthenticator(String username, String password) {
        this(null, username, password);
    }

    public NtlmPasswordAuthenticator(String domain, String username, String password) {
        this(domain, username, password, AuthenticationType.USER);
    }

    public NtlmPasswordAuthenticator(String domain, String username, String password, AuthenticationType type) {
        if (username != null) {
            int ci = username.indexOf(64);
            if (ci > 0) {
                domain = username.substring(ci + 1);
                username = username.substring(0, ci);
            } else {
                ci = username.indexOf(92);
                if (ci > 0) {
                    domain = username.substring(0, ci);
                    username = username.substring(ci + 1);
                }
            }
        }
        this.domain = domain != null ? domain : "";
        this.username = username != null ? username : "";
        this.password = password != null ? password : "";
        this.type = type == null ? this.guessAuthenticationType() : type;
    }

    protected NtlmPasswordAuthenticator(String userInfo, String defDomain, String defUser, String defPassword) {
        this(userInfo, defDomain, defUser, defPassword, null);
    }

    protected NtlmPasswordAuthenticator(String userInfo, String defDomain, String defUser, String defPassword, AuthenticationType type) {
        String dom = null;
        String user = null;
        String pass = null;
        if (userInfo != null) {
            try {
                userInfo = NtlmPasswordAuthenticator.unescape(userInfo);
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeCIFSException(uee);
            }
            int end = userInfo.length();
            int i = 0;
            int u = 0;
            while (i < end) {
                char c = userInfo.charAt(i);
                if (c == ';') {
                    dom = userInfo.substring(0, i);
                    u = i + 1;
                } else if (c == ':') {
                    pass = userInfo.substring(i + 1);
                    break;
                }
                ++i;
            }
            user = userInfo.substring(u, i);
        }
        String string = dom != null ? dom : (this.domain = defDomain != null ? defDomain : "");
        String string2 = user != null ? user : (this.username = defUser != null ? defUser : "");
        this.password = pass != null ? pass : (defPassword != null ? defPassword : "");
        this.type = type == null ? this.guessAuthenticationType() : type;
    }

    protected AuthenticationType guessAuthenticationType() {
        AuthenticationType t = AuthenticationType.USER;
        if ("guest".equalsIgnoreCase(this.username)) {
            t = AuthenticationType.GUEST;
        } else if ((this.getUserDomain() == null || this.getUserDomain().isEmpty()) && this.getUsername().isEmpty() && this.getPassword().isEmpty()) {
            t = AuthenticationType.NULL;
        }
        return t;
    }

    @Override
    public <T extends Credentials> T unwrap(Class<T> t) {
        if (t.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public Subject getSubject() {
        return null;
    }

    @Override
    public void refresh() throws CIFSException {
    }

    @Override
    public SSPContext createContext(CIFSContext tc, String targetDomain, String host, byte[] initialToken, boolean doSigning) throws SmbException {
        if (tc.getConfig().isUseRawNTLM()) {
            return NtlmPasswordAuthenticator.setupTargetName(tc, host, new NtlmContext(tc, this, doSigning));
        }
        try {
            if (initialToken != null && initialToken.length > 0) {
                HashSet<ASN1ObjectIdentifier> mechs;
                NegTokenInit tok = new NegTokenInit(initialToken);
                if (log.isDebugEnabled()) {
                    log.debug("Have initial token " + tok);
                }
                if (tok.getMechanisms() != null && !(mechs = new HashSet<ASN1ObjectIdentifier>(Arrays.asList(tok.getMechanisms()))).contains(NtlmContext.NTLMSSP_OID)) {
                    throw new SmbUnsupportedOperationException("Server does not support NTLM authentication");
                }
            }
        }
        catch (SmbException e) {
            throw e;
        }
        catch (IOException e1) {
            log.debug("Ignoring invalid initial token", (Throwable)e1);
        }
        return new SpnegoContext(tc.getConfig(), NtlmPasswordAuthenticator.setupTargetName(tc, host, new NtlmContext(tc, this, doSigning)));
    }

    private static SSPContext setupTargetName(CIFSContext tc, String host, NtlmContext ntlmContext) {
        if (host != null && tc.getConfig().isSendNTLMTargetName()) {
            ntlmContext.setTargetName(String.format("cifs/%s", host));
        }
        return ntlmContext;
    }

    @Override
    public NtlmPasswordAuthenticator clone() {
        NtlmPasswordAuthenticator cloned = new NtlmPasswordAuthenticator();
        NtlmPasswordAuthenticator.cloneInternal(cloned, this);
        return cloned;
    }

    protected static void cloneInternal(NtlmPasswordAuthenticator cloned, NtlmPasswordAuthenticator toClone) {
        cloned.domain = toClone.domain;
        cloned.username = toClone.username;
        cloned.password = toClone.password;
        cloned.type = toClone.type;
    }

    @Override
    public String getUserDomain() {
        return this.domain;
    }

    public String getSpecifiedUserDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getName() {
        boolean d = this.domain != null && this.domain.length() > 0;
        return d ? String.valueOf(this.domain) + "\\" + this.username : this.username;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NtlmPasswordAuthenticator) {
            String domB;
            NtlmPasswordAuthenticator ntlm = (NtlmPasswordAuthenticator)obj;
            String domA = ntlm.getUserDomain() != null ? ntlm.getUserDomain().toUpperCase() : null;
            String string = domB = this.getUserDomain() != null ? this.getUserDomain().toUpperCase() : null;
            return ntlm.type == this.type && Objects.equals(domA, domB) && ntlm.getUsername().equalsIgnoreCase(this.getUsername()) && Objects.equals(this.getPassword(), ntlm.getPassword());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().toUpperCase().hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isAnonymous() {
        return this.type == AuthenticationType.NULL;
    }

    @Override
    public boolean isGuest() {
        return this.type == AuthenticationType.GUEST;
    }

    static String unescape(String str) throws NumberFormatException, UnsupportedEncodingException {
        byte[] b = new byte[1];
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] out = new char[len];
        int state = 0;
        int j = 0;
        int i = 0;
        while (i < len) {
            switch (state) {
                case 0: {
                    char ch = str.charAt(i);
                    if (ch == '%') {
                        state = 1;
                        break;
                    }
                    out[j++] = ch;
                    break;
                }
                case 1: {
                    b[0] = (byte)(Integer.parseInt(str.substring(i, i + 2), 16) & 0xFF);
                    out[j++] = new String(b, 0, 1, "ASCII").charAt(0);
                    ++i;
                    state = 0;
                }
            }
            ++i;
        }
        return new String(out, 0, j);
    }

    public boolean isPreferredMech(ASN1ObjectIdentifier mechanism) {
        return NtlmContext.NTLMSSP_OID.equals((ASN1Primitive)mechanism);
    }

    public byte[] getAnsiHash(CIFSContext tc, byte[] chlng) throws GeneralSecurityException {
        switch (tc.getConfig().getLanManCompatibility()) {
            case 0: 
            case 1: {
                return NtlmUtil.getPreNTLMResponse(tc, this.password, chlng);
            }
            case 2: {
                return NtlmUtil.getNTLMResponse(this.password, chlng);
            }
            case 3: 
            case 4: 
            case 5: {
                if (this.clientChallenge == null) {
                    this.clientChallenge = new byte[8];
                    tc.getConfig().getRandom().nextBytes(this.clientChallenge);
                }
                return NtlmUtil.getLMv2Response(this.domain, this.username, this.password, chlng, this.clientChallenge);
            }
        }
        return NtlmUtil.getPreNTLMResponse(tc, this.password, chlng);
    }

    public byte[] getUnicodeHash(CIFSContext tc, byte[] chlng) throws GeneralSecurityException {
        switch (tc.getConfig().getLanManCompatibility()) {
            case 0: 
            case 1: 
            case 2: {
                return NtlmUtil.getNTLMResponse(this.password, chlng);
            }
            case 3: 
            case 4: 
            case 5: {
                return new byte[0];
            }
        }
        return NtlmUtil.getNTLMResponse(this.password, chlng);
    }

    public byte[] getSigningKey(CIFSContext tc, byte[] chlng) throws SmbException, GeneralSecurityException {
        switch (tc.getConfig().getLanManCompatibility()) {
            case 0: 
            case 1: 
            case 2: {
                byte[] signingKey = new byte[40];
                this.getUserSessionKey(tc, chlng, signingKey, 0);
                System.arraycopy(this.getUnicodeHash(tc, chlng), 0, signingKey, 16, 24);
                return signingKey;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new SmbException("NTLMv2 requires extended security (jcifs.smb.client.useExtendedSecurity must be true if jcifs.smb.lmCompatibility >= 3)");
            }
        }
        return null;
    }

    public byte[] getUserSessionKey(CIFSContext tc, byte[] chlng) {
        byte[] key = new byte[16];
        try {
            this.getUserSessionKey(tc, chlng, key, 0);
        }
        catch (Exception ex) {
            log.error("Failed to get session key", (Throwable)ex);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getUserSessionKey(CIFSContext tc, byte[] chlng, byte[] dest, int offset) throws SmbException {
        try {
            MessageDigest md4 = Crypto.getMD4();
            byte[] ntHash = this.getNTHash();
            switch (tc.getConfig().getLanManCompatibility()) {
                case 0: 
                case 1: 
                case 2: {
                    md4.update(ntHash);
                    md4.digest(dest, offset, 16);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    NtlmPasswordAuthenticator ntlmPasswordAuthenticator = this;
                    synchronized (ntlmPasswordAuthenticator) {
                        if (this.clientChallenge == null) {
                            this.clientChallenge = new byte[8];
                            tc.getConfig().getRandom().nextBytes(this.clientChallenge);
                        }
                    }
                    MessageDigest hmac = Crypto.getHMACT64(ntHash);
                    hmac.update(Strings.getUNIBytes(this.username.toUpperCase()));
                    hmac.update(Strings.getUNIBytes(this.domain.toUpperCase()));
                    byte[] ntlmv2Hash = hmac.digest();
                    hmac = Crypto.getHMACT64(ntlmv2Hash);
                    hmac.update(chlng);
                    hmac.update(this.clientChallenge);
                    MessageDigest userKey = Crypto.getHMACT64(ntlmv2Hash);
                    userKey.update(hmac.digest());
                    userKey.digest(dest, offset, 16);
                    break;
                }
                default: {
                    md4.update(ntHash);
                    md4.digest(dest, offset, 16);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new SmbException("", (Throwable)e);
        }
    }

    protected byte[] getNTHash() {
        MessageDigest md4 = Crypto.getMD4();
        md4.update(Strings.getUNIBytes(this.password));
        byte[] ntHash = md4.digest();
        return ntHash;
    }

    public static enum AuthenticationType {
        NULL,
        GUEST,
        USER;

    }
}

