/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.net.MalformedURLException;
import java.util.Iterator;
import jcifs.CIFSException;
import jcifs.CloseableIterator;
import jcifs.ResourceFilter;
import jcifs.SmbResource;
import jcifs.smb.FileEntry;
import jcifs.smb.SmbFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShareEnumIterator
implements CloseableIterator<SmbResource> {
    private static final Logger log = LoggerFactory.getLogger(ShareEnumIterator.class);
    private final Iterator<FileEntry> delegate;
    private final ResourceFilter filter;
    private final SmbResource parent;
    private SmbResource next;

    public ShareEnumIterator(SmbResource parent, Iterator<FileEntry> delegate, ResourceFilter filter) {
        this.parent = parent;
        this.delegate = delegate;
        this.filter = filter;
        this.next = this.advance();
    }

    private SmbResource advance() {
        while (this.delegate.hasNext()) {
            FileEntry n = this.delegate.next();
            if (this.filter == null) {
                try {
                    return this.adapt(n);
                }
                catch (MalformedURLException e) {
                    log.error("Failed to create child URL", (Throwable)e);
                    continue;
                }
            }
            try {
                Throwable e = null;
                Object var3_7 = null;
                try (SmbResource nr = this.adapt(n);){
                    if (!this.filter.accept(nr)) continue;
                    return nr;
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (CIFSException e) {
                log.error("Failed to apply filter", (Throwable)e);
            }
            catch (MalformedURLException e) {
                log.error("Failed to create child URL", (Throwable)e);
            }
        }
        return null;
    }

    private SmbResource adapt(FileEntry e) throws MalformedURLException {
        return new SmbFile(this.parent, e.getName(), false, e.getType(), 17, 0L, 0L, 0L, 0L);
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public SmbResource next() {
        SmbResource n = this.next;
        this.next = this.advance();
        return n;
    }

    @Override
    public void close() {
        this.next = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

