/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import jcifs.CIFSException;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.fscc.FileBasicInfo;
import jcifs.internal.smb1.com.SmbComSetInformation;
import jcifs.internal.smb1.com.SmbComSetInformationResponse;
import jcifs.internal.smb1.trans2.Trans2SetFileInformation;
import jcifs.internal.smb1.trans2.Trans2SetFileInformationResponse;
import jcifs.internal.smb2.info.Smb2SetInfoRequest;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileHandleImpl;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.SmbTreeHandleImpl;
import jcifs.smb.SmbUnsupportedOperationException;
import jcifs.smb.WriterThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SmbCopyUtil {
    private static final Logger log = LoggerFactory.getLogger(SmbCopyUtil.class);

    private SmbCopyUtil() {
    }

    static SmbFileHandleImpl openCopyTargetFile(SmbFile dest, int attrs, boolean alsoRead) throws CIFSException {
        try {
            return dest.openUnshared(82, 0x102 | (alsoRead ? 1 : 0), 0, attrs, 0);
        }
        catch (SmbAuthException sae) {
            log.trace("copyTo0", (Throwable)sae);
            int dattrs = dest.getAttributes();
            if ((dattrs & 1) != 0) {
                dest.setPathInformation(dattrs & 0xFFFFFFFE, 0L, 0L, 0L);
                return dest.openUnshared(82, 0x102 | (alsoRead ? 1 : 0), 0, attrs, 0);
            }
            throw sae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void copyFile(SmbFile src, SmbFile dest, byte[][] b, int bsize, WriterThread w, SmbTreeHandleImpl sh, SmbTreeHandleImpl dh) throws SmbException {
        if (sh.isSMB2() && dh.isSMB2() && sh.isSameTree(dh)) {
            try {
                SmbCopyUtil.serverSideCopy(src, dest, sh, dh, false);
                return;
            }
            catch (SmbUnsupportedOperationException e) {
                log.debug("Server side copy not supported, falling back to normal copying", (Throwable)e);
            }
            catch (CIFSException e) {
                log.warn("Server side copy failed", (Throwable)e);
                throw SmbException.wrap(e);
            }
        }
        try {
            Throwable e = null;
            Object var8_12 = null;
            try {
                SmbFileHandleImpl sfd = src.openUnshared(0, 1, 1, 128, 0);
                try {
                    block44: {
                        try (SmbFileInputStream fis = new SmbFileInputStream(src, sh, sfd);){
                            int attrs = src.getAttributes();
                            Throwable throwable = null;
                            Object var13_20 = null;
                            try {
                                SmbFileHandleImpl dfd = SmbCopyUtil.openCopyTargetFile(dest, attrs, false);
                                try {
                                    block43: {
                                        try (SmbFileOutputStream fos = new SmbFileOutputStream(dest, dh, dfd, 82, 258, 0);){
                                            long mtime = src.lastModified();
                                            long ctime = src.createTime();
                                            long atime = src.lastAccess();
                                            int i = 0;
                                            long off = 0L;
                                            block24: while (true) {
                                                int read = fis.read(b[i]);
                                                WriterThread writerThread = w;
                                                synchronized (writerThread) {
                                                    w.checkException();
                                                    while (true) {
                                                        if (w.isReady()) {
                                                            w.checkException();
                                                            if (read > 0) break;
                                                            break block24;
                                                        }
                                                        try {
                                                            w.wait();
                                                        }
                                                        catch (InterruptedException ie) {
                                                            throw new SmbException(dest.getURL().toString(), (Throwable)ie);
                                                        }
                                                    }
                                                    w.write(b[i], read, fos);
                                                }
                                                i = i == 1 ? 0 : 1;
                                                off += (long)read;
                                            }
                                            if (log.isDebugEnabled()) {
                                                log.debug(String.format("Copied a total of %d bytes", off));
                                            }
                                            if (dh.isSMB2()) {
                                                Smb2SetInfoRequest req = new Smb2SetInfoRequest(dh.getConfig(), dfd.getFileId());
                                                req.setFileInformation(new FileBasicInfo(ctime, atime, mtime, 0L, attrs));
                                                dh.send(req, new RequestParam[0]);
                                                break block43;
                                            }
                                            if (dh.hasCapability(16)) {
                                                dh.send((CommonServerMessageBlockRequest)new Trans2SetFileInformation(dh.getConfig(), dfd.getFid(), attrs, ctime, mtime, atime), new Trans2SetFileInformationResponse(dh.getConfig()), new RequestParam[0]);
                                            } else {
                                                dh.send((CommonServerMessageBlockRequest)new SmbComSetInformation(dh.getConfig(), dest.getUncPath(), attrs, mtime), new SmbComSetInformationResponse(dh.getConfig()), new RequestParam[0]);
                                            }
                                        }
                                    }
                                    if (dfd == null) break block44;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (dfd == null) throw throwable;
                                    dfd.close();
                                    throw throwable;
                                }
                                dfd.close();
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                    throw throwable;
                                }
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                                throw throwable;
                            }
                        }
                    }
                    if (sfd == null) return;
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    if (sfd == null) throw e;
                    sfd.close();
                    throw e;
                }
                sfd.close();
                return;
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                    throw e;
                }
                if (e == throwable) throw e;
                e.addSuppressed(throwable);
                throw e;
            }
        }
        catch (IOException se) {
            if (!src.getContext().getConfig().isIgnoreCopyToException()) {
                throw new SmbException("Failed to copy file from [" + src.toString() + "] to [" + dest.toString() + "]", (Throwable)se);
            }
            log.warn("Copy failed", (Throwable)se);
        }
    }

    /*
     * Exception decompiling
     */
    private static void serverSideCopy(SmbFile src, SmbFile dest, SmbTreeHandleImpl sh, SmbTreeHandleImpl dh, boolean write) throws CIFSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static void copyDir(SmbFile src, SmbFile dest, byte[][] b, int bsize, WriterThread w, SmbTreeHandleImpl sh, SmbTreeHandleImpl dh) throws CIFSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[UNCONDITIONALDOLOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

