/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import jcifs.Address;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.CloseableIterator;
import jcifs.ResourceFilter;
import jcifs.ResourceNameFilter;
import jcifs.SmbResource;
import jcifs.SmbResourceLocator;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.msrpc.MsrpcDfsRootEnum;
import jcifs.dcerpc.msrpc.MsrpcShareEnum;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.smb1.net.NetShareEnum;
import jcifs.internal.smb1.net.NetShareEnumResponse;
import jcifs.smb.DirFileEntryAdapterIterator;
import jcifs.smb.DirFileEntryEnumIterator1;
import jcifs.smb.DirFileEntryEnumIterator2;
import jcifs.smb.DosFileFilter;
import jcifs.smb.FileEntry;
import jcifs.smb.NetServerEnumIterator;
import jcifs.smb.NetServerFileEntryAdapterIterator;
import jcifs.smb.RequestParam;
import jcifs.smb.ShareEnumIterator;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileFilter;
import jcifs.smb.SmbFilenameFilter;
import jcifs.smb.SmbResourceLocatorImpl;
import jcifs.smb.SmbSessionImpl;
import jcifs.smb.SmbTransportImpl;
import jcifs.smb.SmbTreeConnection;
import jcifs.smb.SmbTreeHandleImpl;
import jcifs.smb.SmbUnsupportedOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SmbEnumerationUtil {
    private static final Logger log = LoggerFactory.getLogger(SmbEnumerationUtil.class);

    private SmbEnumerationUtil() {
    }

    private static DcerpcHandle getHandle(CIFSContext ctx, SmbResourceLocator loc, Address address, String ep) throws MalformedURLException, DcerpcException {
        return DcerpcHandle.getHandle(String.format("ncacn_np:%s[endpoint=%s,address=%s]", loc.getServer(), ep, address.getHostAddress()), ctx);
    }

    static FileEntry[] doDfsRootEnum(CIFSContext ctx, SmbResourceLocator loc, Address address) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DcerpcHandle handle = SmbEnumerationUtil.getHandle(ctx, loc, address, "\\PIPE\\netdfs");){
            MsrpcDfsRootEnum rpc2 = new MsrpcDfsRootEnum(loc.getServer());
            handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, true);
            }
            return rpc2.getEntries();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static FileEntry[] doMsrpcShareEnum(CIFSContext ctx, SmbResourceLocator loc, Address address) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DcerpcHandle handle = SmbEnumerationUtil.getHandle(ctx, loc, address, "\\PIPE\\srvsvc");){
            MsrpcShareEnum rpc2 = new MsrpcShareEnum(loc.getServer());
            handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, true);
            }
            return rpc2.getEntries();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static FileEntry[] doNetShareEnum(SmbTreeHandleImpl th) throws CIFSException {
        NetShareEnum req = new NetShareEnum(th.getConfig());
        NetShareEnumResponse resp = new NetShareEnumResponse(th.getConfig());
        th.send((CommonServerMessageBlockRequest)req, resp, new RequestParam[0]);
        if (resp.getStatus() != 0) {
            throw new SmbException(resp.getStatus(), true);
        }
        return resp.getResults();
    }

    static CloseableIterator<SmbResource> doShareEnum(SmbFile parent, String wildcard, int searchAttributes, ResourceNameFilter fnf, ResourceFilter ff) throws CIFSException {
        Object e;
        FileEntry[] entries;
        SmbResourceLocatorImpl locator = parent.fileLocator.clone();
        CIFSContext tc = parent.getContext();
        URL u = locator.getURL();
        if (u.getPath().lastIndexOf(47) != u.getPath().length() - 1) {
            throw new SmbException(String.valueOf(u.toString()) + " directory must end with '/'");
        }
        if (locator.getType() != 4) {
            throw new SmbException("The requested list operations is invalid: " + u.toString());
        }
        HashSet<Object> set = new HashSet<Object>();
        if (tc.getDfs().isTrustedDomain(tc, locator.getServer())) {
            try {
                entries = SmbEnumerationUtil.doDfsRootEnum(tc, locator, locator.getAddress());
                int ei = 0;
                while (ei < entries.length) {
                    e = entries[ei];
                    if (!set.contains(e) && (fnf == null || fnf.accept(parent, e.getName()))) {
                        set.add(e);
                    }
                    ++ei;
                }
            }
            catch (IOException ioe) {
                log.debug("DS enumeration failed", (Throwable)ioe);
            }
        }
        SmbTreeConnection treeConn = SmbTreeConnection.create(tc);
        try {
            e = null;
            Object var12_17 = null;
            try {
                SmbTreeHandleImpl th = treeConn.connectHost(locator, locator.getServerWithDfs());
                try {
                    SmbSessionImpl session = th.getSession();
                    try {
                        try (SmbTransportImpl transport = session.getTransport();){
                            try {
                                entries = SmbEnumerationUtil.doMsrpcShareEnum(tc, locator, transport.getRemoteAddress());
                            }
                            catch (IOException ioe) {
                                if (th.isSMB2()) {
                                    throw ioe;
                                }
                                log.debug("doMsrpcShareEnum failed", (Throwable)ioe);
                                entries = SmbEnumerationUtil.doNetShareEnum(th);
                            }
                            int ei = 0;
                            while (ei < entries.length) {
                                FileEntry e2 = entries[ei];
                                if (!set.contains(e2) && (fnf == null || fnf.accept(parent, e2.getName()))) {
                                    set.add(e2);
                                }
                                ++ei;
                            }
                        }
                        if (session != null) {
                            session.close();
                        }
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            ((Throwable)e).addSuppressed(throwable);
                        }
                        if (session != null) {
                            session.close();
                        }
                        throw e;
                    }
                    if (th != null) {
                        th.close();
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        ((Throwable)e).addSuppressed(throwable);
                    }
                    if (th != null) {
                        th.close();
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    ((Throwable)e).addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (SmbException e3) {
            throw e3;
        }
        catch (IOException ioe) {
            log.debug("doNetShareEnum failed", (Throwable)ioe);
            throw new SmbException(u.toString(), (Throwable)ioe);
        }
        return new ShareEnumIterator(parent, set.iterator(), ff);
    }

    /*
     * Loose catch block
     */
    static CloseableIterator<SmbResource> doEnum(SmbFile parent, String wildcard, int searchAttributes, ResourceNameFilter fnf, ResourceFilter ff) throws CIFSException {
        SmbResourceLocator locator;
        DosFileFilter dff = SmbEnumerationUtil.unwrapDOSFilter(ff);
        if (dff != null) {
            if (dff.wildcard != null) {
                wildcard = dff.wildcard;
            }
            searchAttributes = dff.attributes;
        }
        if ((locator = parent.getLocator()).getURL().getHost().isEmpty()) {
            Address addr;
            try {
                addr = locator.getAddress();
            }
            catch (CIFSException e) {
                if (e.getCause() instanceof UnknownHostException) {
                    log.debug("Failed to find master browser", (Throwable)e);
                    throw new SmbUnsupportedOperationException();
                }
                throw e;
            }
            Throwable throwable = null;
            Object var9_19 = null;
            try (SmbFile browser = (SmbFile)parent.resolve(addr.getHostAddress());){
                NetServerFileEntryAdapterIterator netServerFileEntryAdapterIterator;
                SmbTreeHandleImpl th;
                Throwable throwable2;
                block49: {
                    throwable2 = null;
                    Object var12_26 = null;
                    th = browser.ensureTreeConnected();
                    if (th.isSMB2()) {
                        throw new SmbUnsupportedOperationException();
                    }
                    netServerFileEntryAdapterIterator = new NetServerFileEntryAdapterIterator((SmbResource)parent, new NetServerEnumIterator(parent, th, wildcard, searchAttributes, fnf), ff);
                    if (th == null) break block49;
                    th.close();
                }
                return netServerFileEntryAdapterIterator;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (th != null) {
                                th.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        if (locator.getType() == 2) {
            Throwable throwable = null;
            Object var8_15 = null;
            try (SmbTreeHandleImpl th = parent.ensureTreeConnected();){
                if (th.isSMB2()) {
                    throw new SmbUnsupportedOperationException();
                }
                return new NetServerFileEntryAdapterIterator((SmbResource)parent, new NetServerEnumIterator(parent, th, wildcard, searchAttributes, fnf), ff);
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        if (locator.isRoot()) {
            return SmbEnumerationUtil.doShareEnum(parent, wildcard, searchAttributes, fnf, ff);
        }
        Throwable throwable = null;
        Object var8_17 = null;
        try (SmbTreeHandleImpl th = parent.ensureTreeConnected();){
            if (th.isSMB2()) {
                return new DirFileEntryAdapterIterator(parent, new DirFileEntryEnumIterator2(th, parent, wildcard, fnf, searchAttributes), ff);
            }
            return new DirFileEntryAdapterIterator(parent, new DirFileEntryEnumIterator1(th, parent, wildcard, fnf, searchAttributes), ff);
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
            } else if (throwable != throwable7) {
                throwable.addSuppressed(throwable7);
            }
            throw throwable;
        }
    }

    private static DosFileFilter unwrapDOSFilter(ResourceFilter ff) {
        SmbFileFilter sff;
        if (ff instanceof ResourceFilterWrapper && (sff = ((ResourceFilterWrapper)ff).getFileFilter()) instanceof DosFileFilter) {
            return (DosFileFilter)sff;
        }
        return null;
    }

    static String[] list(SmbFile root, String wildcard, int searchAttributes, final SmbFilenameFilter fnf, final SmbFileFilter ff) throws SmbException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableIterator<SmbResource> it = SmbEnumerationUtil.doEnum(root, wildcard, searchAttributes, fnf == null ? null : new ResourceNameFilter(){

                @Override
                public boolean accept(SmbResource parent, String name) throws CIFSException {
                    if (!(parent instanceof SmbFile)) {
                        return false;
                    }
                    return fnf.accept((SmbFile)parent, name);
                }
            }, ff == null ? null : new ResourceFilter(){

                @Override
                public boolean accept(SmbResource resource) throws CIFSException {
                    if (!(resource instanceof SmbFile)) {
                        return false;
                    }
                    return ff.accept((SmbFile)resource);
                }
            });){
                ArrayList<String> list = new ArrayList<String>();
                while (it.hasNext()) {
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (SmbResource n = (SmbResource)it.next();){
                        list.add(n.getName());
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                return list.toArray(new String[list.size()]);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    static SmbFile[] listFiles(SmbFile root, String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableIterator<SmbResource> it = SmbEnumerationUtil.doEnum(root, wildcard, searchAttributes, fnf == null ? null : new ResourceNameFilterWrapper(fnf), ff == null ? null : new ResourceFilterWrapper(ff));){
                ArrayList<SmbFile> list = new ArrayList<SmbFile>();
                while (it.hasNext()) {
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (SmbResource n = (SmbResource)it.next();){
                        if (!(n instanceof SmbFile)) continue;
                        list.add((SmbFile)n);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                return list.toArray(new SmbFile[list.size()]);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    private static final class ResourceFilterWrapper
    implements ResourceFilter {
        private final SmbFileFilter ff;

        ResourceFilterWrapper(SmbFileFilter ff) {
            this.ff = ff;
        }

        SmbFileFilter getFileFilter() {
            return this.ff;
        }

        @Override
        public boolean accept(SmbResource resource) throws CIFSException {
            if (!(resource instanceof SmbFile)) {
                return false;
            }
            return this.ff.accept((SmbFile)resource);
        }
    }

    private static final class ResourceNameFilterWrapper
    implements ResourceNameFilter {
        private final SmbFilenameFilter fnf;

        ResourceNameFilterWrapper(SmbFilenameFilter fnf) {
            this.fnf = fnf;
        }

        @Override
        public boolean accept(SmbResource parent, String name) throws CIFSException {
            if (!(parent instanceof SmbFile)) {
                return false;
            }
            return this.fnf.accept((SmbFile)parent, name);
        }
    }
}

