/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jcifs.CIFSException;
import jcifs.smb.DosError;
import jcifs.smb.NtStatus;
import jcifs.smb.WinError;
import jcifs.util.Hexdump;

public class SmbException
extends CIFSException
implements NtStatus,
DosError,
WinError {
    private static final long serialVersionUID = 484863569441792249L;
    private static final Map<Integer, String> errorCodeMessages;
    private static final Map<Integer, String> winErrorCodeMessages;
    private static final Map<Integer, Integer> dosErrorCodeStatuses;
    private int status;

    static {
        HashMap<Integer, String> errorCodeMessagesTmp = new HashMap<Integer, String>();
        int i = 0;
        while (i < NT_STATUS_CODES.length) {
            errorCodeMessagesTmp.put(NT_STATUS_CODES[i], NT_STATUS_MESSAGES[i]);
            ++i;
        }
        HashMap<Integer, Integer> dosErrorCodeStatusesTmp = new HashMap<Integer, Integer>();
        int i2 = 0;
        while (i2 < DOS_ERROR_CODES.length) {
            dosErrorCodeStatusesTmp.put(DOS_ERROR_CODES[i2][0], DOS_ERROR_CODES[i2][1]);
            int mappedNtCode = DOS_ERROR_CODES[i2][1];
            String mappedNtMessage = (String)errorCodeMessagesTmp.get(mappedNtCode);
            if (mappedNtMessage != null) {
                errorCodeMessagesTmp.put(DOS_ERROR_CODES[i2][0], mappedNtMessage);
            }
            ++i2;
        }
        errorCodeMessagesTmp.put(0, "NT_STATUS_SUCCESS");
        errorCodeMessages = Collections.unmodifiableMap(errorCodeMessagesTmp);
        dosErrorCodeStatuses = Collections.unmodifiableMap(dosErrorCodeStatusesTmp);
        HashMap<Integer, String> winErrorCodeMessagesTmp = new HashMap<Integer, String>();
        int i3 = 0;
        while (i3 < WINERR_CODES.length) {
            winErrorCodeMessagesTmp.put(WINERR_CODES[i3], WINERR_MESSAGES[i3]);
            ++i3;
        }
        winErrorCodeMessages = Collections.unmodifiableMap(winErrorCodeMessagesTmp);
    }

    public static String getMessageByCode(int errcode) {
        String message = errorCodeMessages.get(errcode);
        if (message == null) {
            message = "0x" + Hexdump.toHexString(errcode, 8);
        }
        return message;
    }

    static int getStatusByCode(int errcode) {
        int statusCode = (errcode & 0xC0000000) != 0 ? errcode : (dosErrorCodeStatuses.containsKey(errcode) ? dosErrorCodeStatuses.get(errcode) : -1073741823);
        return statusCode;
    }

    static String getMessageByWinerrCode(int errcode) {
        String message = winErrorCodeMessages.get(errcode);
        if (message == null) {
            message = "W" + Hexdump.toHexString(errcode, 8);
        }
        return message;
    }

    public SmbException() {
    }

    public SmbException(int errcode, Throwable rootCause) {
        super(SmbException.getMessageByCode(errcode), rootCause);
        this.status = SmbException.getStatusByCode(errcode);
    }

    public SmbException(String msg) {
        super(msg);
        this.status = -1073741823;
    }

    public SmbException(String msg, Throwable rootCause) {
        super(msg, rootCause);
        this.status = -1073741823;
    }

    public SmbException(int errcode, boolean winerr) {
        super(winerr ? SmbException.getMessageByWinerrCode(errcode) : SmbException.getMessageByCode(errcode));
        this.status = winerr ? errcode : SmbException.getStatusByCode(errcode);
    }

    public int getNtStatus() {
        return this.status;
    }

    @Deprecated
    public Throwable getRootCause() {
        return this.getCause();
    }

    static SmbException wrap(CIFSException e) {
        if (e instanceof SmbException) {
            return (SmbException)e;
        }
        return new SmbException(e.getMessage(), (Throwable)e);
    }
}

