/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.SmbFileHandle;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.smb1.com.SmbComBlankResponse;
import jcifs.internal.smb1.com.SmbComClose;
import jcifs.internal.smb2.create.Smb2CloseRequest;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTreeHandleImpl;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbFileHandleImpl
implements SmbFileHandle {
    private static final Logger log = LoggerFactory.getLogger(SmbFileHandleImpl.class);
    private final Configuration cfg;
    private final int fid;
    private final byte[] fileId;
    private boolean open = true;
    private final long tree_num;
    private SmbTreeHandleImpl tree;
    private final AtomicLong usageCount = new AtomicLong(1L);
    private final int flags;
    private final int access;
    private final int attrs;
    private final int options;
    private final String unc;
    private final StackTraceElement[] creationBacktrace;
    private long initialSize;

    public SmbFileHandleImpl(Configuration cfg, byte[] fid, SmbTreeHandleImpl tree, String unc, int flags, int access, int attrs, int options, long initialSize) {
        this.cfg = cfg;
        this.fileId = fid;
        this.initialSize = initialSize;
        this.fid = 0;
        this.unc = unc;
        this.flags = flags;
        this.access = access;
        this.attrs = attrs;
        this.options = options;
        this.tree = tree.acquire();
        this.tree_num = tree.getTreeId();
        this.creationBacktrace = cfg.isTraceResourceUsage() ? Thread.currentThread().getStackTrace() : null;
    }

    public SmbFileHandleImpl(Configuration cfg, int fid, SmbTreeHandleImpl tree, String unc, int flags, int access, int attrs, int options, long initialSize) {
        this.cfg = cfg;
        this.fid = fid;
        this.initialSize = initialSize;
        this.fileId = null;
        this.unc = unc;
        this.flags = flags;
        this.access = access;
        this.attrs = attrs;
        this.options = options;
        this.tree = tree.acquire();
        this.tree_num = tree.getTreeId();
        this.creationBacktrace = cfg.isTraceResourceUsage() ? Thread.currentThread().getStackTrace() : null;
    }

    public int getFid() throws SmbException {
        if (!this.isValid()) {
            throw new SmbException("Descriptor is no longer valid");
        }
        return this.fid;
    }

    public byte[] getFileId() throws SmbException {
        if (!this.isValid()) {
            throw new SmbException("Descriptor is no longer valid");
        }
        return this.fileId;
    }

    @Override
    public long getInitialSize() {
        return this.initialSize;
    }

    @Override
    public SmbTreeHandleImpl getTree() {
        return this.tree.acquire();
    }

    @Override
    public boolean isValid() {
        return this.open && this.tree_num == this.tree.getTreeId() && this.tree.isConnected();
    }

    @Override
    public synchronized void close(long lastWriteTime) throws CIFSException {
        this.closeInternal(lastWriteTime, true);
    }

    void closeInternal(long lastWriteTime, boolean explicit) throws CIFSException {
        SmbTreeHandleImpl t = this.tree;
        try {
            if (t != null && this.isValid()) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing file handle " + this);
                }
                if (t.isSMB2()) {
                    Smb2CloseRequest req = new Smb2CloseRequest(this.cfg, this.fileId);
                    t.send(req, RequestParam.NO_RETRY);
                } else {
                    t.send((CommonServerMessageBlockRequest)new SmbComClose(this.cfg, this.fid, lastWriteTime), new SmbComBlankResponse(this.cfg), RequestParam.NO_RETRY);
                }
            }
        }
        finally {
            this.open = false;
            if (t != null) {
                t.release();
            }
            this.tree = null;
        }
    }

    @Override
    public void close() throws CIFSException {
        this.release();
    }

    @Override
    public synchronized void release() throws CIFSException {
        long usage = this.usageCount.decrementAndGet();
        if (usage == 0L) {
            this.closeInternal(0L, false);
        } else if (log.isTraceEnabled()) {
            log.trace(String.format("Release %s (%d)", this, usage));
        }
    }

    protected void finalize() throws Throwable {
        if (this.usageCount.get() != 0L && this.open) {
            log.warn("File handle was not properly closed: " + this);
            if (this.creationBacktrace != null) {
                log.warn(Arrays.toString(this.creationBacktrace));
            }
        }
    }

    public SmbFileHandleImpl acquire() {
        long usage = this.usageCount.incrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace(String.format("Acquire %s (%d)", this, usage));
        }
        return this;
    }

    public void markClosed() {
        this.open = false;
    }

    public String toString() {
        return String.format("FileHandle %s [fid=%s,tree=%d,flags=%x,access=%x,attrs=%x,options=%x]", this.unc, this.fileId != null ? Hexdump.toHexString(this.fileId) : Integer.valueOf(this.fid), this.tree_num, this.flags, this.access, this.attrs, this.options);
    }

    public int hashCode() {
        if (this.fileId != null) {
            return (int)((long)Arrays.hashCode(this.fileId) + 3L * this.tree_num);
        }
        return (int)((long)this.fid + 3L * this.tree_num);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SmbFileHandleImpl)) {
            return false;
        }
        SmbFileHandleImpl o = (SmbFileHandleImpl)obj;
        if (this.fileId != null) {
            return Arrays.equals(this.fileId, o.fileId) && this.tree_num == o.tree_num;
        }
        return this.fid == o.fid && this.tree_num == o.tree_num;
    }
}

