/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import jcifs.CIFSException;
import jcifs.SmbPipeHandle;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.smb1.trans.TransWaitNamedPipe;
import jcifs.internal.smb1.trans.TransWaitNamedPipeResponse;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFileHandleImpl;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.SmbPipeHandleInternal;
import jcifs.smb.SmbPipeInputStream;
import jcifs.smb.SmbPipeOutputStream;
import jcifs.smb.SmbSessionImpl;
import jcifs.smb.SmbTreeHandleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbPipeHandleImpl
implements SmbPipeHandleInternal {
    private static final Logger log = LoggerFactory.getLogger(SmbPipeHandleImpl.class);
    private final SmbNamedPipe pipe;
    private final boolean transact;
    private final boolean call;
    private final int openFlags;
    private final int access;
    private volatile boolean open = true;
    private SmbFileHandleImpl handle;
    private SmbPipeOutputStream output;
    private SmbPipeInputStream input;
    private final String uncPath;
    private SmbTreeHandleImpl treeHandle;
    private int sharing = 7;

    public SmbPipeHandleImpl(SmbNamedPipe pipe) {
        this.pipe = pipe;
        this.transact = (pipe.getPipeType() & 0x200) == 512;
        this.call = (pipe.getPipeType() & 0x100) == 256;
        this.openFlags = pipe.getPipeType() & 0xFFFF00FF | 0x20;
        this.access = pipe.getPipeType() & 7 | 0x20000;
        this.uncPath = this.pipe.getUncPath();
    }

    @Override
    public <T extends SmbPipeHandle> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new ClassCastException();
    }

    @Override
    public SmbNamedPipe getPipe() {
        return this.pipe;
    }

    @Override
    public SmbTreeHandleImpl ensureTreeConnected() throws CIFSException {
        if (this.treeHandle == null) {
            this.treeHandle = this.pipe.ensureTreeConnected();
        }
        return this.treeHandle.acquire();
    }

    public String getUncPath() {
        return this.uncPath;
    }

    @Override
    public boolean isOpen() {
        return this.open && this.handle != null && this.handle.isValid();
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] getSessionKey() throws CIFSException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            byte[] byArray;
            SmbSessionImpl sess;
            SmbTreeHandleImpl th;
            block16: {
                th = this.ensureTreeConnected();
                sess = th.getSession();
                byArray = sess.getSessionKey();
                if (sess != null) {
                    sess.close();
                }
                if (th == null) break block16;
                th.close();
            }
            return byArray;
            {
                catch (Throwable throwable2) {
                    try {
                        if (sess != null) {
                            sess.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (th != null) {
                            th.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isStale() {
        return !this.open || this.handle != null && !this.handle.isValid();
    }

    @Override
    public synchronized SmbFileHandleImpl ensureOpen() throws CIFSException {
        if (!this.open) {
            throw new SmbException("Pipe handle already closed");
        }
        if (!this.isOpen()) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
                if (th.isSMB2()) {
                    this.handle = this.pipe.openUnshared(this.uncPath, 0, this.access, this.sharing, 128, 0);
                    return this.handle.acquire();
                }
                if (this.uncPath.startsWith("\\pipe\\")) {
                    th.send((CommonServerMessageBlockRequest)new TransWaitNamedPipe(th.getConfig(), this.uncPath), new TransWaitNamedPipeResponse(th.getConfig()), new RequestParam[0]);
                }
                this.handle = th.hasCapability(16) || this.uncPath.startsWith("\\pipe\\") ? this.pipe.openUnshared(this.openFlags, this.access, this.sharing, 128, 0) : this.pipe.openUnshared("\\pipe" + this.getUncPath(), this.openFlags, this.access, this.sharing, 128, 0);
                return this.handle.acquire();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        log.trace("Pipe already open");
        return this.handle.acquire();
    }

    @Override
    public SmbPipeInputStream getInput() throws CIFSException {
        if (!this.open) {
            throw new SmbException("Already closed");
        }
        if (this.input != null) {
            return this.input;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            this.input = new SmbPipeInputStream(this, th);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.input;
    }

    @Override
    public SmbPipeOutputStream getOutput() throws CIFSException {
        if (!this.open) {
            throw new SmbException("Already closed");
        }
        if (this.output != null) {
            return this.output;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            this.output = new SmbPipeOutputStream(this, th);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.output;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int sendrecv(byte[] buf, int off, int length, byte[] inB, int maxRecvSize) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int recv(byte[] buf, int off, int len) throws IOException {
        return this.getInput().readDirect(buf, off, len);
    }

    @Override
    public void send(byte[] buf, int off, int length) throws IOException {
        this.getOutput().writeDirect(buf, off, length, 1);
    }

    @Override
    public int getPipeType() {
        return this.pipe.getPipeType();
    }

    @Override
    public synchronized void close() throws CIFSException {
        boolean wasOpen = this.isOpen();
        this.open = false;
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
        try {
            if (wasOpen) {
                this.handle.close();
            } else if (this.handle != null) {
                this.handle.release();
            }
            this.handle = null;
        }
        finally {
            if (this.treeHandle != null) {
                this.treeHandle.release();
            }
        }
    }
}

