/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.DialectVersion;
import jcifs.RuntimeCIFSException;
import jcifs.SmbSession;
import jcifs.internal.CommonServerMessageBlock;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.CommonServerMessageBlockResponse;
import jcifs.internal.SMBSigningDigest;
import jcifs.internal.smb1.SMB1SigningDigest;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.smb1.com.SmbComNegotiateResponse;
import jcifs.internal.smb1.com.SmbComSessionSetupAndX;
import jcifs.internal.smb1.com.SmbComSessionSetupAndXResponse;
import jcifs.internal.smb2.ServerMessageBlock2;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.smb2.Smb2SigningDigest;
import jcifs.internal.smb2.nego.Smb2NegotiateResponse;
import jcifs.internal.smb2.session.Smb2SessionSetupRequest;
import jcifs.internal.smb2.session.Smb2SessionSetupResponse;
import jcifs.smb.CredentialsInternal;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.RequestParam;
import jcifs.smb.SSPContext;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSessionInternal;
import jcifs.smb.SmbTransportImpl;
import jcifs.smb.SmbTreeImpl;
import jcifs.smb.SmbUnsupportedOperationException;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SmbSessionImpl
implements SmbSessionInternal {
    private static final Logger log = LoggerFactory.getLogger(SmbSessionImpl.class);
    private final AtomicInteger connectionState = new AtomicInteger();
    private int uid;
    private List<SmbTreeImpl> trees;
    private final SmbTransportImpl transport;
    private long expiration;
    private String netbiosName = null;
    private CIFSContext transportContext;
    private CredentialsInternal credentials;
    private byte[] sessionKey;
    private boolean extendedSecurity;
    private final AtomicLong usageCount = new AtomicLong(1L);
    private final AtomicBoolean transportAcquired = new AtomicBoolean(true);
    private long sessionId;
    private SMBSigningDigest digest;
    private final String targetDomain;
    private final String targetHost;
    private byte[] preauthIntegrityHash;

    SmbSessionImpl(CIFSContext tf, String targetHost, String targetDomain, SmbTransportImpl transport) {
        this.transportContext = tf;
        this.targetDomain = targetDomain;
        this.targetHost = targetHost;
        this.transport = transport.acquire();
        this.trees = new ArrayList<SmbTreeImpl>();
        this.credentials = tf.getCredentials().unwrap(CredentialsInternal.class).clone();
    }

    @Override
    public final Configuration getConfig() {
        return this.transportContext.getConfig();
    }

    public final String getTargetDomain() {
        return this.targetDomain;
    }

    public final String getTargetHost() {
        return this.targetHost;
    }

    @Override
    public boolean isInUse() {
        return this.usageCount.get() > 0L;
    }

    @Override
    public <T extends SmbSession> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new ClassCastException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmbSessionImpl acquire() {
        long usage = this.usageCount.incrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Acquire session " + usage + " " + this);
        }
        if (usage == 1L) {
            SmbSessionImpl smbSessionImpl = this;
            synchronized (smbSessionImpl) {
                if (this.transportAcquired.compareAndSet(false, true)) {
                    log.debug("Reacquire transport");
                    this.transport.acquire();
                }
            }
        }
        return this;
    }

    protected void finalize() throws Throwable {
        if (this.isConnected() && this.usageCount.get() != 0L) {
            log.warn("Session was not properly released");
        }
    }

    @Override
    public void close() {
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        long usage = this.usageCount.decrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Release session " + usage + " " + this);
        }
        if (usage == 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Usage dropped to zero, release connection " + this.transport);
            }
            SmbSessionImpl smbSessionImpl = this;
            synchronized (smbSessionImpl) {
                if (this.transportAcquired.compareAndSet(true, false)) {
                    this.transport.release();
                }
            }
        } else if (usage < 0L) {
            throw new RuntimeCIFSException("Usage count dropped below zero");
        }
    }

    @Override
    public byte[] getSessionKey() throws CIFSException {
        if (this.sessionKey == null) {
            throw new CIFSException("No session key available");
        }
        return this.sessionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmbTreeImpl getSmbTree(String share, String service) {
        if (share == null) {
            share = "IPC$";
        }
        List<SmbTreeImpl> list = this.trees;
        synchronized (list) {
            SmbTreeImpl t2;
            for (SmbTreeImpl t2 : this.trees) {
                if (!t2.matches(share, service)) continue;
                return t2.acquire();
            }
            t2 = new SmbTreeImpl(this, share, service);
            t2.acquire();
            this.trees.add(t2);
            return t2;
        }
    }

    @Override
    public void treeConnectLogon() throws SmbException {
        String logonShare = this.getContext().getConfig().getLogonShare();
        if (logonShare == null || logonShare.isEmpty()) {
            throw new SmbException("Logon share is not defined");
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (SmbTreeImpl t = this.getSmbTree(logonShare, null);){
                t.treeConnect(null, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    boolean isSignatureSetupRequired() throws SmbException {
        SMBSigningDigest cur = this.getDigest();
        if (cur != null) {
            return false;
        }
        if (this.transport.isSigningEnforced()) {
            return true;
        }
        return this.transport.getNegotiateResponse().isSigningNegotiated();
    }

    private void setDigest(SMBSigningDigest digest) throws SmbException {
        if (this.transport.isSMB2()) {
            this.digest = digest;
        } else {
            this.transport.setDigest(digest);
        }
    }

    public SMBSigningDigest getDigest() throws SmbException {
        if (this.digest != null) {
            return this.digest;
        }
        return this.transport.getDigest();
    }

    protected boolean matches(CIFSContext tf, String thost, String tdom) {
        return Objects.equals(this.getCredentials(), tf.getCredentials()) && Objects.equals(this.targetHost, thost) && Objects.equals(this.targetDomain, tdom);
    }

    <T extends CommonServerMessageBlockResponse> T send(CommonServerMessageBlockRequest request, T response) throws CIFSException {
        return this.send(request, response, Collections.emptySet());
    }

    /*
     * Exception decompiling
     */
    <T extends CommonServerMessageBlockResponse> T send(CommonServerMessageBlockRequest request, T response, Set<RequestParam> params) throws CIFSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    <T extends CommonServerMessageBlock> T sessionSetup(CommonServerMessageBlockRequest chained, T chainedResponse) throws CIFSException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 21[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T extends CommonServerMessageBlock> T sessionSetupSMB2(SmbTransportImpl trans, String tdomain, ServerMessageBlock2Request<?> chain, T andxResponse) throws CIFSException, GeneralSecurityException {
        boolean signed;
        Smb2NegotiateResponse negoResp = (Smb2NegotiateResponse)trans.getNegotiateResponse();
        Smb2SessionSetupRequest request = null;
        ServerMessageBlock2Response response = null;
        SmbException ex = null;
        SSPContext ctx = null;
        byte[] token = negoResp.getSecurityBlob();
        int securityMode = (negoResp.getSecurityMode() & 2) != 0 || trans.isSigningEnforced() ? 2 : 1;
        boolean anonymous = this.credentials.isAnonymous();
        long sessId = 0L;
        boolean preauthIntegrity = negoResp.getSelectedDialect().atLeast(DialectVersion.SMB311);
        byte[] byArray = this.preauthIntegrityHash = preauthIntegrity ? trans.getPreauthIntegrityHash() : null;
        if (this.preauthIntegrityHash != null && log.isDebugEnabled()) {
            log.debug("Initial session preauth hash " + Hexdump.toHexString(this.preauthIntegrityHash));
        }
        do {
            Subject s = this.credentials.getSubject();
            if (ctx == null) {
                ctx = this.createContext(trans, tdomain, negoResp, !anonymous, s);
            }
            if ((token = SmbSessionImpl.createToken(ctx, token, s)) == null) continue;
            request = new Smb2SessionSetupRequest(this.getContext(), securityMode, negoResp.getCommonCapabilities(), 0L, token);
            request.setSessionId(sessId);
            request.retainPayload();
            try {
                response = trans.send(request, null, EnumSet.of(RequestParam.RETAIN_PAYLOAD));
                sessId = response.getSessionId();
            }
            catch (SmbAuthException sae) {
                throw sae;
            }
            catch (SmbException e) {
                Smb2SessionSetupResponse sessResponse = (Smb2SessionSetupResponse)request.getResponse();
                if (e.getNtStatus() == -1073741811) {
                    throw new SmbAuthException("Login failed", (Throwable)e);
                }
                if (!sessResponse.isReceived() || sessResponse.isError() || sessResponse.getStatus() != 0 && sessResponse.getStatus() != -1073741802) {
                    throw e;
                }
                ex = e;
                response = sessResponse;
            }
            if (!this.getConfig().isAllowGuestFallback() && ((Smb2SessionSetupResponse)response).isLoggedInAsGuest() && !this.credentials.isGuest() && !this.credentials.isAnonymous()) {
                throw new SmbAuthException(-1073741715);
            }
            if (!this.credentials.isAnonymous() && ((Smb2SessionSetupResponse)response).isLoggedInAsGuest()) {
                anonymous = true;
            }
            if ((((Smb2SessionSetupResponse)response).getSessionFlags() & 4) != 0) {
                throw new SmbUnsupportedOperationException("Server requires encryption, not yet supported.");
            }
            if (preauthIntegrity) {
                byte[] reqBytes = request.getRawPayload();
                this.preauthIntegrityHash = trans.calculatePreauthHash(reqBytes, 0, reqBytes.length, this.preauthIntegrityHash);
                if (response.getStatus() == -1073741802) {
                    byte[] respBytes = response.getRawPayload();
                    this.preauthIntegrityHash = trans.calculatePreauthHash(respBytes, 0, respBytes.length, this.preauthIntegrityHash);
                }
            }
            token = ((Smb2SessionSetupResponse)response).getBlob();
        } while (!ctx.isEstablished());
        log.debug("Context is established");
        this.setNetbiosName(ctx.getNetbiosName());
        byte[] sk = ctx.getSigningKey();
        if (sk != null) {
            byte[] key = new byte[16];
            System.arraycopy(sk, 0, key, 0, Math.min(16, sk.length));
            this.sessionKey = key;
        }
        boolean bl = signed = response != null && response.isSigned();
        if (!anonymous && (this.isSignatureSetupRequired() || signed)) {
            byte[] signingKey = ctx.getSigningKey();
            if (signingKey != null && response != null) {
                if (this.preauthIntegrityHash != null && log.isDebugEnabled()) {
                    log.debug("Final preauth integrity hash " + Hexdump.toHexString(this.preauthIntegrityHash));
                }
                Smb2SigningDigest dgst = new Smb2SigningDigest(this.sessionKey, negoResp.getDialectRevision(), this.preauthIntegrityHash);
                if (negoResp.getSelectedDialect().atLeast(DialectVersion.SMB300) || response.isSigned()) {
                    response.setDigest(dgst);
                    byte[] payload = response.getRawPayload();
                    if (!response.verifySignature(payload, 0, payload.length)) {
                        throw new SmbException("Signature validation failed");
                    }
                }
                this.setDigest(dgst);
            } else if (trans.getContext().getConfig().isSigningEnabled()) {
                throw new SmbException("Signing enabled but no session key available");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("No digest setup " + anonymous + " B " + this.isSignatureSetupRequired());
        }
        this.setSessionSetup((Smb2SessionSetupResponse)response);
        if (ex != null) {
            throw ex;
        }
        return (T)(response != null ? response.getNextResponse() : null);
    }

    private static byte[] createToken(final SSPContext ctx, final byte[] token, Subject s) throws CIFSException {
        if (s != null) {
            try {
                return Subject.doAs(s, new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws Exception {
                        return ctx.initSecContext(token, 0, token == null ? 0 : token.length);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof SmbException) {
                    throw (SmbException)e.getException();
                }
                throw new SmbException("Unexpected exception during context initialization", (Throwable)e);
            }
        }
        return ctx.initSecContext(token, 0, token == null ? 0 : token.length);
    }

    protected SSPContext createContext(SmbTransportImpl trans, final String tdomain, final Smb2NegotiateResponse negoResp, final boolean doSigning, Subject s) throws SmbException {
        String host = this.getTargetHost();
        if (host == null) {
            host = trans.getRemoteAddress().getHostAddress();
            try {
                host = trans.getRemoteAddress().getHostName();
            }
            catch (Exception e) {
                log.debug("Failed to resolve host name", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Remote host is " + host);
        }
        if (s == null) {
            return this.credentials.createContext(this.getContext(), tdomain, host, negoResp.getSecurityBlob(), doSigning);
        }
        try {
            final String hostName = host;
            return Subject.doAs(s, new PrivilegedExceptionAction<SSPContext>(){

                @Override
                public SSPContext run() throws Exception {
                    return SmbSessionImpl.this.getCredentials().createContext(SmbSessionImpl.this.getContext(), tdomain, hostName, negoResp.getSecurityBlob(), doSigning);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof SmbException) {
                throw (SmbException)e.getException();
            }
            throw new SmbException("Unexpected exception during context initialization", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends CommonServerMessageBlock> T reauthenticate(SmbTransportImpl trans, String tdomain, CommonServerMessageBlockRequest chain, T andxResponse, Set<RequestParam> params) throws CIFSException {
        SmbException ex = null;
        ServerMessageBlock2Response response = null;
        Smb2NegotiateResponse negoResp = (Smb2NegotiateResponse)trans.getNegotiateResponse();
        byte[] token = negoResp.getSecurityBlob();
        int securityMode = negoResp.getSecurityMode();
        boolean anonymous = this.credentials.isAnonymous();
        boolean doSigning = securityMode != 0 && !anonymous;
        long newSessId = 0L;
        long curSessId = this.sessionId;
        SmbTransportImpl smbTransportImpl = trans;
        synchronized (smbTransportImpl) {
            CommonServerMessageBlockResponse cresp;
            this.credentials.refresh();
            Subject s = this.credentials.getSubject();
            SSPContext ctx = this.createContext(trans, tdomain, negoResp, doSigning, s);
            do {
                if ((token = SmbSessionImpl.createToken(ctx, token, s)) != null) {
                    Smb2SessionSetupRequest request = new Smb2SessionSetupRequest(this.getContext(), negoResp.getSecurityMode(), negoResp.getCommonCapabilities(), curSessId, token);
                    if (chain != null) {
                        request.chain((ServerMessageBlock2)((Object)chain));
                    }
                    request.setDigest(this.digest);
                    request.setSessionId(curSessId);
                    try {
                        response = trans.send(request, null, EnumSet.of(RequestParam.RETAIN_PAYLOAD));
                        newSessId = response.getSessionId();
                        if (newSessId != curSessId) {
                            throw new SmbAuthException("Server did not reauthenticate after expiration");
                        }
                    }
                    catch (SmbAuthException sae) {
                        throw sae;
                    }
                    catch (SmbException e) {
                        Smb2SessionSetupResponse sessResponse = (Smb2SessionSetupResponse)request.getResponse();
                        if (!sessResponse.isReceived() || sessResponse.isError() || sessResponse.getStatus() != 0 && sessResponse.getStatus() != -1073741802) {
                            throw e;
                        }
                        ex = e;
                        response = sessResponse;
                    }
                    if (!this.getConfig().isAllowGuestFallback() && ((Smb2SessionSetupResponse)response).isLoggedInAsGuest() && !this.credentials.isGuest() && !this.credentials.isAnonymous()) {
                        throw new SmbAuthException(-1073741715);
                    }
                    if (!this.credentials.isAnonymous() && ((Smb2SessionSetupResponse)response).isLoggedInAsGuest()) {
                        anonymous = true;
                    }
                    if (request.getDigest() != null) {
                        log.debug("Setting digest");
                        this.setDigest(request.getDigest());
                    }
                    token = ((Smb2SessionSetupResponse)response).getBlob();
                }
                if (ex == null) continue;
                throw ex;
            } while (!ctx.isEstablished());
            this.setSessionSetup((Smb2SessionSetupResponse)response);
            CommonServerMessageBlockResponse commonServerMessageBlockResponse = cresp = response != null ? response.getNextResponse() : null;
            if (cresp != null && cresp.isReceived()) {
                return (T)cresp;
            }
            if (chain != null) {
                return this.transport.send(chain, null, params);
            }
            return null;
        }
    }

    @Override
    public void reauthenticate() throws CIFSException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (SmbTransportImpl trans = this.getTransport();){
            this.reauthenticate(trans, this.targetDomain, null, null, Collections.EMPTY_SET);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void sessionSetupSMB1(SmbTransportImpl trans, final String tdomain, ServerMessageBlock andx, ServerMessageBlock andxResponse) throws CIFSException, GeneralSecurityException {
        ex = null;
        request = null;
        response = null;
        ctx = null;
        token = new byte[]{};
        state = 10;
        negoResp = (SmbComNegotiateResponse)trans.getNegotiateResponse();
        anonymous = this.credentials.isAnonymous();
        block29: do {
            switch (state) {
                case 10: {
                    if (trans.hasCapability(-2147483648)) {
                        SmbSessionImpl.log.debug("Extended security negotiated");
                        state = 20;
                        break;
                    }
                    if (this.getContext().getConfig().isForceExtendedSecurity()) {
                        throw new SmbException("Server does not supported extended security");
                    }
                    SmbSessionImpl.log.debug("Performing legacy session setup");
                    if (!(this.credentials instanceof NtlmPasswordAuthenticator)) {
                        throw new SmbAuthException("Incompatible credentials");
                    }
                    npa = (NtlmPasswordAuthenticator)this.credentials;
                    request = new SmbComSessionSetupAndX(this.getContext(), negoResp, andx, this.getCredentials());
                    request.setDigest(this.getDigest());
                    response = new SmbComSessionSetupAndXResponse(this.getContext().getConfig(), andxResponse);
                    response.setExtendedSecurity(false);
                    if (anonymous || !this.isSignatureSetupRequired()) ** GOTO lbl66
                    if (!SmbSessionImpl.isExternalAuth(this.getContext(), npa)) ** GOTO lbl61
                    var14_14 = null;
                    var15_18 = null;
                    try {
                        smbSession = trans.getSmbSession(this.getContext().withDefaultCredentials());
                        try {
                            t = smbSession.getSmbTree(this.getContext().getConfig().getLogonShare(), null);
                            try {
                                t.treeConnect(null, null);
                            }
                            finally {
                                if (t != null) {
                                    t.close();
                                }
                            }
                            if (smbSession == null) ** GOTO lbl66
                            smbSession.close();
                        }
                        catch (Throwable var15_19) {
                            if (var14_14 == null) {
                                var14_14 = var15_19;
                            } else if (var14_14 != var15_19) {
                                var14_14.addSuppressed(var15_19);
                            }
                            if (smbSession != null) {
                                smbSession.close();
                            }
                            throw var14_14;
                        }
                    }
                    catch (Throwable var15_20) {
                        if (var14_14 == null) {
                            var14_14 = var15_20;
                        } else if (var14_14 != var15_20) {
                            var14_14.addSuppressed(var15_20);
                        }
                        throw var14_14;
                    }
lbl61:
                    // 1 sources

                    SmbSessionImpl.log.debug("Initialize signing");
                    signingKey = npa.getSigningKey(this.getContext(), negoResp.getServerData().encryptionKey);
                    if (signingKey == null) {
                        throw new SmbException("Need a signature key but the server did not provide one");
                    }
                    request.setDigest(new SMB1SigningDigest(signingKey, false));
lbl66:
                    // 4 sources

                    try {
                        trans.send(request, response);
                    }
                    catch (SmbAuthException sae) {
                        throw sae;
                    }
                    catch (SmbException se) {
                        ex = se;
                    }
                    if (!this.getConfig().isAllowGuestFallback() && response.isLoggedInAsGuest() && negoResp.getServerData().security != 0 && !this.credentials.isGuest() && !this.credentials.isAnonymous()) {
                        throw new SmbAuthException(-1073741715);
                    }
                    if (!this.credentials.isAnonymous() && response.isLoggedInAsGuest()) {
                        anonymous = true;
                    }
                    if (ex != null) {
                        throw ex;
                    }
                    this.setUid(response.getUid());
                    if (request.getDigest() != null) {
                        this.setDigest(request.getDigest());
                    } else if (!anonymous && this.isSignatureSetupRequired()) {
                        throw new SmbException("Signing required but no session key available");
                    }
                    this.setSessionSetup(response);
                    state = 0;
                    break;
                }
                case 20: {
                    s = this.credentials.getSubject();
                    doSigning = anonymous == false && (negoResp.getNegotiatedFlags2() & 4) != 0;
                    curToken = token;
                    if (ctx == null) {
                        host = this.getTargetHost();
                        if (host == null) {
                            host = trans.getRemoteAddress().getHostAddress();
                            try {
                                host = trans.getRemoteAddress().getHostName();
                            }
                            catch (Exception e) {
                                SmbSessionImpl.log.debug("Failed to resolve host name", (Throwable)e);
                            }
                        }
                        if (SmbSessionImpl.log.isDebugEnabled()) {
                            SmbSessionImpl.log.debug("Remote host is " + host);
                        }
                        if (s == null) {
                            ctx = this.credentials.createContext(this.getContext(), tdomain, host, negoResp.getServerData().encryptionKey, doSigning);
                        } else {
                            try {
                                hostName = host;
                                ctx = Subject.doAs(s, new PrivilegedExceptionAction<SSPContext>(){

                                    @Override
                                    public SSPContext run() throws Exception {
                                        return SmbSessionImpl.this.getCredentials().createContext(SmbSessionImpl.this.getContext(), tdomain, hostName, negoResp.getServerData().encryptionKey, doSigning);
                                    }
                                });
                            }
                            catch (PrivilegedActionException e) {
                                if (e.getException() instanceof SmbException) {
                                    throw (SmbException)e.getException();
                                }
                                throw new SmbException("Unexpected exception during context initialization", (Throwable)e);
                            }
                        }
                    }
                    curCtx = ctx;
                    if (SmbSessionImpl.log.isTraceEnabled()) {
                        SmbSessionImpl.log.trace(ctx.toString());
                    }
                    try {
                        if (s == null) ** GOTO lbl127
                        try {
                            token = Subject.doAs(s, new PrivilegedExceptionAction<byte[]>((SSPContext)curCtx, curToken){
                                private final /* synthetic */ SSPContext val$curCtx;
                                private final /* synthetic */ byte[] val$curToken;
                                {
                                    this.val$curCtx = sSPContext;
                                    this.val$curToken = byArray;
                                }

                                @Override
                                public byte[] run() throws Exception {
                                    return this.val$curCtx.initSecContext(this.val$curToken, 0, this.val$curToken == null ? 0 : this.val$curToken.length);
                                }
                            });
                            ** GOTO lbl139
                        }
                        catch (PrivilegedActionException e) {
                            if (e.getException() instanceof SmbException) {
                                throw (SmbException)e.getException();
                            }
                            throw new SmbException("Unexpected exception during context initialization", (Throwable)e);
                        }
lbl127:
                        // 1 sources

                        token = ctx.initSecContext(token, 0, token == null ? 0 : token.length);
                    }
                    catch (SmbException se) {
                        try {
                            SmbSessionImpl.log.warn("Exception during SSP authentication", (Throwable)se);
                            trans.disconnect(true);
                        }
                        catch (IOException v0) {
                            SmbSessionImpl.log.debug("Disconnect failed");
                        }
                        this.setUid(0);
                        throw se;
                    }
lbl139:
                    // 2 sources

                    if (token != null) {
                        request = new SmbComSessionSetupAndX(this.getContext(), negoResp, null, token);
                        request.setDigest(this.getDigest());
                        if (doSigning && ctx.isEstablished() && this.isSignatureSetupRequired()) {
                            signingKey = ctx.getSigningKey();
                            if (signingKey != null) {
                                request.setDigest(new SMB1SigningDigest(signingKey));
                            }
                            this.sessionKey = signingKey;
                        } else {
                            SmbSessionImpl.log.trace("Not yet initializing signing");
                        }
                        response = new SmbComSessionSetupAndXResponse(this.getContext().getConfig(), null);
                        response.setExtendedSecurity(true);
                        request.setUid(this.getUid());
                        this.setUid(0);
                        try {
                            trans.send(request, response);
                        }
                        catch (SmbAuthException sae) {
                            throw sae;
                        }
                        catch (SmbException se) {
                            ex = se;
                            if (se.getNtStatus() == -1073741811) {
                                ex = new SmbAuthException("Login failed", (Throwable)se);
                            }
                            try {
                                trans.disconnect(true);
                            }
                            catch (Exception e) {
                                SmbSessionImpl.log.debug("Failed to disconnect transport", (Throwable)e);
                            }
                        }
                        if (!this.getConfig().isAllowGuestFallback() && response.isLoggedInAsGuest() && !this.credentials.isGuest() && !this.credentials.isAnonymous()) {
                            throw new SmbAuthException(-1073741715);
                        }
                        if (!this.credentials.isAnonymous() && response.isLoggedInAsGuest()) {
                            anonymous = true;
                        }
                        if (ex != null) {
                            throw ex;
                        }
                        this.setUid(response.getUid());
                        if (request.getDigest() != null) {
                            SmbSessionImpl.log.debug("Setting digest");
                            this.setDigest(request.getDigest());
                        }
                        token = response.getBlob();
                    }
                    if (!ctx.isEstablished()) continue block29;
                    SmbSessionImpl.log.debug("Context is established");
                    this.setNetbiosName(ctx.getNetbiosName());
                    this.sessionKey = ctx.getSigningKey();
                    if (request != null && request.getDigest() != null) {
                        this.setDigest(request.getDigest());
                    } else if (!anonymous && this.isSignatureSetupRequired()) {
                        signingKey = ctx.getSigningKey();
                        if (signingKey != null && response != null) {
                            this.setDigest(new SMB1SigningDigest(signingKey, 2));
                        } else if (trans.getContext().getConfig().isSigningEnabled()) {
                            throw new SmbException("Signing required but no session key available");
                        }
                        this.sessionKey = signingKey;
                    }
                    this.setSessionSetup(response);
                    state = 0;
                    break;
                }
                default: {
                    throw new SmbException("Unexpected session setup state: " + state);
                }
            }
        } while (state != 0);
    }

    private static boolean isExternalAuth(CIFSContext tc, NtlmPasswordAuthenticator npa) {
        return npa instanceof NtlmPasswordAuthentication && ((NtlmPasswordAuthentication)npa).areHashesExternal() && tc.getConfig().getDefaultPassword() != null;
    }

    /*
     * Exception decompiling
     */
    boolean logoff(boolean inError, boolean inUse) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return "SmbSession[credentials=" + this.transportContext.getCredentials() + ",targetHost=" + this.targetHost + ",targetDomain=" + this.targetDomain + ",uid=" + this.uid + ",connectionState=" + this.connectionState + ",usage=" + this.usageCount.get() + "]";
    }

    void setUid(int uid) {
        this.uid = uid;
    }

    void setSessionSetup(Smb2SessionSetupResponse response) {
        this.extendedSecurity = true;
        this.connectionState.set(2);
        this.sessionId = response.getSessionId();
    }

    void setSessionSetup(SmbComSessionSetupAndXResponse response) {
        this.extendedSecurity = response.isExtendedSecurity();
        this.connectionState.set(2);
    }

    void setNetbiosName(String netbiosName) {
        this.netbiosName = netbiosName;
    }

    @Override
    public CIFSContext getContext() {
        return this.transport.getContext();
    }

    @Override
    public SmbTransportImpl getTransport() {
        return this.transport.acquire();
    }

    public int getUid() {
        return this.uid;
    }

    public Long getExpiration() {
        return this.expiration > 0L ? Long.valueOf(this.expiration) : null;
    }

    public CredentialsInternal getCredentials() {
        return this.credentials;
    }

    public boolean isConnected() {
        return !this.transport.isDisconnected() && this.connectionState.get() == 2;
    }

    public boolean isFailed() {
        return this.transport.isFailed();
    }
}

