/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.RuntimeCIFSException;
import jcifs.SmbTreeHandle;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.CommonServerMessageBlockResponse;
import jcifs.internal.Request;
import jcifs.internal.SmbNegotiationResponse;
import jcifs.internal.smb1.com.SmbComNegotiateResponse;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbException;
import jcifs.smb.SmbResourceLocatorImpl;
import jcifs.smb.SmbSessionImpl;
import jcifs.smb.SmbTransportImpl;
import jcifs.smb.SmbTreeConnection;
import jcifs.smb.SmbTreeHandleInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbTreeHandleImpl
implements SmbTreeHandleInternal {
    private static final Logger log = LoggerFactory.getLogger(SmbTreeHandleImpl.class);
    private final SmbResourceLocatorImpl resourceLoc;
    private final SmbTreeConnection treeConnection;
    private final AtomicLong usageCount = new AtomicLong(1L);

    public SmbTreeHandleImpl(SmbResourceLocatorImpl resourceLoc, SmbTreeConnection treeConnection) {
        this.resourceLoc = resourceLoc;
        this.treeConnection = treeConnection.acquire();
    }

    @Override
    public SmbSessionImpl getSession() {
        return this.treeConnection.getSession();
    }

    @Override
    public void ensureDFSResolved() throws CIFSException {
        this.treeConnection.ensureDFSResolved(this.resourceLoc);
    }

    @Override
    public boolean hasCapability(int cap) throws SmbException {
        return this.treeConnection.hasCapability(cap);
    }

    @Override
    public boolean isConnected() {
        return this.treeConnection.isConnected();
    }

    @Override
    public Configuration getConfig() {
        return this.treeConnection.getConfig();
    }

    public long getTreeId() {
        return this.treeConnection.getTreeId();
    }

    public <T extends CommonServerMessageBlockResponse> T send(Request<T> req, RequestParam ... params) throws CIFSException {
        return this.send((CommonServerMessageBlockRequest)req, null, params);
    }

    public <T extends CommonServerMessageBlockResponse> T send(CommonServerMessageBlockRequest request, T response, RequestParam ... params) throws CIFSException {
        return this.treeConnection.send(this.resourceLoc, request, response, params);
    }

    public <T extends CommonServerMessageBlockResponse> T send(CommonServerMessageBlockRequest request, T response, Set<RequestParam> params) throws CIFSException {
        return this.treeConnection.send(this.resourceLoc, request, response, params);
    }

    @Override
    public synchronized void close() {
        this.release();
    }

    public SmbTreeHandleImpl acquire() {
        if (this.usageCount.incrementAndGet() == 1L) {
            this.treeConnection.acquire();
        }
        return this;
    }

    @Override
    public void release() {
        long us = this.usageCount.decrementAndGet();
        if (us == 0L) {
            this.treeConnection.release();
        } else if (us < 0L) {
            throw new RuntimeCIFSException("Usage count dropped below zero");
        }
    }

    protected void finalize() throws Throwable {
        if (this.usageCount.get() != 0L) {
            log.warn("Tree handle was not properly released " + this.resourceLoc.getURL());
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public String getRemoteHostName() {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            String string;
            SmbTransportImpl transport;
            SmbSessionImpl session;
            block16: {
                block15: {
                    session = this.treeConnection.getSession();
                    transport = session.getTransport();
                    string = transport.getRemoteHostName();
                    if (transport == null) break block15;
                    transport.close();
                }
                if (session == null) break block16;
                session.close();
            }
            return string;
            {
                catch (Throwable throwable2) {
                    try {
                        if (transport != null) {
                            transport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getServerTimeZoneOffset() throws SmbException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            SmbTransportImpl transport;
            SmbSessionImpl session;
            block13: {
                long l;
                block14: {
                    session = this.treeConnection.getSession();
                    transport = session.getTransport();
                    SmbNegotiationResponse nego = transport.getNegotiateResponse();
                    if (!(nego instanceof SmbComNegotiateResponse)) break block13;
                    l = (long)(((SmbComNegotiateResponse)nego).getServerData().serverTimeZone * 1000) * 60L;
                    if (transport == null) break block14;
                    transport.close();
                }
                if (session == null) return l;
                session.close();
                return l;
            }
            if (transport != null) {
                transport.close();
            }
            if (session == null) return 0L;
            session.close();
            return 0L;
            {
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (session == null) throw throwable;
                    session.close();
                    throw throwable;
                }
            }
            {
                catch (Throwable throwable3) {
                    if (transport == null) throw throwable3;
                    transport.close();
                    throw throwable3;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getOEMDomainName() throws SmbException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            SmbTransportImpl transport;
            SmbSessionImpl session;
            block13: {
                String string;
                block14: {
                    session = this.treeConnection.getSession();
                    transport = session.getTransport();
                    SmbNegotiationResponse nego = transport.getNegotiateResponse();
                    if (!(nego instanceof SmbComNegotiateResponse)) break block13;
                    string = ((SmbComNegotiateResponse)nego).getServerData().oemDomainName;
                    if (transport == null) break block14;
                    transport.close();
                }
                if (session == null) return string;
                session.close();
                return string;
            }
            if (transport != null) {
                transport.close();
            }
            if (session == null) return null;
            session.close();
            return null;
            {
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (session == null) throw throwable;
                    session.close();
                    throw throwable;
                }
            }
            {
                catch (Throwable throwable3) {
                    if (transport == null) throw throwable3;
                    transport.close();
                    throw throwable3;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    @Override
    public int getTreeType() {
        return this.treeConnection.getTreeType();
    }

    @Override
    public String getConnectedShare() {
        return this.treeConnection.getConnectedShare();
    }

    @Override
    public boolean isSameTree(SmbTreeHandle th) {
        if (!(th instanceof SmbTreeHandleImpl)) {
            return false;
        }
        return this.treeConnection.isSame(((SmbTreeHandleImpl)th).treeConnection);
    }

    /*
     * Loose catch block
     */
    @Override
    public int getSendBufferSize() throws SmbException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            int n;
            SmbTransportImpl transport;
            SmbSessionImpl session;
            block16: {
                block15: {
                    session = this.treeConnection.getSession();
                    transport = session.getTransport();
                    n = transport.getNegotiateResponse().getSendBufferSize();
                    if (transport == null) break block15;
                    transport.close();
                }
                if (session == null) break block16;
                session.close();
            }
            return n;
            {
                catch (Throwable throwable2) {
                    try {
                        if (transport != null) {
                            transport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int getReceiveBufferSize() throws SmbException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            int n;
            SmbTransportImpl transport;
            SmbSessionImpl session;
            block16: {
                block15: {
                    session = this.treeConnection.getSession();
                    transport = session.getTransport();
                    n = transport.getNegotiateResponse().getReceiveBufferSize();
                    if (transport == null) break block15;
                    transport.close();
                }
                if (session == null) break block16;
                session.close();
            }
            return n;
            {
                catch (Throwable throwable2) {
                    try {
                        if (transport != null) {
                            transport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int getMaximumBufferSize() throws SmbException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            int n;
            SmbTransportImpl transport;
            SmbSessionImpl session;
            block16: {
                block15: {
                    session = this.treeConnection.getSession();
                    transport = session.getTransport();
                    n = transport.getNegotiateResponse().getTransactionBufferSize();
                    if (transport == null) break block15;
                    transport.close();
                }
                if (session == null) break block16;
                session.close();
            }
            return n;
            {
                catch (Throwable throwable2) {
                    try {
                        if (transport != null) {
                            transport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean areSignaturesActive() throws SmbException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            boolean bl;
            SmbTransportImpl transport;
            SmbSessionImpl session;
            block16: {
                block15: {
                    session = this.treeConnection.getSession();
                    transport = session.getTransport();
                    bl = transport.getNegotiateResponse().isSigningNegotiated();
                    if (transport == null) break block15;
                    transport.close();
                }
                if (session == null) break block16;
                session.close();
            }
            return bl;
            {
                catch (Throwable throwable2) {
                    try {
                        if (transport != null) {
                            transport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean isSMB2() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                boolean bl;
                SmbTransportImpl transport;
                SmbSessionImpl session;
                block18: {
                    block17: {
                        session = this.treeConnection.getSession();
                        transport = session.getTransport();
                        bl = transport.isSMB2();
                        if (transport == null) break block17;
                        transport.close();
                    }
                    if (session == null) break block18;
                    session.close();
                }
                return bl;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (transport != null) {
                                transport.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (session != null) {
                                session.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SmbException e) {
            log.debug("Failed to connect for determining SMB2 support", (Throwable)e);
            return false;
        }
    }
}

