/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import jcifs.RuntimeCIFSException;
import jcifs.smb.RequestParam;
import jcifs.util.transport.ConnectionTimeoutException;
import jcifs.util.transport.Request;
import jcifs.util.transport.RequestTimeoutException;
import jcifs.util.transport.Response;
import jcifs.util.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Transport
implements Runnable,
AutoCloseable {
    private static int id = 0;
    private static final Logger log = LoggerFactory.getLogger(Transport.class);
    protected volatile int state = 0;
    protected String name = "Transport" + id++;
    private volatile Thread thread;
    private volatile TransportException te;
    protected final Object inLock = new Object();
    protected final Object outLock = new Object();
    protected final Map<Long, Response> response_map = new ConcurrentHashMap<Long, Response>(10);
    private final AtomicLong usageCount = new AtomicLong(1L);

    /*
     * Unable to fully structure code
     */
    public static int readn(InputStream in, byte[] b, int off, int len) throws IOException {
        i = 0;
        n = -5;
        if (off + len <= b.length) ** GOTO lbl7
        throw new IOException("Buffer too short, bufsize " + b.length + " read " + len);
        while ((n = in.read(b, off + i, len - i)) > 0) {
            i += n;
lbl7:
            // 2 sources

            if (i < len) continue;
        }
        return i;
    }

    public Transport acquire() {
        long usage = this.usageCount.incrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Acquire transport " + usage + " " + this);
        }
        return this;
    }

    @Override
    public void close() {
        this.release();
    }

    public void release() {
        long usage = this.usageCount.decrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Release transport " + usage + " " + this);
        }
        if (usage == 0L) {
            if (log.isTraceEnabled()) {
                log.trace("Transport usage dropped to zero " + this);
            }
        } else if (usage < 0L) {
            throw new RuntimeCIFSException("Usage count dropped below zero");
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isDisconnected() && this.usageCount.get() != 0L) {
            log.warn("Session was not properly released");
        }
    }

    protected long getUsageCount() {
        return this.usageCount.get();
    }

    protected abstract long makeKey(Request var1) throws IOException;

    protected abstract Long peekKey() throws IOException;

    protected abstract void doSend(Request var1) throws IOException;

    protected abstract void doRecv(Response var1) throws IOException;

    protected abstract void doSkip(Long var1) throws IOException;

    public boolean isDisconnected() {
        return this.state == 4 || this.state == 5 || this.state == 6 || this.state == 0;
    }

    public boolean isFailed() {
        return this.state == 5 || this.state == 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Response> T sendrecv(Request request, T response, Set<RequestParam> params) throws IOException {
        Request curReq;
        if (this.isDisconnected() && this.state != 5) {
            throw new TransportException("Transport is disconnected " + this.name);
        }
        try {
            long timeout = !params.contains((Object)RequestParam.NO_TIMEOUT) ? this.getResponseTimeout(request) : 0;
            long firstKey = this.doSend(request, response, params, timeout);
            if (Thread.currentThread() == this.thread) {
                Object object = this.inLock;
                synchronized (object) {
                    Long peekKey = this.peekKey();
                    if (peekKey == firstKey) {
                        this.doRecv(response);
                        response.received();
                        T t = response;
                    }
                    {
                        this.doSkip(peekKey);
                    }
                }
            }
            T t = this.waitForResponses(request, response, timeout);
            return t;
        }
        catch (IOException ioe) {
            log.warn("sendrecv failed", (Throwable)ioe);
            try {
                this.disconnect(true);
                throw ioe;
            }
            catch (IOException ioe2) {
                ioe.addSuppressed(ioe2);
                log.info("disconnect failed", (Throwable)ioe2);
            }
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw new TransportException(ie);
        }
        finally {
            T t = response;
            curReq = request;
        }
        while (true) {
            Throwable throwable;
            void var12_19;
            if (var12_19 == null) {
                throw throwable;
            }
            this.response_map.remove(var12_19.getMid());
            Request next = curReq.getNext();
            if (next == null) throw throwable;
            curReq = next;
            Response response2 = next.getResponse();
        }
    }

    protected <T extends Response> long doSend(Request request, T response, Set<RequestParam> params, long timeout) throws IOException {
        long firstKey = this.prepareRequests(request, response, params, timeout);
        this.doSend(request);
        return firstKey;
    }

    private <T extends Response> long prepareRequests(Request request, T response, Set<RequestParam> params, long timeout) throws IOException {
        Object curResp = response;
        Request curReq = request;
        long firstKey = 0L;
        while (curResp != null) {
            curResp.reset();
            if (params.contains((Object)RequestParam.RETAIN_PAYLOAD)) {
                curResp.retainPayload();
            }
            long k = this.makeKey(curReq);
            if (firstKey == 0L) {
                firstKey = k;
            }
            if (timeout > 0L) {
                curResp.setExpiration(System.currentTimeMillis() + timeout);
            } else {
                curResp.setExpiration(null);
            }
            curResp.setMid(k);
            this.response_map.put(k, (Response)curResp);
            Request next = curReq.getNext();
            if (next == null) break;
            curReq = next;
            curResp = next.getResponse();
        }
        return firstKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Response> T waitForResponses(Request request, T response, long timeout) throws InterruptedException, TransportException {
        Object curResp = response;
        Request curReq = request;
        while (curResp != null) {
            T t = curResp;
            synchronized (t) {
                if (!curResp.isReceived()) {
                    if (timeout > 0L) {
                        curResp.wait(timeout);
                        if (!curResp.isReceived() && this.handleIntermediate(curReq, curResp)) {
                            continue;
                        }
                        if (curResp.isError()) {
                            throw new TransportException(String.valueOf(this.name) + " error reading response to " + curReq, curResp.getException());
                        }
                        if (this.isDisconnected() && this.state != 5) {
                            throw new TransportException(String.format("Transport was disconnected while waiting for a response (transport: %s state: %d),", this.name, this.state));
                        }
                        timeout = curResp.getExpiration() - System.currentTimeMillis();
                        if (timeout <= 0L) {
                            if (log.isDebugEnabled()) {
                                log.debug("State is " + this.state);
                            }
                            throw new RequestTimeoutException(String.valueOf(this.name) + " timedout waiting for response to " + curReq);
                        }
                        continue;
                    }
                    curResp.wait();
                    if (this.handleIntermediate(request, curResp)) {
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Wait returned state is " + this.state);
                    }
                    if (this.isDisconnected()) {
                        throw new InterruptedException("Transport was disconnected while waiting for a response");
                    }
                    continue;
                }
            }
            Request next = curReq.getNext();
            if (next == null) break;
            curReq = next;
            curResp = next.getResponse();
        }
        return response;
    }

    protected <T extends Response> boolean handleIntermediate(Request request, T response) {
        return false;
    }

    protected abstract int getResponseTimeout(Request var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loop() {
        block18: while (this.thread == Thread.currentThread()) {
            Iterator<Response> iterator;
            try {
                Object object = this.inLock;
                synchronized (object) {
                    Response response;
                    Long key;
                    block36: {
                        SocketTimeoutException e2;
                        block37: {
                            try {
                                key = this.peekKey();
                                break block36;
                            }
                            catch (SocketTimeoutException e2) {
                                log.trace("Socket timeout during peekKey", (Throwable)e2);
                                if (this.getUsageCount() <= 0L) break block37;
                                if (log.isDebugEnabled()) {
                                    log.debug("Transport still in use, no idle timeout " + this);
                                }
                                iterator = this.response_map.values().iterator();
                            }
                            while (true) {
                                if (!iterator.hasNext()) {
                                    continue block18;
                                }
                                Response response2 = response = iterator.next();
                                synchronized (response2) {
                                    response.notifyAll();
                                }
                            }
                        }
                        if (!log.isDebugEnabled()) throw e2;
                        log.debug(String.format("Idle timeout on %s", this.name));
                        throw e2;
                    }
                    if (key == null) {
                        Transport e2 = this;
                        synchronized (e2) {
                            iterator = this.response_map.values().iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    throw new IOException("end of stream");
                                }
                                response = iterator.next();
                                response.error();
                            }
                        }
                    }
                    Response response3 = this.response_map.get(key);
                    if (response3 == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Unexpected message id, skipping message " + key);
                        }
                        this.doSkip(key);
                    } else {
                        this.doRecv(response3);
                        response3.received();
                    }
                }
            }
            catch (Exception ex) {
                boolean closed;
                String msg = ex.getMessage();
                boolean timeout = ex instanceof SocketTimeoutException || msg != null && msg.equals("Read timed out");
                boolean bl = closed = msg != null && msg.equals("Socket closed");
                if (closed) {
                    log.trace("Remote closed connection");
                } else if (timeout) {
                    log.debug("socket timeout in non peek state", (Throwable)ex);
                } else {
                    log.debug("recv failed", (Throwable)ex);
                }
                iterator = this;
                synchronized (iterator) {
                    try {
                        this.disconnect(!timeout, false);
                    }
                    catch (IOException ioe) {
                        ex.addSuppressed(ioe);
                        log.warn("Failed to disconnect", (Throwable)ioe);
                    }
                    log.debug("Disconnected");
                    boolean notified = false;
                    Iterator<Map.Entry<Long, Response>> iterator2 = this.response_map.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Response resp = iterator2.next().getValue();
                        resp.exception(ex);
                        iterator2.remove();
                        notified = true;
                    }
                    if (notified) {
                        log.debug("Notified clients");
                    } else {
                        log.debug("Exception without a request pending", (Throwable)ex);
                    }
                    return;
                }
            }
        }
        return;
    }

    protected abstract void doConnect() throws Exception;

    protected abstract boolean doDisconnect(boolean var1, boolean var2) throws IOException;

    /*
     * Exception decompiling
     */
    public synchronized boolean connect(long timeout) throws TransportException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void cleanupThread(long timeout) throws TransportException {
        Thread t = this.thread;
        if (t != null && Thread.currentThread() != t) {
            this.thread = null;
            try {
                log.debug("Interrupting transport thread");
                t.interrupt();
                log.debug("Joining transport thread");
                t.join(timeout);
                log.debug("Joined transport thread");
            }
            catch (InterruptedException e) {
                throw new TransportException("Failed to join transport thread", e);
            }
        } else if (t != null) {
            this.thread = null;
        }
    }

    public synchronized boolean disconnect(boolean hard) throws IOException {
        return this.disconnect(hard, true);
    }

    public synchronized boolean disconnect(boolean hard, boolean inUse) throws IOException {
        IOException ioe = null;
        switch (this.state) {
            case 0: 
            case 5: 
            case 6: {
                return false;
            }
            case 2: {
                hard = true;
            }
            case 3: {
                if (this.response_map.size() != 0 && !hard && inUse) break;
                try {
                    this.state = 5;
                    boolean wasInUse = this.doDisconnect(hard, inUse);
                    this.state = 6;
                    return wasInUse;
                }
                catch (IOException ioe0) {
                    this.state = 6;
                    ioe = ioe0;
                }
            }
            case 4: {
                this.thread = null;
                this.state = 6;
                break;
            }
            default: {
                log.error("Invalid state: " + this.state);
                this.thread = null;
                this.state = 6;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread run_thread = Thread.currentThread();
        Exception ex0 = null;
        try {
            try {
                if (this.state != 5 && this.state != 6) {
                    this.doConnect();
                }
            }
            catch (Exception ex) {
                ex0 = ex;
                Thread thread = run_thread;
                synchronized (thread) {
                    if (run_thread != this.thread) {
                        if (ex0 instanceof SocketTimeoutException) {
                            log.debug("Timeout connecting", (Throwable)ex0);
                        } else if (ex0 != null) {
                            log.warn("Exception in transport thread", (Throwable)ex0);
                        }
                        return;
                    }
                    if (ex0 instanceof SocketTimeoutException) {
                        this.te = new ConnectionTimeoutException(ex0);
                    } else if (ex0 != null) {
                        this.te = new TransportException(ex0);
                    }
                    this.state = 2;
                    run_thread.notify();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Thread thread = run_thread;
            synchronized (thread) {
                if (run_thread != this.thread) {
                    if (ex0 instanceof SocketTimeoutException) {
                        log.debug("Timeout connecting", (Throwable)ex0);
                    } else if (ex0 != null) {
                        log.warn("Exception in transport thread", (Throwable)ex0);
                    }
                    return;
                }
                if (ex0 instanceof SocketTimeoutException) {
                    this.te = new ConnectionTimeoutException(ex0);
                } else if (ex0 != null) {
                    this.te = new TransportException(ex0);
                }
                this.state = 2;
                run_thread.notify();
            }
            throw throwable;
        }
        Thread thread = run_thread;
        synchronized (thread) {
            if (run_thread != this.thread) {
                if (ex0 instanceof SocketTimeoutException) {
                    log.debug("Timeout connecting", (Throwable)ex0);
                } else if (ex0 != null) {
                    log.warn("Exception in transport thread", (Throwable)ex0);
                }
                return;
            }
            if (ex0 instanceof SocketTimeoutException) {
                this.te = new ConnectionTimeoutException(ex0);
            } else if (ex0 != null) {
                this.te = new TransportException(ex0);
            }
            this.state = 2;
            run_thread.notify();
        }
        this.loop();
    }

    public String toString() {
        return this.name;
    }
}

