/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.common;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jinterop.dcom.common.JIComVersion;

public final class JISystem {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    private static final Properties mapOfProgIdsVsClsids = new Properties();
    private static final List<Socket> socketQueue = new ArrayList<Socket>();
    private static final Map<String, String> mapOfHostnamesVsIPs = new HashMap<String, String>();
    private static String pathToDB = null;
    private static Locale locale = Locale.getDefault();
    private static ResourceBundle resourceBundle = null;
    private static JIComVersion comVersion = new JIComVersion();
    private static boolean autoRegister = false;
    private static boolean autoCollection = true;

    private JISystem() {
    }

    @Deprecated
    public static Logger getLogger() {
        return LOGGER;
    }

    public static void setCOMVersion(JIComVersion comVersion) {
        JISystem.comVersion = comVersion;
    }

    public static JIComVersion getCOMVersion() {
        return comVersion;
    }

    public static void setLocale(Locale locale) {
        JISystem.locale = locale;
    }

    public static Locale getLocale() {
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceBundle getErrorMessages() {
        if (resourceBundle != null) return resourceBundle;
        Class<JISystem> clazz = JISystem.class;
        synchronized (JISystem.class) {
            try {
                if (resourceBundle != null) return resourceBundle;
                resourceBundle = ResourceBundle.getBundle("org.jinterop.dcom.jierrormessages", locale);
            }
            catch (MissingResourceException missingResourceException) {
                resourceBundle = ResourceBundle.getBundle("org.jinterop.dcom.jierrormessages");
            }
            return resourceBundle;
        }
    }

    public static String getLocalizedMessage(int code) {
        String strKey = Integer.toHexString(code).toUpperCase();
        char[] buffer = new char[]{'0', 'x', '0', '0', '0', '0', '0', '0', '0', '0'};
        System.arraycopy(strKey.toCharArray(), 0, buffer, buffer.length - strKey.length(), strKey.length());
        return JISystem.getLocalizedMessage(String.valueOf(buffer));
    }

    private static String getLocalizedMessage(String key) {
        String message;
        try {
            message = JISystem.getErrorMessages().getString(key);
            message = String.valueOf(message) + " [" + key + "]";
        }
        catch (MissingResourceException missingResourceException) {
            message = "Message not found for errorCode: " + key;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getClsidFromProgId(String progId) {
        if (progId == null) {
            return null;
        }
        if (pathToDB != null) return (String)mapOfProgIdsVsClsids.get(progId);
        Class<JISystem> clazz = JISystem.class;
        synchronized (JISystem.class) {
            if (pathToDB != null) return (String)mapOfProgIdsVsClsids.get(progId);
            JISystem.saveDBPathAndLoadFile();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (String)mapOfProgIdsVsClsids.get(progId);
        }
    }

    private static void saveDBPathAndLoadFile() {
        Enumeration<URL> resources;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = JISystem.class.getClassLoader();
        }
        HashSet<URL> locations = new HashSet<URL>();
        if (loader != null) {
            try {
                resources = loader.getResources("progIdVsClsidDB.properties");
                if (resources.hasMoreElements()) {
                    locations.add(resources.nextElement());
                }
            }
            catch (IOException iOException) {}
        }
        try {
            if (locations.isEmpty() && (resources = ClassLoader.getSystemResources("progIdVsClsidDB.properties")).hasMoreElements()) {
                locations.add(resources.nextElement());
            }
        }
        catch (IOException iOException) {}
        Iterator iterator = locations.iterator();
        while (iterator.hasNext()) {
            try {
                URL url = (URL)iterator.next();
                pathToDB = url.getPath();
                try {
                    if (!pathToDB.startsWith("file:")) {
                        url = new URL("file:" + pathToDB);
                    }
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "progIdVsClsidDB file located at: {0}", url);
                    }
                    URLConnection con = url.openConnection();
                    Throwable throwable = null;
                    Object var6_7 = null;
                    try (InputStream inputStream = con.getInputStream();){
                        mapOfProgIdsVsClsids.load(inputStream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {}
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "progIdVsClsidDB: {0}", mapOfProgIdsVsClsids);
        }
    }

    public static void internal_writeProgIdsToFile() {
        if (pathToDB != null) {
            try {
                Throwable throwable = null;
                Object var1_4 = null;
                try (FileOutputStream outputStream = new FileOutputStream(pathToDB);){
                    mapOfProgIdsVsClsids.store(outputStream, "progId Vs ClsidDB");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.throwing("JISystem", "writeProgIdsToFile", e);
            }
            catch (IOException e) {
                LOGGER.throwing("JISystem", "writeProgIdsToFile", e);
            }
        }
    }

    public static void internal_setClsidtoProgId(String progId, String clsid) {
        mapOfProgIdsVsClsids.put(progId, clsid);
    }

    public static Socket internal_getSocket() {
        return socketQueue.remove(0);
    }

    public static void internal_setSocket(Socket socket) {
        socketQueue.add(socket);
    }

    public static synchronized void internal_initLogger() {
        JISystem.logSystemPropertiesAndVersion();
    }

    private static void logSystemPropertiesAndVersion() {
        Properties pr = System.getProperties();
        Iterator<Object> itr = pr.keySet().iterator();
        String str = "";
        String jinteropVersion = JISystem.class.getPackage().getImplementationVersion();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "j-Interop Version = {0}\n", jinteropVersion);
            while (itr.hasNext()) {
                String key = (String)itr.next();
                str = String.valueOf(str) + key + " = " + pr.getProperty(key) + "\n";
            }
            LOGGER.info(str);
        }
    }

    public static void setAutoRegisteration(boolean autoRegisteration) {
        autoRegister = autoRegisteration;
    }

    public static boolean isAutoRegistrationSet() {
        return autoRegister;
    }

    public static void setJavaCoClassAutoCollection(boolean autoCollection) {
        JISystem.autoCollection = autoCollection;
    }

    public static boolean isJavaCoClassAutoCollectionSet() {
        return autoCollection;
    }

    @Deprecated
    public static void setInBuiltLogHandler(boolean useParentHandlers) throws SecurityException, IOException {
        LOGGER.setUseParentHandlers(useParentHandlers);
        FileHandler fileHandler = new FileHandler("%t/j-Interop%g.log", 0, 1, true);
        fileHandler.setFormatter(new SimpleFormatter());
        LOGGER.addHandler(fileHandler);
    }

    public static synchronized void mapHostNametoIP(String hostname, String IP) throws UnknownHostException {
        if (hostname == null || IP == null || hostname.trim().length() == 0 || IP.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        InetAddress.getByName(IP.trim());
        mapOfHostnamesVsIPs.put(hostname.trim().toUpperCase(), IP.trim());
    }

    public static synchronized String getIPForHostName(String hostname) {
        return mapOfHostnamesVsIPs.get(hostname.trim().toUpperCase());
    }

    public static synchronized void internal_dumpMap() {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "mapOfHostnamesVsIPs: {0}", mapOfHostnamesVsIPs);
        }
    }
}

