/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import java.util.ArrayList;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.core.JISecurityBinding;
import org.jinterop.dcom.core.JIStringBinding;

final class JIDualStringArray
implements Serializable {
    private static final long serialVersionUID = -3351948896808028565L;
    private JIStringBinding[] stringBinding = null;
    private JISecurityBinding[] securityBinding = null;
    private int length = 0;
    private int secOffset = 0;

    private JIDualStringArray() {
    }

    JIDualStringArray(int port) {
        this.stringBinding = new JIStringBinding[2];
        this.stringBinding[0] = new JIStringBinding(port, false);
        this.length = this.stringBinding[0].getLength();
        this.stringBinding[1] = new JIStringBinding(port, true);
        this.secOffset = this.length = this.length + this.stringBinding[1].getLength() + 2;
        this.securityBinding = new JISecurityBinding[1];
        this.securityBinding[0] = new JISecurityBinding(10, 65535, "");
        this.length += this.securityBinding[0].getLength();
        this.length = this.length + 2 + 2 + 2;
    }

    static JIDualStringArray decode(NetworkDataRepresentation ndr) {
        JIDualStringArray dualStringArray = new JIDualStringArray();
        int numEntries = ndr.readUnsignedShort();
        if (numEntries == 0) {
            return dualStringArray;
        }
        ndr.readUnsignedShort();
        ArrayList<Serializable> listOfStringBindings = new ArrayList<Serializable>();
        ArrayList<Serializable> listOfSecurityBindings = new ArrayList<Serializable>();
        boolean stringbinding = true;
        while (true) {
            Serializable s;
            if (stringbinding) {
                s = JIStringBinding.decode(ndr);
                if (s == null) {
                    stringbinding = false;
                    dualStringArray.length += 2;
                    dualStringArray.secOffset = dualStringArray.length;
                    continue;
                }
                listOfStringBindings.add(s);
                dualStringArray.length += ((JIStringBinding)s).getLength();
                continue;
            }
            s = JISecurityBinding.decode(ndr);
            if (s == null) {
                dualStringArray.length += 2;
                break;
            }
            listOfSecurityBindings.add(s);
            dualStringArray.length += ((JISecurityBinding)s).getLength();
        }
        dualStringArray.length = dualStringArray.length + 2 + 2;
        dualStringArray.stringBinding = listOfStringBindings.toArray(new JIStringBinding[0]);
        dualStringArray.securityBinding = listOfSecurityBindings.toArray(new JISecurityBinding[0]);
        return dualStringArray;
    }

    public JIStringBinding[] getStringBindings() {
        return this.stringBinding;
    }

    public JISecurityBinding[] getSecurityBindings() {
        return this.securityBinding;
    }

    public int getLength() {
        return this.length;
    }

    public void encode(NetworkDataRepresentation ndr) {
        ndr.writeUnsignedShort((this.length - 4) / 2);
        ndr.writeUnsignedShort(this.secOffset / 2);
        int i = 0;
        if (this.stringBinding != null) {
            while (i < this.stringBinding.length) {
                this.stringBinding[i].encode(ndr);
                ++i;
            }
            ndr.writeUnsignedShort(0);
        }
        i = 0;
        if (this.securityBinding != null) {
            while (i < this.securityBinding.length) {
                this.securityBinding[i].encode(ndr);
                ++i;
            }
            ndr.writeUnsignedShort(0);
        }
    }
}

