/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.util.ArrayList;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIComVersion;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIDualStringArray;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIPointer;
import rpc.core.UUID;

final class JIOxidResolver
extends NdrObject {
    private final byte[] oxid;
    private JIDualStringArray oxidBindings = null;
    private String ipid = null;

    JIOxidResolver(byte[] oxid) {
        this.oxid = oxid;
    }

    public int getOpnum() {
        return 4;
    }

    public void write(NetworkDataRepresentation ndr) {
        JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr, this.oxid);
        JIMarshalUnMarshalHelper.serialize(ndr, Short.class, (short)1, new ArrayList<JIPointer>(), 0);
        JIMarshalUnMarshalHelper.serialize(ndr, JIArray.class, new JIArray(new Short[]{(short)7}, true), new ArrayList<JIPointer>(), 8);
    }

    public void read(NetworkDataRepresentation ndr) {
        ndr.readUnsignedLong();
        ndr.readUnsignedLong();
        this.oxidBindings = JIDualStringArray.decode(ndr);
        this.ipid = new UUID(ndr.getBuffer()).toString();
        ndr.readUnsignedLong();
        JIComVersion comVersion = new JIComVersion();
        comVersion.setMajorVersion(ndr.readUnsignedShort());
        comVersion.setMinorVersion(ndr.readUnsignedShort());
        int hresult = ndr.readUnsignedLong();
        if (hresult != 0) {
            throw new JIRuntimeException(hresult);
        }
    }

    JIDualStringArray getOxidBindings() {
        return this.oxidBindings;
    }

    String getIPID() {
        return this.ipid;
    }
}

