/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.net.UnknownHostException;
import org.jinterop.dcom.common.JIDefaultAuthInfoImpl;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIClsid;
import org.jinterop.dcom.core.JISession;
import org.jinterop.winreg.IJIWinReg;
import org.jinterop.winreg.JIPolicyHandle;
import org.jinterop.winreg.JIWinRegFactory;

public class JIProgId {
    private String progId = null;
    private JIClsid clsid = null;
    private JISession session = null;
    private String server = null;
    private boolean autoRegister = false;

    public void setAutoRegistration(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public boolean isAutoRegistrationSet() {
        return this.autoRegister;
    }

    private JIProgId(String progId) {
        this.progId = progId;
        this.clsid = JIClsid.valueOf(JISystem.getClsidFromProgId(progId));
    }

    void setServer(String server) {
        this.server = server;
    }

    private void getIdFromWinReg() throws JIException {
        IJIWinReg winreg;
        if (this.server == null) {
            this.server = this.session.getTargetServer();
        }
        try {
            winreg = this.session.isSSOEnabled() ? JIWinRegFactory.getSingleTon().getWinreg(this.server, true) : JIWinRegFactory.getSingleTon().getWinreg(new JIDefaultAuthInfoImpl(this.session.getDomain(), this.session.getUserName(), this.session.getPassword()), this.server, true);
        }
        catch (UnknownHostException unknownHostException) {
            throw new JIException(4148);
        }
        JIPolicyHandle handle = winreg.winreg_OpenHKLM();
        JIPolicyHandle handle2 = winreg.winreg_OpenKey(handle, "SOFTWARE\\Classes\\" + this.progId + "\\CLSID", 131097);
        String key = new String(winreg.winreg_QueryValue(handle2, 255));
        winreg.winreg_CloseKey(handle2);
        winreg.winreg_CloseKey(handle);
        winreg.closeConnection();
        this.clsid = JIClsid.valueOf(key.substring(key.indexOf(123) + 1, key.indexOf(125)));
        this.clsid.setAutoRegistration(this.autoRegister);
        JISystem.internal_setClsidtoProgId(this.progId, this.clsid.getCLSID());
    }

    public static JIProgId valueOf(String progId) {
        return new JIProgId(progId);
    }

    public JIClsid getCorrespondingCLSID() throws JIException {
        if (this.clsid == null) {
            this.getIdFromWinReg();
        }
        return this.clsid;
    }

    void setSession(JISession session) {
        this.session = session;
    }
}

