/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.test;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class JIThreading {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    static final String domain = "fdgnt";
    static final String user = "roopchand";
    static final String password = "QweQwe007";
    static final String host = "estroopchandnb";
    static final String comServerName = "WbemScripting.SWbemLocator";
    static final String comObjectId = "76A6415B-CB41-11d1-8B02-00600806D9B6";
    static final int totalLoops = 500;
    static final int numThreads = 25;
    static int loopsPerThread = 20;
    static final int waitForThreadssleepTime = 1000;

    public void setUp() {
        JISystem.setAutoRegisteration(true);
        LOGGER.setLevel(Level.ALL);
    }

    public void testThreading() {
        ThreadGroup group = new ThreadGroup("JIThreading Group");
        Thread[] threads = new Thread[25];
        int i = 0;
        while (i < 25) {
            threads[i] = new TestThread(group, "TestThread: " + i);
            ++i;
        }
        i = 0;
        while (i < 25) {
            threads[i].start();
            ++i;
        }
        boolean keepSleeping = true;
        if (keepSleeping) {
            try {
                Thread[] threadArray = threads;
                int n = threads.length;
                int n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    thread.join();
                    ++n2;
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "InterruptedException caught", e);
            }
        }
    }

    public static void main(String[] args) {
        JIThreading testJIThreading = new JIThreading();
        testJIThreading.setUp();
        testJIThreading.testThreading();
    }

    public static class TestThread
    extends Thread {
        public TestThread(ThreadGroup group, String name) {
            super(group, name);
        }

        @Override
        public void run() {
            int i = 0;
            while (i < loopsPerThread) {
                this.doStuff();
                ++i;
            }
        }

        public void doStuff() {
            try {
                JISession session = JISession.createSession(JIThreading.domain, JIThreading.user, JIThreading.password);
                JIProgId progId = JIProgId.valueOf(JIThreading.comServerName);
                JIComServer baseComServer = new JIComServer(progId, JIThreading.host, session);
                IJIComObject unknown = baseComServer.createInstance();
                IJIComObject baseComObject = unknown.queryInterface(JIThreading.comObjectId);
                IJIDispatch baseDispatch = (IJIDispatch)JIObjectFactory.narrowObject(baseComObject.queryInterface("00020400-0000-0000-c000-000000000046"));
                JIVariant cfr_ignored_0 = baseDispatch.callMethodA("ConnectServer", new Object[]{new JIString(JIThreading.host), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), 0, JIVariant.OPTIONAL_PARAM()})[0];
                JISession.destroySession(session);
                System.out.println("doStuff() run complete");
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Caught exception: ", e);
            }
        }
    }
}

