/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.test;

import java.net.UnknownHostException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class MSExcel2 {
    private JIComServer comServer = null;
    private IJIDispatch dispatch = null;
    private IJIComObject unknown = null;
    private IJIDispatch dispatchOfWorkSheets = null;
    private IJIDispatch dispatchOfWorkBook = null;
    private IJIDispatch dispatchOfWorkSheet = null;
    private JISession session = null;

    public MSExcel2(String address, String[] args) throws JIException, UnknownHostException {
        this.session = JISession.createSession(args[1], args[2], args[3]);
        this.comServer = new JIComServer(JIProgId.valueOf("Excel.Application"), address, this.session);
    }

    public void startExcel() throws JIException {
        this.unknown = this.comServer.createInstance();
        this.dispatch = (IJIDispatch)JIObjectFactory.narrowObject(this.unknown.queryInterface("00020400-0000-0000-c000-000000000046"));
    }

    public void showExcel() throws JIException {
        int dispId = this.dispatch.getIDsOfNames("Visible");
        JIVariant variant = new JIVariant(true);
        this.dispatch.put(dispId, variant);
    }

    public void createWorkSheet() throws JIException {
        int dispId = this.dispatch.getIDsOfNames("Workbooks");
        JIVariant outVal = this.dispatch.get(dispId);
        IJIDispatch dispatchOfWorkBooks = (IJIDispatch)JIObjectFactory.narrowObject(outVal.getObjectAsComObject());
        JIVariant[] outVal2 = dispatchOfWorkBooks.callMethodA("Add", new Object[]{JIVariant.OPTIONAL_PARAM()});
        this.dispatchOfWorkBook = (IJIDispatch)JIObjectFactory.narrowObject(outVal2[0].getObjectAsComObject());
        outVal = this.dispatchOfWorkBook.get("Worksheets");
        this.dispatchOfWorkSheets = (IJIDispatch)JIObjectFactory.narrowObject(outVal.getObjectAsComObject());
        outVal2 = this.dispatchOfWorkSheets.callMethodA("Add", new Object[]{JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        this.dispatchOfWorkSheet = (IJIDispatch)JIObjectFactory.narrowObject(outVal2[0].getObjectAsComObject());
    }

    public void pasteArrayToWorkSheet() throws JIException {
        int dispId = this.dispatchOfWorkSheet.getIDsOfNames("Range");
        JIVariant variant = new JIVariant(new JIString("A1:C3"));
        (new Object[1])[0] = JIVariant.class;
        JIVariant[] outVal2 = this.dispatchOfWorkSheet.get(dispId, new Object[]{variant});
        IJIDispatch dispRange = (IJIDispatch)JIObjectFactory.narrowObject(outVal2[0].getObjectAsComObject());
        JIVariant[][] newValue = new JIVariant[][]{{new JIVariant(new JIString("defe")), new JIVariant(false), new JIVariant(8.000405022276226)}, {new JIVariant(new Date()), new JIVariant(5454), new JIVariant(3.142857f)}, {new JIVariant(true), new JIVariant(new JIString("dffe")), new JIVariant(new Date())}};
        dispRange.put("Value2", new JIVariant(new JIArray(newValue)));
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        JIVariant variant2 = dispRange.get("Value2");
        JIArray newValue2 = variant2.getObjectAsArray();
        JIVariant[][] jIVariantArrayArray = newValue = (JIVariant[][])newValue2.getArrayInstance();
        int n = newValue.length;
        int n2 = 0;
        while (n2 < n) {
            JIVariant[] newValue1;
            JIVariant[] jIVariantArray = newValue1 = jIVariantArrayArray[n2];
            int n3 = newValue1.length;
            int n4 = 0;
            while (n4 < n3) {
                JIVariant item = jIVariantArray[n4];
                System.out.print(item + "\t");
                ++n4;
            }
            System.out.println();
            ++n2;
        }
        this.dispatchOfWorkBook.callMethod("close", new Object[]{Boolean.FALSE, JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        this.dispatch.callMethod("Quit");
        JISession.destroySession(this.session);
    }

    public static void main(String[] args) {
        try {
            if (args.length < 4) {
                System.out.println("Please provide address domain username password");
                return;
            }
            Logger l = Logger.getLogger("org.jinterop");
            l.setLevel(Level.FINEST);
            MSExcel2 test = new MSExcel2(args[0], args);
            test.startExcel();
            test.showExcel();
            test.createWorkSheet();
            test.pasteArrayToWorkSheet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

