/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.test;

import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class QtpCom {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    private JIComServer comServer = null;
    private IJIDispatch dispatch = null;
    private IJIComObject unknown = null;
    private JISession session = null;

    public QtpCom(String address, String domain, String username, String password) throws JIException, UnknownHostException {
        LOGGER.setLevel(Level.FINEST);
        JISystem.setAutoRegisteration(true);
        this.session = JISession.createSession(domain, username, password);
        this.comServer = new JIComServer(JIProgId.valueOf("QuickTest.Application"), address, this.session);
    }

    public void startQTP() throws JIException {
        System.out.println(this.comServer.getProperties());
        this.unknown = this.comServer.createInstance();
        this.dispatch = (IJIDispatch)JIObjectFactory.narrowObject(this.unknown.queryInterface("00020400-0000-0000-c000-000000000046"));
    }

    public void showQtp() throws JIException {
        int dispId = this.dispatch.getIDsOfNames("Visible");
        JIVariant variant = new JIVariant(true);
        this.dispatch.put(dispId, variant);
    }

    public void envQtp() throws JIException {
        this.dispatch.callMethodA("Open", new Object[]{new JIString("C:\\Programme\\Mercury Interactive\\QuickTest Professional\\Tests\\Test1"), new JIVariant(false), new JIVariant(true)});
        JIVariant variant = this.dispatch.get("Test");
        IJIDispatch test = (IJIDispatch)JIObjectFactory.narrowObject(variant.getObjectAsComObject());
        System.out.println(test.get("Author"));
        JISession.destroySession(this.session);
    }

    public static void main(String[] args) {
        try {
            QtpCom comQtp = new QtpCom("localhost", "domain", "username", "password");
            comQtp.startQTP();
            comQtp.showQtp();
            comQtp.envQtp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

