/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import ndr.NdrBuffer;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.transport.JIComRuntimeEndpoint;
import org.jinterop.dcom.transport.utils.IoUtils;
import rpc.Endpoint;
import rpc.RpcException;
import rpc.Transport;
import rpc.core.PresentationSyntax;

public class JIComRuntimeTransport
implements Transport {
    private static final String PROTOCOL = "ncacn_ip_tcp";
    private final Properties properties;
    protected Socket socket;
    private OutputStream output;
    private InputStream input;
    private boolean attached;

    protected JIComRuntimeTransport(String address, Properties properties) {
        this.properties = properties;
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Endpoint attach(PresentationSyntax syntax) throws RpcException {
        if (this.attached) {
            throw new RpcException("Transport already attached.");
        }
        try {
            this.socket = this.getSocket();
            this.output = null;
            this.input = null;
            this.attached = true;
            return this.getEndpoint(syntax);
        }
        catch (RuntimeException runtimeException) {
            this.close();
            return null;
        }
    }

    protected Endpoint getEndpoint(PresentationSyntax syntax) {
        return new JIComRuntimeEndpoint(this, syntax);
    }

    protected Socket getSocket() {
        return JISystem.internal_getSocket();
    }

    public void close() {
        this.socket = IoUtils.closeSilent(this.socket);
        this.output = null;
        this.input = null;
        this.attached = false;
    }

    public void send(NdrBuffer buffer) throws IOException {
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        if (this.output == null) {
            this.output = this.socket.getOutputStream();
        }
        this.output.write(buffer.getBuffer(), 0, buffer.getLength());
        this.output.flush();
    }

    public void receive(NdrBuffer buffer) throws IOException {
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        if (this.input == null) {
            this.input = this.socket.getInputStream();
        }
        buffer.length = this.input.read(buffer.getBuffer(), 0, buffer.getCapacity());
    }
}

