/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ndr.NdrBuffer;
import org.jinterop.dcom.transport.JIComEndpoint;
import org.jinterop.dcom.transport.utils.ChannelWrapper;
import org.jinterop.dcom.transport.utils.IoUtils;
import org.jinterop.dcom.transport.utils.SelectorManager;
import rpc.Endpoint;
import rpc.ProviderException;
import rpc.RpcException;
import rpc.Transport;
import rpc.core.PresentationSyntax;

final class JIComTransport
implements Transport {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    private static final String PROTOCOL = "ncacn_ip_tcp";
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("ncacn_ip_tcp:(?<host>[^\\[]*)\\[(?<port>\\d+)\\]");
    private static final String LOCALHOST = JIComTransport.getLocalhostName();
    private static final Object HANDOFF = new Object();
    private final SynchronousQueue<Object> readReadyHandoff = new SynchronousQueue();
    private final Properties properties;
    private final String host;
    private final int port;
    private final SelectorManager selectorManager;
    private ChannelWrapper wrappedChannel;
    private boolean attached = false;

    JIComTransport(String address, SelectorManager selectorManager, Properties properties) throws ProviderException {
        this.selectorManager = selectorManager;
        this.properties = properties;
        if (address == null) {
            throw new ProviderException("Null address.");
        }
        if (!address.startsWith("ncacn_ip_tcp:")) {
            throw new ProviderException("Not an ncacn_ip_tcp address.");
        }
        Matcher addressMatcher = ADDRESS_PATTERN.matcher(address);
        if (!addressMatcher.matches()) {
            throw new ProviderException("Invalid address format, expecting 'ncacn_ip_tcp:host[port]' got '" + address + "'");
        }
        this.host = addressMatcher.group("host").isEmpty() ? LOCALHOST : addressMatcher.group("host");
        this.port = Integer.parseInt(addressMatcher.group("port"));
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Endpoint attach(PresentationSyntax syntax) throws IOException {
        if (this.attached) {
            throw new RpcException("Transport already attached.");
        }
        try {
            LOGGER.log(Level.FINEST, "Opening socket on {0}", this);
            int timeout = this.getSocketTimeout();
            SocketChannel channel = SocketChannel.open();
            Socket socket = channel.socket();
            socket.setSoTimeout(timeout);
            socket.connect(new InetSocketAddress(InetAddress.getByName(this.host), this.port), timeout);
            channel.configureBlocking(false);
            this.wrappedChannel = new ChannelWrapper(this.selectorManager, channel, () -> {
                try {
                    if (!this.readReadyHandoff.offer(HANDOFF, timeout, TimeUnit.MILLISECONDS)) {
                        LOGGER.log(Level.WARNING, "Timeout while awaiting read ready handoff to {0}", this);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            });
            this.attached = true;
            return new JIComEndpoint(this, syntax);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.close();
            throw new IOException("Failed to attach COM Transport on " + this, ex);
        }
    }

    public String toString() {
        return "Transport to " + this.host + ":" + this.port;
    }

    public void close() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Close channelWrapper {0} host {1} , port {2}", new Object[]{this.wrappedChannel, this.host, this.port});
        }
        this.wrappedChannel = IoUtils.closeSilent(this.wrappedChannel);
        this.attached = false;
    }

    public void send(NdrBuffer buffer) throws IOException {
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer.getBuffer(), 0, buffer.getLength());
        this.wrappedChannel.writeAll(byteBuffer);
    }

    public void receive(NdrBuffer buffer) throws IOException {
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        int timeoutMillis = this.getSocketTimeout();
        this.wrappedChannel.registerForRead();
        try {
            Object handoffResult = timeoutMillis == 0 ? this.readReadyHandoff.take() : this.readReadyHandoff.poll(timeoutMillis, TimeUnit.MILLISECONDS);
            if (handoffResult == null) {
                throw new SocketTimeoutException();
            }
            buffer.length = this.wrappedChannel.read(ByteBuffer.wrap(buffer.getBuffer()));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while reading");
        }
    }

    private int getSocketTimeout() {
        try {
            return Integer.parseInt(this.properties.getProperty("rpc.socketTimeout", "0"));
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.WARNING, ex, () -> "Invalid timeout value " + this.properties.getProperty("rpc.socketTimeout"));
            return 0;
        }
    }

    private static String getLocalhostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }
}

