/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport.utils;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jinterop.dcom.transport.utils.SelectorManager;

public final class ChannelWrapper
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    private final SelectorManager selectorManager;
    private final SocketChannel selectableChannel;

    public ChannelWrapper(SelectorManager selectorManager, SocketChannel selectableChannel, Runnable channelListener) throws IOException {
        this.selectorManager = selectorManager;
        this.selectableChannel = selectableChannel;
        this.selectorManager.registerChannel(selectableChannel, channelListener);
    }

    @Override
    public void close() throws IOException {
        this.selectableChannel.close();
    }

    public String toString() {
        return "Channel to " + this.getRemoteSocketAddress();
    }

    public boolean isConnected() {
        return this.selectableChannel.isConnected();
    }

    public boolean isOpen() {
        return this.selectableChannel.isOpen();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.selectableChannel.socket().getRemoteSocketAddress();
    }

    public int read(ByteBuffer buffer) throws IOException {
        return this.selectableChannel.read(buffer);
    }

    public void registerForRead() throws IOException {
        this.selectorManager.setReadInterest(this.selectableChannel);
    }

    public void unregisterForRead() throws IOException {
        this.selectorManager.removeReadInterest(this.selectableChannel);
    }

    private int write(ByteBuffer buffer) throws IOException {
        return this.selectableChannel.write(buffer);
    }

    public void writeAll(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            int bytesWritten = this.write(buffer);
            LOGGER.log(Level.FINE, "{0} bytes written {1}", new Object[]{this, bytesWritten});
        }
    }
}

