/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport.utils;

import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IoUtils {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");

    private IoUtils() {
    }

    public static <T extends AutoCloseable> T closeSilent(T toClose, String name) {
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, ex, () -> "Failed to close " + name + ".");
            }
        }
        return null;
    }

    public static <T extends AutoCloseable> T closeSilent(T toClose) {
        return IoUtils.closeSilent(toClose, String.valueOf(toClose));
    }

    public static <T extends Socket> T closeSilent(T socket, String name) {
        if (socket != null) {
            try {
                socket.shutdownInput();
                socket.shutdownOutput();
            }
            catch (IOException | RuntimeException ex) {
                LOGGER.log(Level.FINE, ex, () -> "Failed to shutwown socket " + name + " inner streams.");
            }
            try {
                socket.close();
            }
            catch (IOException | RuntimeException ex) {
                LOGGER.log(Level.FINE, ex, () -> "Failed to close " + name + ".");
            }
        }
        return null;
    }

    public static <T extends Socket> T closeSilent(T socket) {
        return IoUtils.closeSilent(socket, String.valueOf(socket));
    }
}

