/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport.utils;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SelectorManager {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    private final List<Runnable> taskList = new ArrayList<Runnable>();
    private final Selector selector = Selector.open();
    private final Thread selectThread = new Thread(() -> {
        try {
            while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    LOGGER.log(Level.INFO, "Selector manager interrupted");
                    return;
                }
                this.doInvocations();
                this.doSelect();
            }
        }
        catch (Exception ex) {
            this.cleanup();
            LOGGER.log(Level.SEVERE, "Selector manager is unexpectedly exiting", ex);
            return;
        }
    }, "jI_SelectorManager");

    public SelectorManager() throws IOException {
        this.selectThread.setDaemon(true);
        this.selectThread.start();
    }

    public void destroy() {
        if (this.selectThread.isAlive()) {
            this.selectThread.interrupt();
        }
    }

    void registerChannel(SelectableChannel selectableChannel, Runnable listener) throws IOException {
        this.invokeSync(() -> {
            selectableChannel.configureBlocking(false);
            selectableChannel.register(this.selector, 0, listener);
            return null;
        });
    }

    void setReadInterest(SelectableChannel selectableChannel) throws IOException {
        this.invokeSync(() -> {
            this.setInterestOps(selectableChannel, 1);
            return null;
        });
    }

    void removeReadInterest(SelectableChannel selectableChannel) throws IOException {
        this.invokeSync(() -> {
            this.setInterestOps(selectableChannel, 0);
            return null;
        });
    }

    private void setInterestOps(SelectableChannel selectableChannel, int interestOps) throws IOException {
        try {
            if (selectableChannel.isRegistered()) {
                SelectionKey selectionKey = selectableChannel.keyFor(this.selector);
                selectionKey.interestOps(interestOps);
            }
        }
        catch (CancelledKeyException ex) {
            throw new IOException("Unable to set interest ops", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAsync(Runnable task) {
        List<Runnable> list = this.taskList;
        synchronized (list) {
            this.taskList.add(task);
        }
        this.selector.wakeup();
    }

    private void invokeSync(Callable<Void> task) throws IOException {
        ExceptionHolder exceptionHolder = new ExceptionHolder();
        if (Thread.currentThread() == this.selectThread) {
            try {
                task.call();
            }
            catch (Exception ex) {
                exceptionHolder.setException(ex);
            }
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            this.invokeAsync(() -> {
                try {
                    try {
                        task.call();
                    }
                    catch (Exception ex) {
                        exceptionHolder.setException(ex);
                        latch.countDown();
                    }
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (exceptionHolder.getException() != null) {
            Exception thrownException = exceptionHolder.getException();
            throw this.launderIOException(thrownException);
        }
    }

    private IOException launderIOException(Exception thrownException) {
        if (thrownException instanceof RuntimeException) {
            throw (RuntimeException)thrownException;
        }
        if (thrownException instanceof IOException) {
            return (IOException)thrownException;
        }
        throw new UndeclaredThrowableException(thrownException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvocations() {
        boolean processedTask = false;
        List<Runnable> list = this.taskList;
        synchronized (list) {
            for (Runnable task : this.taskList) {
                task.run();
                processedTask = true;
            }
            this.taskList.clear();
        }
        if (!processedTask) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void doSelect() {
        try {
            if (this.selector.select() != 0) {
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    try {
                        SelectionKey selectionKey = it.next();
                        it.remove();
                        selectionKey.interestOps(0);
                        Runnable listener = (Runnable)selectionKey.attachment();
                        listener.run();
                    }
                    catch (CancelledKeyException ex) {
                        LOGGER.log(Level.FINE, "Ignoring cancelled key exception", ex);
                    }
                }
            }
        }
        catch (IOException | RuntimeException ex) {
            LOGGER.log(Level.WARNING, "Exception during SelectionManager select", ex);
        }
    }

    private void cleanup() {
        for (SelectionKey key : this.selector.keys()) {
            try {
                key.channel().close();
            }
            catch (IOException | RuntimeException ex) {
                LOGGER.log(Level.FINE, "Ignoring channel close exception", ex);
            }
        }
        try {
            this.selector.close();
        }
        catch (IOException | RuntimeException ex) {
            LOGGER.log(Level.FINE, "Ignoring selector close exception", ex);
        }
    }

    private static final class ExceptionHolder {
        private Exception exception;

        private ExceptionHolder() {
        }

        Exception getException() {
            return this.exception;
        }

        void setException(Exception ex) {
            this.exception = ex;
        }
    }
}

