/*
 * Decompiled with CFR 0.152.
 */
package ndr;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import jcifs.util.Encdec;
import ndr.NdrException;

public class NdrBuffer {
    private int referent;
    private Map<Object, Entry> referents;
    public byte[] buf;
    public int start;
    public int index;
    public int length;
    public NdrBuffer deferred;

    public NdrBuffer(byte[] buf, int start) {
        this.buf = buf;
        this.start = this.index = start;
        this.length = 0;
        this.deferred = this;
    }

    public NdrBuffer derive(int idx) {
        NdrBuffer nb = new NdrBuffer(this.buf, this.start);
        nb.index = idx;
        nb.deferred = this.deferred;
        return nb;
    }

    public void reset() {
        this.index = this.start;
        this.length = 0;
        this.deferred = this;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getCapacity() {
        return this.buf.length - this.start;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int align(int boundary, byte value) {
        int n;
        int i = n = this.align(boundary);
        while (i > 0) {
            this.buf[this.index - i] = value;
            --i;
        }
        return n;
    }

    public void writeOctetArray(byte[] b, int i, int l) {
        if (this.index + l > this.buf.length) {
            this.resize(this.index + l);
        }
        System.arraycopy(b, i, this.buf, this.index, l);
        this.advance(l);
    }

    public void readOctetArray(byte[] b, int i, int l) {
        if (this.index + l > this.buf.length) {
            this.resize(this.index + l);
        }
        System.arraycopy(this.buf, this.index, b, i, l);
        this.advance(l);
    }

    public int getLength() {
        return this.deferred.length;
    }

    public void advance(int n) {
        this.index += n;
        if (this.index > this.buf.length) {
            this.resize(this.index + 1);
        }
        if (this.index - this.start > this.deferred.length) {
            this.deferred.length = this.index - this.start;
        }
    }

    public int align(int boundary) {
        int m = boundary - 1;
        int i = this.index - this.start;
        int n = (i + m & ~m) - i;
        this.advance(n);
        return n;
    }

    public void enc_ndr_small(int s) {
        if (this.index >= this.buf.length) {
            this.resize(this.index + 1);
        }
        this.buf[this.index] = (byte)(s & 0xFF);
        this.advance(1);
    }

    public int dec_ndr_small() {
        if (this.index >= this.buf.length) {
            this.resize(this.index + 1);
        }
        int val = this.buf[this.index] & 0xFF;
        this.advance(1);
        return val;
    }

    public void enc_ndr_short(int s) {
        this.align(2);
        Encdec.enc_uint16le((short)((short)s), (byte[])this.buf, (int)this.index);
        this.advance(2);
    }

    public int dec_ndr_short() {
        this.align(2);
        short val = Encdec.dec_uint16le((byte[])this.buf, (int)this.index);
        this.advance(2);
        return val;
    }

    public void enc_ndr_long(int l) {
        this.align(4);
        if (this.index + 4 > this.buf.length) {
            this.resize(this.index + 4);
        }
        Encdec.enc_uint32le((int)l, (byte[])this.buf, (int)this.index);
        this.advance(4);
    }

    public int dec_ndr_long() {
        this.align(4);
        if (this.index + 4 > this.buf.length) {
            this.resize(this.index + 4);
        }
        int val = Encdec.dec_uint32le((byte[])this.buf, (int)this.index);
        this.advance(4);
        return val;
    }

    public void enc_ndr_string(String s) {
        this.align(4);
        int i = this.index;
        int len = s.length();
        Encdec.enc_uint32le((int)(len + 1), (byte[])this.buf, (int)i);
        Encdec.enc_uint32le((int)0, (byte[])this.buf, (int)(i += 4));
        Encdec.enc_uint32le((int)(len + 1), (byte[])this.buf, (int)(i += 4));
        System.arraycopy(s.getBytes(StandardCharsets.UTF_16LE), 0, this.buf, i += 4, len * 2);
        i += len * 2;
        this.buf[i++] = 0;
        this.buf[i++] = 0;
        this.advance(i - this.index);
    }

    public String dec_ndr_string() throws NdrException {
        this.align(4);
        int i = this.index;
        String val = null;
        int len = Encdec.dec_uint32le((byte[])this.buf, (int)i);
        i += 12;
        if (len != 0) {
            int size = --len * 2;
            try {
                if (size < 0 || size > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                val = new String(this.buf, i, size, "UnicodeLittle");
                i += size + 2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        this.advance(i - this.index);
        return val;
    }

    public void enc_ndr_referent(Object obj, int type) {
        if (obj == null) {
            this.enc_ndr_long(0);
            return;
        }
        switch (type) {
            case 1: 
            case 3: {
                this.enc_ndr_long(System.identityHashCode(obj));
                return;
            }
            case 2: {
                this.enc_ndr_long(this.getDceReferent(obj));
            }
        }
    }

    public String toString() {
        return "start=" + this.start + ",index=" + this.index + ",length=" + this.getLength();
    }

    public void resize(int min) {
        int newSize = 0;
        if (min > newSize) {
            newSize = min;
        }
        byte[] newBuffer = new byte[newSize];
        System.arraycopy(this.buf, 0, newBuffer, 0, this.buf.length);
        this.buf = newBuffer;
    }

    private int getDceReferent(Object obj) {
        Entry entry;
        if (this.referents == null) {
            this.referents = new HashMap<Object, Entry>();
            this.referent = 1;
        }
        if ((entry = this.referents.get(obj)) == null) {
            entry = new Entry();
            entry.referent = this.referent++;
            entry.obj = obj;
            this.referents.put(obj, entry);
        }
        return entry.referent;
    }

    static class Entry {
        int referent;
        Object obj;

        Entry() {
        }
    }
}

