/*
 * Decompiled with CFR 0.152.
 */
package rpc;

import rpc.BindException;
import rpc.core.PresentationResult;

public class PresentationException
extends BindException {
    private static final long serialVersionUID = 5421952951585948361L;

    public PresentationException() {
    }

    public PresentationException(String message) {
        super(message);
    }

    public PresentationException(String message, PresentationResult result) {
        super(PresentationException.message(message, result));
    }

    private static String message(String message, PresentationResult result) {
        if (result == null) {
            return message;
        }
        return message != null ? String.valueOf(message) + " (" + PresentationException.message(result) + ")" : PresentationException.message(result);
    }

    private static String message(PresentationResult result) {
        StringBuilder message = new StringBuilder();
        switch (result.result) {
            case 0: {
                message.append("ACCEPTANCE");
                break;
            }
            case 1: {
                message.append("USER_REJECTION");
                break;
            }
            case 2: {
                message.append("PROVIDER_REJECTION");
                break;
            }
            default: {
                message.append("unknown");
            }
        }
        message.append("; ");
        switch (result.reason) {
            case 0: {
                message.append("REASON_NOT_SPECIFIED");
                break;
            }
            case 1: {
                message.append("ABSTRACT_SYNTAX_NOT_SUPPORTED");
                break;
            }
            case 2: {
                message.append("PROPOSED_TRANSFER_SYNTAXES_NOT_SUPPORTED");
                break;
            }
            case 3: {
                message.append("LOCAL_LIMIT_EXCEEDED");
                break;
            }
            default: {
                message.append("unknown");
            }
        }
        return message.toString();
    }
}

