/*
 * Decompiled with CFR 0.152.
 */
package rpc.core;

import java.util.StringTokenizer;
import ndr.NdrObject;
import rpc.core.UUID;

public final class InterfaceIdentifier
extends NdrObject {
    UUID uuid;
    int majorVersion;
    int minorVersion;

    public InterfaceIdentifier(String syntax) {
        this.parse(syntax);
    }

    public InterfaceIdentifier(UUID uuid, int majorVersion, int minorVersion) {
        this.setUuid(uuid);
        this.setMajorVersion(majorVersion);
        this.setMinorVersion(minorVersion);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String toString() {
        return String.valueOf(this.getUuid().toString()) + ":" + this.getMajorVersion() + "." + this.getMinorVersion();
    }

    public void parse(String syntax) {
        StringTokenizer tokenizer = new StringTokenizer(syntax, ":.");
        this.getUuid().parse(tokenizer.nextToken());
        this.setMajorVersion(Integer.parseInt(tokenizer.nextToken()));
        this.setMinorVersion(Integer.parseInt(tokenizer.nextToken()));
    }
}

