/*
 * Decompiled with CFR 0.152.
 */
package rpc.core;

import java.util.StringTokenizer;
import ndr.NdrBuffer;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import rpc.core.UUID;

public final class PresentationSyntax
extends NdrObject {
    private UUID uuid;
    private int version;

    public PresentationSyntax() {
    }

    public PresentationSyntax(String syntax) {
        this();
        this.parse(syntax);
    }

    public PresentationSyntax(UUID uuid, int majorVersion, int minorVersion) {
        this();
        this.setUuid(uuid);
        this.setVersion(majorVersion, minorVersion);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getMajorVersion() {
        return this.version & 0xFFFF;
    }

    public int getMinorVersion() {
        return this.version >> 16 & 0xFFFF;
    }

    public void setVersion(int majorVersion, int minorVersion) {
        this.setVersion(majorVersion & 0xFFFF | minorVersion << 16);
    }

    @Override
    public void encode(NetworkDataRepresentation ndr, NdrBuffer dst) {
        this.uuid.encode(dst);
        dst.enc_ndr_long(this.version);
    }

    @Override
    public void decode(NetworkDataRepresentation ndr, NdrBuffer src) {
        this.uuid = new UUID(src);
        this.version = src.dec_ndr_long();
    }

    public String toString() {
        return String.valueOf(this.getUuid().toString()) + ":" + this.getMajorVersion() + "." + this.getMinorVersion();
    }

    public void parse(String syntax) {
        StringTokenizer tokenizer = new StringTokenizer(syntax, ":.");
        this.uuid = new UUID(tokenizer.nextToken());
        this.setVersion(Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()));
    }
}

