/*
 * Decompiled with CFR 0.152.
 */
package rpc.core;

import java.util.StringTokenizer;
import ndr.NdrBuffer;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;

public final class UUID
extends NdrObject {
    public static final String NIL_UUID = "00000000-0000-0000-0000-000000000000";
    private int timeLow;
    private int timeMid;
    private int timeHighAndVersion;
    private int clockSeqHighAndReserved;
    private int clockSeqLow;
    private byte[] node = new byte[6];

    public static String createHexString() {
        return java.util.UUID.randomUUID().toString();
    }

    public UUID(NdrBuffer src) {
        this.decode(src);
    }

    public UUID(String uuid) {
        this.parse(uuid);
    }

    @Override
    public void encode(NetworkDataRepresentation ndr, NdrBuffer dst) {
        this.encode(dst);
    }

    @Override
    public void decode(NetworkDataRepresentation ndr, NdrBuffer src) {
        this.decode(src);
    }

    public void encode(NdrBuffer dst) {
        dst.enc_ndr_long(this.timeLow);
        dst.enc_ndr_short(this.timeMid);
        dst.enc_ndr_short(this.timeHighAndVersion);
        dst.enc_ndr_small(this.clockSeqHighAndReserved);
        dst.enc_ndr_small(this.clockSeqLow);
        System.arraycopy(this.node, 0, dst.buf, dst.index, 6);
        dst.index += 6;
    }

    public void decode(NdrBuffer src) {
        this.timeLow = src.dec_ndr_long();
        this.timeMid = src.dec_ndr_short();
        this.timeHighAndVersion = src.dec_ndr_short();
        this.clockSeqHighAndReserved = src.dec_ndr_small();
        this.clockSeqLow = src.dec_ndr_small();
        System.arraycopy(src.buf, src.index, this.node, 0, 6);
        src.index += 6;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Integer.toHexString(this.timeLow >> 28 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 24 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 20 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 16 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 12 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 8 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 4 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow & 0xF));
        buffer.append('-');
        buffer.append(Integer.toHexString(this.timeMid >> 12 & 0xF));
        buffer.append(Integer.toHexString(this.timeMid >> 8 & 0xF));
        buffer.append(Integer.toHexString(this.timeMid >> 4 & 0xF));
        buffer.append(Integer.toHexString(this.timeMid & 0xF));
        buffer.append('-');
        buffer.append(Integer.toHexString(this.timeHighAndVersion >> 12 & 0xF));
        buffer.append(Integer.toHexString(this.timeHighAndVersion >> 8 & 0xF));
        buffer.append(Integer.toHexString(this.timeHighAndVersion >> 4 & 0xF));
        buffer.append(Integer.toHexString(this.timeHighAndVersion & 0xF));
        buffer.append('-');
        buffer.append(Integer.toHexString(this.clockSeqHighAndReserved >> 4 & 0xF));
        buffer.append(Integer.toHexString(this.clockSeqHighAndReserved & 0xF));
        buffer.append(Integer.toHexString(this.clockSeqLow >> 4 & 0xF));
        buffer.append(Integer.toHexString(this.clockSeqLow & 0xF));
        buffer.append('-');
        int i = 0;
        while (i < 6) {
            buffer.append(Integer.toHexString(this.node[i] >> 4 & 0xF));
            buffer.append(Integer.toHexString(this.node[i] & 0xF));
            ++i;
        }
        return buffer.toString();
    }

    public void parse(String uuid) {
        StringTokenizer tokenizer = new StringTokenizer(uuid, "-");
        this.timeLow = (int)Long.parseLong(tokenizer.nextToken(), 16);
        this.timeMid = Integer.parseInt(tokenizer.nextToken(), 16);
        this.timeHighAndVersion = Integer.parseInt(tokenizer.nextToken(), 16);
        String token = tokenizer.nextToken();
        this.clockSeqHighAndReserved = Integer.parseInt(token.substring(0, 2), 16);
        this.clockSeqLow = Integer.parseInt(token.substring(2), 16);
        token = tokenizer.nextToken();
        this.node = new byte[6];
        int i = 0;
        while (i < 6) {
            int offset = i * 2;
            this.node[i] = (byte)(Character.digit(token.charAt(offset), 16) << 4 | Character.digit(token.charAt(offset + 1), 16));
            ++i;
        }
    }
}

