/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import jcifs.ntlmssp.NtlmFlags;
import jcifs.util.Hexdump;
import ndr.NdrBuffer;
import ndr.NetworkDataRepresentation;
import rpc.IntegrityException;
import rpc.Security;
import rpc.security.ntlm.DigestHelper;
import rpc.security.ntlm.Responses;

public class Ntlm1
implements NtlmFlags,
Security {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    private static final byte[] CLIENT_SIGNING_MAGIC_CONSTANT;
    private static final byte[] SERVER_SIGNING_MAGIC_CONSTANT;
    private static final byte[] CLIENT_SEALING_MAGIC_CONSTANT;
    private static final byte[] SERVER_SEALING_MAGIC_CONSTANT;
    private static final byte[] HEX_ARRAY;
    private static final int NTLM1_VERIFIER_LENGTH = 16;
    private final Cipher clientCipher;
    private final Cipher serverCipher;
    private final byte[] clientSigningKey;
    private final byte[] serverSigningKey;
    private final boolean isServer;
    private final int protectionLevel;
    private int requestCounter = 0;
    private int responseCounter = 0;

    static {
        byte[] byArray = new byte[59];
        byArray[0] = 115;
        byArray[1] = 101;
        byArray[2] = 115;
        byArray[3] = 115;
        byArray[4] = 105;
        byArray[5] = 111;
        byArray[6] = 110;
        byArray[7] = 32;
        byArray[8] = 107;
        byArray[9] = 101;
        byArray[10] = 121;
        byArray[11] = 32;
        byArray[12] = 116;
        byArray[13] = 111;
        byArray[14] = 32;
        byArray[15] = 99;
        byArray[16] = 108;
        byArray[17] = 105;
        byArray[18] = 101;
        byArray[19] = 110;
        byArray[20] = 116;
        byArray[21] = 45;
        byArray[22] = 116;
        byArray[23] = 111;
        byArray[24] = 45;
        byArray[25] = 115;
        byArray[26] = 101;
        byArray[27] = 114;
        byArray[28] = 118;
        byArray[29] = 101;
        byArray[30] = 114;
        byArray[31] = 32;
        byArray[32] = 115;
        byArray[33] = 105;
        byArray[34] = 103;
        byArray[35] = 110;
        byArray[36] = 105;
        byArray[37] = 110;
        byArray[38] = 103;
        byArray[39] = 32;
        byArray[40] = 107;
        byArray[41] = 101;
        byArray[42] = 121;
        byArray[43] = 32;
        byArray[44] = 109;
        byArray[45] = 97;
        byArray[46] = 103;
        byArray[47] = 105;
        byArray[48] = 99;
        byArray[49] = 32;
        byArray[50] = 99;
        byArray[51] = 111;
        byArray[52] = 110;
        byArray[53] = 115;
        byArray[54] = 116;
        byArray[55] = 97;
        byArray[56] = 110;
        byArray[57] = 116;
        CLIENT_SIGNING_MAGIC_CONSTANT = byArray;
        byte[] byArray2 = new byte[59];
        byArray2[0] = 115;
        byArray2[1] = 101;
        byArray2[2] = 115;
        byArray2[3] = 115;
        byArray2[4] = 105;
        byArray2[5] = 111;
        byArray2[6] = 110;
        byArray2[7] = 32;
        byArray2[8] = 107;
        byArray2[9] = 101;
        byArray2[10] = 121;
        byArray2[11] = 32;
        byArray2[12] = 116;
        byArray2[13] = 111;
        byArray2[14] = 32;
        byArray2[15] = 115;
        byArray2[16] = 101;
        byArray2[17] = 114;
        byArray2[18] = 118;
        byArray2[19] = 101;
        byArray2[20] = 114;
        byArray2[21] = 45;
        byArray2[22] = 116;
        byArray2[23] = 111;
        byArray2[24] = 45;
        byArray2[25] = 99;
        byArray2[26] = 108;
        byArray2[27] = 105;
        byArray2[28] = 101;
        byArray2[29] = 110;
        byArray2[30] = 116;
        byArray2[31] = 32;
        byArray2[32] = 115;
        byArray2[33] = 105;
        byArray2[34] = 103;
        byArray2[35] = 110;
        byArray2[36] = 105;
        byArray2[37] = 110;
        byArray2[38] = 103;
        byArray2[39] = 32;
        byArray2[40] = 107;
        byArray2[41] = 101;
        byArray2[42] = 121;
        byArray2[43] = 32;
        byArray2[44] = 109;
        byArray2[45] = 97;
        byArray2[46] = 103;
        byArray2[47] = 105;
        byArray2[48] = 99;
        byArray2[49] = 32;
        byArray2[50] = 99;
        byArray2[51] = 111;
        byArray2[52] = 110;
        byArray2[53] = 115;
        byArray2[54] = 116;
        byArray2[55] = 97;
        byArray2[56] = 110;
        byArray2[57] = 116;
        SERVER_SIGNING_MAGIC_CONSTANT = byArray2;
        byte[] byArray3 = new byte[59];
        byArray3[0] = 115;
        byArray3[1] = 101;
        byArray3[2] = 115;
        byArray3[3] = 115;
        byArray3[4] = 105;
        byArray3[5] = 111;
        byArray3[6] = 110;
        byArray3[7] = 32;
        byArray3[8] = 107;
        byArray3[9] = 101;
        byArray3[10] = 121;
        byArray3[11] = 32;
        byArray3[12] = 116;
        byArray3[13] = 111;
        byArray3[14] = 32;
        byArray3[15] = 99;
        byArray3[16] = 108;
        byArray3[17] = 105;
        byArray3[18] = 101;
        byArray3[19] = 110;
        byArray3[20] = 116;
        byArray3[21] = 45;
        byArray3[22] = 116;
        byArray3[23] = 111;
        byArray3[24] = 45;
        byArray3[25] = 115;
        byArray3[26] = 101;
        byArray3[27] = 114;
        byArray3[28] = 118;
        byArray3[29] = 101;
        byArray3[30] = 114;
        byArray3[31] = 32;
        byArray3[32] = 115;
        byArray3[33] = 101;
        byArray3[34] = 97;
        byArray3[35] = 108;
        byArray3[36] = 105;
        byArray3[37] = 110;
        byArray3[38] = 103;
        byArray3[39] = 32;
        byArray3[40] = 107;
        byArray3[41] = 101;
        byArray3[42] = 121;
        byArray3[43] = 32;
        byArray3[44] = 109;
        byArray3[45] = 97;
        byArray3[46] = 103;
        byArray3[47] = 105;
        byArray3[48] = 99;
        byArray3[49] = 32;
        byArray3[50] = 99;
        byArray3[51] = 111;
        byArray3[52] = 110;
        byArray3[53] = 115;
        byArray3[54] = 116;
        byArray3[55] = 97;
        byArray3[56] = 110;
        byArray3[57] = 116;
        CLIENT_SEALING_MAGIC_CONSTANT = byArray3;
        byte[] byArray4 = new byte[59];
        byArray4[0] = 115;
        byArray4[1] = 101;
        byArray4[2] = 115;
        byArray4[3] = 115;
        byArray4[4] = 105;
        byArray4[5] = 111;
        byArray4[6] = 110;
        byArray4[7] = 32;
        byArray4[8] = 107;
        byArray4[9] = 101;
        byArray4[10] = 121;
        byArray4[11] = 32;
        byArray4[12] = 116;
        byArray4[13] = 111;
        byArray4[14] = 32;
        byArray4[15] = 115;
        byArray4[16] = 101;
        byArray4[17] = 114;
        byArray4[18] = 118;
        byArray4[19] = 101;
        byArray4[20] = 114;
        byArray4[21] = 45;
        byArray4[22] = 116;
        byArray4[23] = 111;
        byArray4[24] = 45;
        byArray4[25] = 99;
        byArray4[26] = 108;
        byArray4[27] = 105;
        byArray4[28] = 101;
        byArray4[29] = 110;
        byArray4[30] = 116;
        byArray4[31] = 32;
        byArray4[32] = 115;
        byArray4[33] = 101;
        byArray4[34] = 97;
        byArray4[35] = 108;
        byArray4[36] = 105;
        byArray4[37] = 110;
        byArray4[38] = 103;
        byArray4[39] = 32;
        byArray4[40] = 107;
        byArray4[41] = 101;
        byArray4[42] = 121;
        byArray4[43] = 32;
        byArray4[44] = 109;
        byArray4[45] = 97;
        byArray4[46] = 103;
        byArray4[47] = 105;
        byArray4[48] = 99;
        byArray4[49] = 32;
        byArray4[50] = 99;
        byArray4[51] = 111;
        byArray4[52] = 110;
        byArray4[53] = 115;
        byArray4[54] = 116;
        byArray4[55] = 97;
        byArray4[56] = 110;
        byArray4[57] = 116;
        SERVER_SEALING_MAGIC_CONSTANT = byArray4;
        HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
    }

    public Ntlm1(int flags, byte[] sessionKey, boolean isServer) {
        this.protectionLevel = (flags & 0x20) != 0 ? 6 : 5;
        this.isServer = isServer;
        this.clientSigningKey = Ntlm1.generateClientSigningKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        this.serverSigningKey = Ntlm1.generateServerSigningKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        byte[] clientSealingKey = Ntlm1.generateClientSealingKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        byte[] serverSealingKey = Ntlm1.generateServerSealingKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        try {
            this.clientCipher = Cipher.getInstance("RC4");
            this.clientCipher.init(2, new SecretKeySpec(clientSealingKey, "RC4"));
            this.serverCipher = Cipher.getInstance("RC4");
            this.serverCipher.init(2, new SecretKeySpec(serverSealingKey, "RC4"));
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException("Failed to init decrypt RC4 cipher", ex);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Client Signing Key derieved from the session key: [{0}]", Ntlm1.dumpString(this.clientSigningKey));
            LOGGER.log(Level.FINEST, "Client Sealing Key derieved from the session key: [{0}]", Ntlm1.dumpString(clientSealingKey));
            LOGGER.log(Level.FINEST, "Server Signing Key derieved from the session key: [{0}]", Ntlm1.dumpString(this.serverSigningKey));
            LOGGER.log(Level.FINEST, "Server Sealing Key derieved from the session key: [{0}]", Ntlm1.dumpString(serverSealingKey));
        }
    }

    @Override
    public int getVerifierLength() {
        return 16;
    }

    @Override
    public int getAuthenticationService() {
        return 10;
    }

    @Override
    public int getProtectionLevel() {
        return this.protectionLevel;
    }

    @Override
    public void processIncoming(NetworkDataRepresentation ndr, int index, int length, int verifierIndex, boolean isFragmented) throws IOException {
        try {
            Cipher cipher;
            byte[] signingKey;
            NdrBuffer buffer = ndr.getBuffer();
            if (!this.isServer) {
                signingKey = this.serverSigningKey;
                cipher = this.serverCipher;
            } else {
                signingKey = this.clientSigningKey;
                cipher = this.clientCipher;
            }
            byte[] data = new byte[length];
            System.arraycopy(ndr.getBuffer().getBuffer(), index, data, 0, data.length);
            if (this.getProtectionLevel() == 6) {
                data = cipher.update(data);
                System.arraycopy(data, 0, ndr.getBuffer().buf, index, data.length);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.info("AFTER Decryption");
                LOGGER.log(Level.FINEST, "\n{0}", Hexdump.toHexString((byte[])data));
                LOGGER.log(Level.FINEST, "\nLength is: {0}", data.length);
            }
            byte[] verifier = Ntlm1.signingPt1(this.responseCounter, signingKey, buffer.getBuffer(), verifierIndex);
            Ntlm1.signingPt2(verifier, cipher);
            buffer.setIndex(verifierIndex);
            byte[] signing = new byte[16];
            ndr.readOctetArray(signing, 0, signing.length);
            if (!Arrays.equals(verifier, signing)) {
                throw new IntegrityException("Message out of sequence. Perhaps the user being used to run this application is different from the one under which the COM server is running !.");
            }
            ++this.responseCounter;
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "", ex);
            throw ex;
        }
        catch (RuntimeException | ShortBufferException ex) {
            LOGGER.log(Level.SEVERE, "", ex);
            throw new IntegrityException("General error: " + ex.getMessage());
        }
    }

    @Override
    public void processOutgoing(NetworkDataRepresentation ndr, int index, int length, int verifierIndex, boolean isFragmented) throws IOException {
        try {
            Cipher cipher;
            byte[] signingKey;
            NdrBuffer buffer = ndr.getBuffer();
            if (this.isServer) {
                signingKey = this.serverSigningKey;
                cipher = this.serverCipher;
            } else {
                signingKey = this.clientSigningKey;
                cipher = this.clientCipher;
            }
            byte[] verifier = Ntlm1.signingPt1(this.requestCounter, signingKey, buffer.getBuffer(), verifierIndex);
            byte[] data = new byte[length];
            System.arraycopy(ndr.getBuffer().getBuffer(), index, data, 0, data.length);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.info("BEFORE Encryption");
                LOGGER.log(Level.FINEST, "\n{0}", Hexdump.toHexString((byte[])data));
                LOGGER.log(Level.INFO, "Length is: {0}", data.length);
            }
            if (this.getProtectionLevel() == 6) {
                byte[] data2 = cipher.update(data);
                System.arraycopy(data2, 0, ndr.getBuffer().buf, index, data2.length);
            }
            Ntlm1.signingPt2(verifier, cipher);
            buffer.setIndex(verifierIndex);
            buffer.writeOctetArray(verifier, 0, verifier.length);
            ++this.requestCounter;
        }
        catch (RuntimeException | ShortBufferException ex) {
            throw new IntegrityException("General error: " + ex.getMessage());
        }
    }

    private static String dumpString(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    private static byte[] generateClientSigningKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + CLIENT_SIGNING_MAGIC_CONSTANT.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(CLIENT_SIGNING_MAGIC_CONSTANT, 0, dataforhash, secondarySessionKey.length, CLIENT_SIGNING_MAGIC_CONSTANT.length);
        return DigestHelper.md5(dataforhash);
    }

    private static byte[] generateClientSealingKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + CLIENT_SEALING_MAGIC_CONSTANT.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(CLIENT_SEALING_MAGIC_CONSTANT, 0, dataforhash, secondarySessionKey.length, CLIENT_SEALING_MAGIC_CONSTANT.length);
        return DigestHelper.md5(dataforhash);
    }

    private static byte[] generateServerSigningKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + SERVER_SIGNING_MAGIC_CONSTANT.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(SERVER_SIGNING_MAGIC_CONSTANT, 0, dataforhash, secondarySessionKey.length, SERVER_SIGNING_MAGIC_CONSTANT.length);
        return DigestHelper.md5(dataforhash);
    }

    private static byte[] generateServerSealingKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + SERVER_SEALING_MAGIC_CONSTANT.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(SERVER_SEALING_MAGIC_CONSTANT, 0, dataforhash, secondarySessionKey.length, SERVER_SEALING_MAGIC_CONSTANT.length);
        return DigestHelper.md5(dataforhash);
    }

    private static byte[] signingPt1(int sequenceNumber, byte[] signingKey, byte[] data, int lengthOfBuffer) {
        byte[] seqNumPlusData = new byte[4 + lengthOfBuffer];
        seqNumPlusData[0] = (byte)(sequenceNumber & 0xFF);
        seqNumPlusData[1] = (byte)(sequenceNumber >> 8 & 0xFF);
        seqNumPlusData[2] = (byte)(sequenceNumber >> 16 & 0xFF);
        seqNumPlusData[3] = (byte)(sequenceNumber >> 24 & 0xFF);
        System.arraycopy(data, 0, seqNumPlusData, 4, lengthOfBuffer);
        byte[] retval = new byte[16];
        retval[0] = 1;
        byte[] sign = Responses.hmacMD5(seqNumPlusData, signingKey);
        System.arraycopy(sign, 0, retval, 4, 8);
        retval[12] = (byte)(sequenceNumber & 0xFF);
        retval[13] = (byte)(sequenceNumber >> 8 & 0xFF);
        retval[14] = (byte)(sequenceNumber >> 16 & 0xFF);
        retval[15] = (byte)(sequenceNumber >> 24 & 0xFF);
        return retval;
    }

    private static void signingPt2(byte[] verifier, Cipher rc4) throws ShortBufferException {
        rc4.update(verifier, 4, 8, verifier, 4);
    }
}

