/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import jcifs.CIFSContext;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.NtlmUtil;
import jcifs.util.Encdec;
import net.sourceforge.jtds.util.SSPIJNIClient;
import rpc.CifsContextSingleton;
import rpc.Security;
import rpc.security.ntlm.AuthenticationSource;
import rpc.security.ntlm.DigestHelper;
import rpc.security.ntlm.Ntlm1;
import rpc.security.ntlm.Responses;

public class NtlmAuthentication {
    private static final Logger LOGGER = Logger.getLogger("org.jinterop");
    private static final String DEFAULT_WORKSTATION = CifsContextSingleton.instance().getNameServiceClient().getLocalHost().getHostName();
    public static final int AUTHENTICATION_SERVICE_NTLM = 10;
    private static final boolean UNICODE_SUPPORTED = CifsContextSingleton.instance().getConfig().isUseUnicode();
    private static final int BASIC_FLAGS = 0x8206 | (UNICODE_SUPPORTED ? 1 : 0);
    private Security security;
    protected Properties properties;
    private NtlmPasswordAuthenticator credentials;
    private AuthenticationSource authenticationSource;
    private boolean lanManagerKey;
    private boolean seal;
    private boolean sign;
    private boolean keyExchange;
    private int keyLength = 128;
    private boolean useNtlm2sessionsecurity = false;
    private boolean useNtlmV2 = false;
    private boolean useSSO = false;
    private static final Random RANDOM = new Random();
    private final SSPIJNIClient jniClient;

    public NtlmAuthentication(Properties properties) {
        this.properties = properties;
        String domain = null;
        String user = null;
        String password = null;
        if (properties != null) {
            this.lanManagerKey = Boolean.valueOf(properties.getProperty("rpc.ntlm.lanManagerKey"));
            this.seal = Boolean.valueOf(properties.getProperty("rpc.ntlm.seal"));
            this.sign = this.seal ? true : Boolean.valueOf(properties.getProperty("rpc.ntlm.sign"));
            this.keyExchange = Boolean.valueOf(properties.getProperty("rpc.ntlm.keyExchange"));
            String keyLength = properties.getProperty("rpc.ntlm.keyLength");
            if (keyLength != null) {
                try {
                    this.keyLength = Integer.parseInt(keyLength);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid key length: " + keyLength);
                }
            }
            this.useNtlm2sessionsecurity = Boolean.valueOf(properties.getProperty("rpc.ntlm.ntlm2"));
            this.useNtlmV2 = Boolean.valueOf(properties.getProperty("rpc.ntlm.ntlmv2"));
            this.useSSO = Boolean.valueOf(properties.getProperty("rpc.ntlm.sso"));
            domain = properties.getProperty("rpc.ntlm.domain");
            user = properties.getProperty("rpc.security.username");
            password = properties.getProperty("rpc.security.password");
        }
        if (this.useSSO) {
            LOGGER.warning("Using deprecated (Windows only) SSO. Use password authentication instead.");
            this.jniClient = SSPIJNIClient.getInstance();
        } else {
            this.jniClient = null;
            this.credentials = new NtlmPasswordAuthenticator(domain, user, password);
        }
    }

    public Security getSecurity() throws IOException {
        return this.security;
    }

    @Deprecated
    protected AuthenticationSource getAuthenticationSource() {
        if (this.authenticationSource == null) {
            String sourceClass;
            String string = sourceClass = this.properties != null ? this.properties.getProperty("rpc.ntlm.authenticationSource") : null;
            if (sourceClass == null) {
                this.authenticationSource = AuthenticationSource.getDefaultInstance();
            }
            if (this.authenticationSource == null) {
                try {
                    this.authenticationSource = (AuthenticationSource)Class.forName(sourceClass).newInstance();
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Invalid authentication source: " + sourceClass, ex);
                }
            }
        }
        return this.authenticationSource;
    }

    public Type1Message createType1() throws IOException {
        if (this.useSSO) {
            byte[] ntlmMessage = this.jniClient.invokePrepareSSORequest();
            Type1Message type1Message = new Type1Message(ntlmMessage);
            type1Message.setFlags(this.getDefaultFlags());
            return type1Message;
        }
        int flags = this.getDefaultFlags();
        return new Type1Message((CIFSContext)CifsContextSingleton.instance(), flags, this.credentials.getUserDomain(), DEFAULT_WORKSTATION);
    }

    public Type2Message createType2(Type1Message type1) throws IOException {
        int flags = type1 == null ? this.getDefaultFlags() : this.adjustFlags(type1.getFlags());
        Type2Message type2Message = new Type2Message((CIFSContext)CifsContextSingleton.instance(), flags |= 0x20000, new byte[]{1, 2, 3, 4, 5, 6, 7, 8}, this.credentials.getUserDomain());
        return type2Message;
    }

    public Type3Message createType3(Type2Message type2) throws IOException {
        if (this.useSSO) {
            byte[] ntlmMessage = type2.toByteArray();
            byte[] ret = this.jniClient.invokePrepareSSOSubmit(ntlmMessage);
            Type3Message message = new Type3Message(ret);
            int flags = type2.getFlags();
            if ((flags & 0x40) != 0) {
                flags = this.adjustFlags(flags);
                flags &= 0xFFFDFFFF;
            }
            message.setFlags(flags);
            return message;
        }
        int flags = type2.getFlags();
        if ((flags & 0x40) != 0) {
            flags = this.adjustFlags(flags);
            flags &= 0xFFFDFFFF;
        }
        Type3Message type3 = null;
        byte[] clientNonce = new byte[8];
        byte[] blob = null;
        String target = null;
        if (target == null && (target = this.credentials.getUserDomain().toUpperCase()).isEmpty()) {
            target = NtlmAuthentication.getTargetFromTargetInformation(type2.getTargetInformation());
        }
        if (this.useNtlmV2) {
            RANDOM.nextBytes(clientNonce);
            try {
                byte[] lmv2Response = Responses.getLMv2Response(target, this.credentials.getUsername(), this.credentials.getPassword(), type2.getChallenge(), clientNonce);
                byte[][] retval = Responses.getNTLMv2Response(target, this.credentials.getUsername(), this.credentials.getPassword(), type2.getTargetInformation(), type2.getChallenge(), clientNonce);
                byte[] ntlmv2Response = retval[0];
                blob = retval[1];
                type3 = new Type3Message(flags, lmv2Response, ntlmv2Response, target, this.credentials.getUsername(), DEFAULT_WORKSTATION);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occured while forming NTLMv2 Type3Response", e);
            }
        }
        if ((flags & 0x80000) != 0) {
            flags = this.adjustFlags(flags);
            flags &= 0xFFFDFFFF;
            challenge = type2.getChallenge();
            lmResponse = new byte[24];
            RANDOM.nextBytes(clientNonce);
            System.arraycopy(clientNonce, 0, lmResponse, 0, clientNonce.length);
            try {
                ntResponse = Responses.getNTLM2SessionResponse(this.credentials.getPassword(), challenge, clientNonce);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occured while forming Session Security Type3Response", e);
            }
            type3 = new Type3Message(flags, lmResponse, ntResponse, target, this.credentials.getUsername(), DEFAULT_WORKSTATION);
        } else {
            challenge = type2.getChallenge();
            try {
                lmResponse = NtlmUtil.getPreNTLMResponse((CIFSContext)CifsContextSingleton.instance(), (String)this.credentials.getPassword(), (byte[])challenge);
                ntResponse = NtlmUtil.getNTLMResponse((String)this.credentials.getPassword(), (byte[])challenge);
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            type3 = new Type3Message(flags, lmResponse, ntResponse, target, this.credentials.getUsername(), null);
            if ((flags & 0x40000000) != 0) {
                throw new RuntimeException("Key Exchange not supported by Library !");
            }
        }
        if (this.useNtlm2sessionsecurity && (flags & 0x80000) != 0) {
            byte[] userSessionKey;
            if (this.useNtlmV2) {
                try {
                    userSessionKey = NtlmAuthentication.getNTLMv2UserSessionKey(target, this.credentials.getUsername(), this.credentials.getPassword(), type2.getChallenge(), blob);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception occured while forming NTLMv2 with NTLM2 Session Security for Type3Response", e);
                }
            }
            byte[] servernonce = new byte[16];
            System.arraycopy(type2.getChallenge(), 0, servernonce, 0, type2.getChallenge().length);
            System.arraycopy(clientNonce, 0, servernonce, 8, clientNonce.length);
            try {
                userSessionKey = NtlmAuthentication.getNTLM2SessionResponseUserSessionKey(this.credentials.getPassword(), servernonce);
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("Exception occured while forming Session Security for Type3Response", ex);
            }
            try {
                byte[] secondayMasterKey = NtlmAuthentication.getSecondarySessionKey();
                type3.setEncryptedSessionKey(NtlmAuthentication.encryptSecondarySessionKey(secondayMasterKey, userSessionKey));
                this.security = new Ntlm1(flags, secondayMasterKey, false);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occured while forming Session Security for Type3Response", e);
            }
        }
        return type3;
    }

    void createSecurityWhenServer(NtlmMessage type3) {
        Type3Message type3Message = (Type3Message)type3;
        int flags = type3Message.getFlags();
        byte[] sessionResponseUserSessionKey = null;
        if (type3Message.getFlag(2048)) {
            sessionResponseUserSessionKey = new byte[16];
        } else if (!this.useNtlmV2) {
            byte[] servernonce = new byte[16];
            byte[] challenge = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
            System.arraycopy(challenge, 0, servernonce, 0, challenge.length);
            System.arraycopy(type3Message.getLMResponse(), 0, servernonce, 8, 8);
            try {
                sessionResponseUserSessionKey = NtlmAuthentication.getNTLM2SessionResponseUserSessionKey(this.credentials.getPassword(), servernonce);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occured while forming Session Security from Type3 AUTH", e);
            }
        }
        try {
            byte[] secondayMasterKey = NtlmAuthentication.decryptSecondarySessionKey(type3Message.getEncryptedSessionKey(), sessionResponseUserSessionKey);
            this.security = new Ntlm1(flags, secondayMasterKey, true);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Exception occured while forming Session Security Type3Response", ex);
        }
    }

    private int getDefaultFlags() {
        int flags = BASIC_FLAGS;
        if (this.lanManagerKey) {
            flags |= 0x80;
        }
        if (this.sign) {
            flags |= 0x10;
        }
        if (this.seal) {
            flags |= 0x20;
        }
        if (this.keyExchange) {
            flags |= 0x40000000;
        }
        if (this.keyLength >= 56) {
            flags |= Integer.MIN_VALUE;
        }
        if (this.keyLength >= 128) {
            flags |= 0x20000000;
        }
        return flags |= 0x80000;
    }

    private int adjustFlags(int flags) {
        int adjustedFlags = flags;
        if (UNICODE_SUPPORTED && (adjustedFlags & 1) != 0) {
            adjustedFlags &= 0xFFFFFFFD;
            adjustedFlags |= 1;
        } else {
            adjustedFlags &= 0xFFFFFFFE;
            adjustedFlags |= 2;
        }
        if (!this.lanManagerKey) {
            adjustedFlags &= 0xFFFFFF7F;
        }
        if (!this.sign && !this.seal) {
            adjustedFlags &= 0xFFFFFFEF;
        }
        if (!this.seal) {
            adjustedFlags &= 0xFFFFFFDF;
        }
        if (!this.keyExchange) {
            adjustedFlags &= 0xBFFFFFFF;
        }
        if (this.keyLength < 128) {
            adjustedFlags &= 0xDFFFFFFF;
        }
        if (this.keyLength < 56) {
            adjustedFlags &= Integer.MAX_VALUE;
        }
        return adjustedFlags;
    }

    private static String getTargetFromTargetInformation(byte[] targetInformation) {
        String target = null;
        int i = 0;
        while (i < targetInformation.length) {
            switch (Encdec.dec_uint16le((byte[])targetInformation, (int)i)) {
                case 1: {
                    ++i;
                    short length = Encdec.dec_uint16le((byte[])targetInformation, (int)(++i));
                    ++i;
                    byte[] domainb = new byte[length];
                    System.arraycopy(targetInformation, ++i, domainb, 0, length);
                    target = new String(domainb, StandardCharsets.UTF_16LE);
                    i = targetInformation.length;
                    break;
                }
                default: {
                    ++i;
                    short length = Encdec.dec_uint16le((byte[])targetInformation, (int)(++i));
                    ++i;
                    ++i;
                    i += length;
                }
            }
        }
        return target;
    }

    private static byte[] decryptSecondarySessionKey(byte[] encryptedData, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(2, new SecretKeySpec(key, "RC4"));
            return cipher.update(encryptedData);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Failed to decrypt secondary session key");
        }
    }

    private static byte[] encryptSecondarySessionKey(byte[] plainData, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(1, new SecretKeySpec(key, "RC4"));
            return cipher.update(plainData);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Failed to encrypt secondary session key");
        }
    }

    private static byte[] getSecondarySessionKey() {
        byte[] key = new byte[16];
        RANDOM.nextBytes(key);
        return key;
    }

    private static byte[] getNTLMv2UserSessionKey(String target, String user, String password, byte[] challenge, byte[] blob) throws Exception {
        byte[] ntlm2Hash = Responses.ntlmv2Hash(target, user, password);
        byte[] data = new byte[challenge.length + blob.length];
        System.arraycopy(challenge, 0, data, 0, challenge.length);
        System.arraycopy(blob, 0, data, challenge.length, blob.length);
        byte[] mac = Responses.hmacMD5(data, ntlm2Hash);
        byte[] key = Responses.hmacMD5(mac, ntlm2Hash);
        return key;
    }

    private static byte[] getNTLM2SessionResponseUserSessionKey(String password, byte[] servernonce) {
        byte[] ntlmHash = Responses.ntlmHash(password);
        byte[] nTLMUserSessionKey = DigestHelper.md4(ntlmHash);
        return Responses.hmacMD5(servernonce, nTLMUserSessionKey);
    }
}

