/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.dcom.list.impl;

import java.net.UnknownHostException;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIClsid;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JIString;
import org.openscada.opc.dcom.common.impl.BaseCOMObject;
import org.openscada.opc.dcom.common.impl.EnumGUID;
import org.openscada.opc.dcom.common.impl.Helper;
import org.openscada.opc.dcom.list.ClassDetails;
import rpc.core.UUID;

public class OPCServerList
extends BaseCOMObject {
    public OPCServerList(IJIComObject listObject) throws JIException {
        super(listObject.queryInterface("13486D50-4821-11D2-A494-3CB306C10000"));
    }

    public JIClsid getCLSIDFromProgID(String progId) throws JIException {
        JICallBuilder callObject = new JICallBuilder(true);
        callObject.setOpnum(2);
        callObject.addInParamAsString(progId, 4);
        callObject.addOutParamAsType(UUID.class, 0);
        try {
            Object[] result = this.getCOMObject().call(callObject);
            return JIClsid.valueOf((String)((UUID)result[0]).toString());
        }
        catch (JIException e) {
            if (e.getErrorCode() == -2147221005) {
                return null;
            }
            throw e;
        }
    }

    public ClassDetails getClassDetails(JIClsid clsId) throws JIException {
        if (clsId == null) {
            return null;
        }
        JICallBuilder callObject = new JICallBuilder(true);
        callObject.setOpnum(1);
        callObject.addInParamAsUUID(clsId.getCLSID(), 0);
        callObject.addOutParamAsObject((Object)new JIPointer((Object)new JIString(4)), 0);
        callObject.addOutParamAsObject((Object)new JIPointer((Object)new JIString(4)), 0);
        Object[] result = Helper.callRespectSFALSE(this.getCOMObject(), callObject);
        ClassDetails cd = new ClassDetails();
        cd.setClsId(clsId.getCLSID());
        cd.setProgId(((JIString)((JIPointer)result[0]).getReferent()).getString());
        cd.setDescription(((JIString)((JIPointer)result[1]).getReferent()).getString());
        return cd;
    }

    public EnumGUID enumClassesOfCategories(String[] implemented, String[] required) throws IllegalArgumentException, UnknownHostException, JIException {
        UUID[] u1 = new UUID[implemented.length];
        UUID[] u2 = new UUID[required.length];
        int i = 0;
        while (i < implemented.length) {
            u1[i] = new UUID(implemented[i]);
            ++i;
        }
        i = 0;
        while (i < required.length) {
            u2[i] = new UUID(required[i]);
            ++i;
        }
        return this.enumClassesOfCategories(u1, u2);
    }

    public EnumGUID enumClassesOfCategories(UUID[] implemented, UUID[] required) throws IllegalArgumentException, UnknownHostException, JIException {
        JICallBuilder callObject = new JICallBuilder(true);
        callObject.setOpnum(0);
        callObject.addInParamAsInt(implemented.length, 0);
        if (implemented.length == 0) {
            callObject.addInParamAsPointer(new JIPointer(null), 0);
        } else {
            callObject.addInParamAsArray(new JIArray((Object)implemented, true), 0);
        }
        callObject.addInParamAsInt(required.length, 0);
        if (required.length == 0) {
            callObject.addInParamAsPointer(new JIPointer(null), 0);
        } else {
            callObject.addInParamAsArray(new JIArray((Object)required, true), 0);
        }
        callObject.addOutParamAsType(IJIComObject.class, 0);
        Object[] result = Helper.callRespectSFALSE(this.getCOMObject(), callObject);
        return new EnumGUID((IJIComObject)result[0]);
    }
}

