/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.da;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jinterop.dcom.common.JIException;
import org.openscada.opc.lib.common.NotConnectedException;
import org.openscada.opc.lib.da.AccessStateListener;
import org.openscada.opc.lib.da.AddFailedException;
import org.openscada.opc.lib.da.DataCallback;
import org.openscada.opc.lib.da.DuplicateGroupException;
import org.openscada.opc.lib.da.Group;
import org.openscada.opc.lib.da.Item;
import org.openscada.opc.lib.da.ItemState;
import org.openscada.opc.lib.da.Server;
import org.openscada.opc.lib.da.ServerConnectionStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccessBase
implements ServerConnectionStateListener {
    private static Logger logger = LoggerFactory.getLogger(AccessBase.class);
    protected Server server;
    protected Group group;
    protected boolean active;
    private final List<AccessStateListener> stateListeners = new CopyOnWriteArrayList<AccessStateListener>();
    private boolean bound;
    protected Map<Item, DataCallback> items = new HashMap<Item, DataCallback>();
    protected Map<String, Item> itemMap = new HashMap<String, Item>();
    protected Map<Item, ItemState> itemCache = new HashMap<Item, ItemState>();
    private final int period;
    protected Map<String, DataCallback> itemSet = new HashMap<String, DataCallback>();
    protected String logTag;
    protected Logger dataLogger;

    public AccessBase(Server server, int period) throws IllegalArgumentException, UnknownHostException, NotConnectedException, JIException, DuplicateGroupException {
        this.server = server;
        this.period = period;
    }

    public AccessBase(Server server, int period, String logTag) {
        this.server = server;
        this.period = period;
        this.logTag = logTag;
        if (this.logTag != null) {
            this.dataLogger = LoggerFactory.getLogger((String)("opc.data." + logTag));
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public synchronized void bind() {
        if (this.isBound()) {
            return;
        }
        this.server.addStateListener(this);
        this.bound = true;
    }

    public synchronized void unbind() throws JIException {
        if (!this.isBound()) {
            return;
        }
        this.server.removeStateListener(this);
        this.bound = false;
        this.stop();
    }

    public boolean isActive() {
        return this.active;
    }

    public void addStateListener(AccessStateListener listener) {
        this.stateListeners.add(listener);
        listener.stateChanged(this.isActive());
    }

    public void removeStateListener(AccessStateListener listener) {
        this.stateListeners.remove(listener);
    }

    protected void notifyStateListenersState(boolean state) {
        ArrayList<AccessStateListener> list = new ArrayList<AccessStateListener>(this.stateListeners);
        for (AccessStateListener listener : list) {
            listener.stateChanged(state);
        }
    }

    protected void notifyStateListenersError(Throwable t) {
        ArrayList<AccessStateListener> list = new ArrayList<AccessStateListener>(this.stateListeners);
        for (AccessStateListener listener : list) {
            listener.errorOccured(t);
        }
    }

    public int getPeriod() {
        return this.period;
    }

    public synchronized void addItem(String itemId, DataCallback dataCallback) throws JIException, AddFailedException {
        if (this.itemSet.containsKey(itemId)) {
            return;
        }
        this.itemSet.put(itemId, dataCallback);
        if (this.isActive()) {
            this.realizeItem(itemId);
        }
    }

    public synchronized void removeItem(String itemId) {
        if (!this.itemSet.containsKey(itemId)) {
            return;
        }
        this.itemSet.remove(itemId);
        if (this.isActive()) {
            this.unrealizeItem(itemId);
        }
    }

    @Override
    public void connectionStateChanged(boolean connected) {
        try {
            if (connected) {
                this.start();
            } else {
                this.stop();
            }
        }
        catch (Exception e) {
            logger.error(String.format("Failed to change state (%s)", connected), (Throwable)e);
        }
    }

    protected synchronized void start() throws JIException, IllegalArgumentException, UnknownHostException, NotConnectedException, DuplicateGroupException {
        if (this.isActive()) {
            return;
        }
        logger.debug("Create a new group");
        this.group = this.server.addGroup();
        this.group.setActive(true, this.period);
        this.active = true;
        this.notifyStateListenersState(true);
        this.realizeAll();
    }

    protected void realizeItem(String itemId) throws JIException, AddFailedException {
        logger.debug("Realizing item: {}", (Object)itemId);
        DataCallback dataCallback = this.itemSet.get(itemId);
        if (dataCallback == null) {
            return;
        }
        Item item = this.group.addItem(itemId);
        this.items.put(item, dataCallback);
        this.itemMap.put(itemId, item);
    }

    protected void unrealizeItem(String itemId) {
        Item item = this.itemMap.remove(itemId);
        this.items.remove(item);
        this.itemCache.remove(item);
        try {
            this.group.removeItem(itemId);
        }
        catch (Throwable e) {
            logger.error(String.format("Failed to unrealize item '%s'", itemId), e);
        }
    }

    protected void realizeAll() {
        for (String itemId : this.itemSet.keySet()) {
            try {
                this.realizeItem(itemId);
            }
            catch (AddFailedException e) {
                Integer rc = e.getErrors().get(itemId);
                if (rc == null) {
                    rc = -1;
                }
                logger.warn(String.format("Failed to add item: %s (%08X)", itemId, rc));
            }
            catch (Exception e) {
                logger.warn("Failed to realize item: " + itemId, (Throwable)e);
            }
        }
    }

    protected void unrealizeAll() {
        this.items.clear();
        this.itemCache.clear();
        try {
            this.group.clear();
        }
        catch (JIException e) {
            logger.info("Failed to clear group. No problem if we already lost the connection", (Throwable)e);
        }
    }

    protected synchronized void stop() throws JIException {
        if (!this.isActive()) {
            return;
        }
        this.unrealizeAll();
        this.active = false;
        this.notifyStateListenersState(false);
        try {
            this.group.remove();
        }
        catch (Throwable throwable) {
            logger.warn("Failed to disable group. No problem if we already lost connection");
        }
        this.group = null;
    }

    public synchronized void clear() {
        this.itemSet.clear();
        this.items.clear();
        this.itemMap.clear();
        this.itemCache.clear();
    }

    protected void updateItem(Item item, ItemState itemState) {
        DataCallback dataCallback;
        if (this.dataLogger != null) {
            this.dataLogger.debug("Update item: {}, {}", (Object)item.getId(), (Object)itemState);
        }
        if ((dataCallback = this.items.get(item)) == null) {
            return;
        }
        ItemState cachedState = this.itemCache.get(item);
        if (cachedState == null) {
            this.itemCache.put(item, itemState);
            dataCallback.changed(item, itemState);
        } else if (!cachedState.equals(itemState)) {
            this.itemCache.put(item, itemState);
            dataCallback.changed(item, itemState);
        }
    }

    protected void handleError(Throwable e) {
        this.notifyStateListenersError(e);
        this.server.dispose();
    }
}

