/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.tutorial;

import java.util.Map;
import java.util.concurrent.Executors;
import org.jinterop.dcom.common.JIException;
import org.openscada.opc.lib.common.ConnectionInformation;
import org.openscada.opc.lib.da.DataCallback;
import org.openscada.opc.lib.da.Group;
import org.openscada.opc.lib.da.Item;
import org.openscada.opc.lib.da.ItemState;
import org.openscada.opc.lib.da.Server;
import org.openscada.opc.lib.da.SyncAccess;
import org.openscada.opc.lib.da.browser.Branch;
import org.openscada.opc.lib.da.browser.TreeBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtgardTutorial1 {
    private static Logger logger = LoggerFactory.getLogger(UtgardTutorial1.class);

    public static void main(String[] args) throws Exception {
        ConnectionInformation ci = new ConnectionInformation();
        ci.setHost("elp-999-vpn");
        ci.setDomain("");
        ci.setUser("EOS-Admin");
        ci.setPassword("XXXXXXXX");
        ci.setProgId("Matrikon.OPC.Simulation.1");
        ci.setClsid("F8582CF2-88FB-11D0-B850-00C0F0104305");
        Server server = new Server(ci, Executors.newSingleThreadScheduledExecutor());
        try {
            server.connect();
            TreeBrowser browser = server.getTreeBrowser();
            Branch branch = browser.browseBranches();
            branch.getBranches().forEach(b -> logger.info(String.format("branch: %s", b.getName())));
            branch.getLeaves().forEach(l -> logger.info(String.format("leaves: %s", l.getItemId())));
            Group g = server.addGroup("mygroup");
            Map<String, Item> items = g.addItems("Triangle Waves.Real8", "Random.Real8", "Triangle Waves.Real8");
            Item[] itemsArray = items.values().toArray(new Item[0]);
            int i = 0;
            while (i < 10000) {
                Map<Item, ItemState> states = g.read(false, itemsArray);
                states.forEach((item, state) -> {
                    System.out.println(String.valueOf(item.getId()) + ": " + state.toString());
                    logger.info(String.format("Item %s; State: %s", item.getId(), state));
                });
                Thread.sleep(1000L);
                ++i;
            }
            SyncAccess access = new SyncAccess(server, 1000);
            access.addItem("Triangle Waves.Real8", new DataCallback(){

                @Override
                public void changed(Item item, ItemState state) {
                    logger.info(state.toString());
                }
            });
            access.addItem("Random.Real8", new DataCallback(){

                @Override
                public void changed(Item item, ItemState state) {
                    logger.info(state.toString());
                }
            });
            access.bind();
            Thread.sleep(100000L);
            access.unbind();
        }
        catch (JIException e) {
            System.out.println(String.format("%08X: %s", e.getErrorCode(), server.getErrorMessage(e.getErrorCode())));
        }
    }
}

