/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Subroutine;
import org.objectweb.asm.tree.analysis.Value;

public class Analyzer<V extends Value>
implements Opcodes {
    private final Interpreter<V> interpreter;
    private InsnList insnList;
    private int insnListSize;
    private List<TryCatchBlockNode>[] handlers;
    private Frame<V>[] frames;
    private Subroutine[] subroutines;
    private boolean[] inInstructionsToProcess;
    private int[] instructionsToProcess;
    private int numInstructionsToProcess;

    public Analyzer(Interpreter<V> interpreter) {
        this.interpreter = interpreter;
    }

    public Frame<V>[] analyze(String owner, MethodNode method) throws AnalyzerException {
        if ((method.access & 0x500) != 0) {
            this.frames = new Frame[0];
            return this.frames;
        }
        this.insnList = method.instructions;
        this.insnListSize = this.insnList.size();
        this.handlers = new List[this.insnListSize];
        this.frames = new Frame[this.insnListSize];
        this.subroutines = new Subroutine[this.insnListSize];
        this.inInstructionsToProcess = new boolean[this.insnListSize];
        this.instructionsToProcess = new int[this.insnListSize];
        this.numInstructionsToProcess = 0;
        int i = 0;
        while (i < method.tryCatchBlocks.size()) {
            TryCatchBlockNode tryCatchBlock = (TryCatchBlockNode)method.tryCatchBlocks.get(i);
            int startIndex = this.insnList.indexOf((AbstractInsnNode)tryCatchBlock.start);
            int endIndex = this.insnList.indexOf((AbstractInsnNode)tryCatchBlock.end);
            int j = startIndex;
            while (j < endIndex) {
                List<TryCatchBlockNode> insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                }
                insnHandlers.add(tryCatchBlock);
                ++j;
            }
            ++i;
        }
        Subroutine main = new Subroutine(null, method.maxLocals, null);
        ArrayList<AbstractInsnNode> jsrInsns = new ArrayList<AbstractInsnNode>();
        this.findSubroutine(0, main, jsrInsns);
        HashMap<LabelNode, Subroutine> jsrSubroutines = new HashMap<LabelNode, Subroutine>();
        while (!jsrInsns.isEmpty()) {
            JumpInsnNode jsrInsn = (JumpInsnNode)jsrInsns.remove(0);
            Subroutine subroutine = (Subroutine)jsrSubroutines.get(jsrInsn.label);
            if (subroutine == null) {
                subroutine = new Subroutine(jsrInsn.label, method.maxLocals, jsrInsn);
                jsrSubroutines.put(jsrInsn.label, subroutine);
                this.findSubroutine(this.insnList.indexOf((AbstractInsnNode)jsrInsn.label), subroutine, jsrInsns);
                continue;
            }
            subroutine.callers.add(jsrInsn);
        }
        int i2 = 0;
        while (i2 < this.insnListSize) {
            if (this.subroutines[i2] != null && this.subroutines[i2].start == null) {
                this.subroutines[i2] = null;
            }
            ++i2;
        }
        Frame<V> currentFrame = this.computeInitialFrame(owner, method);
        this.merge(0, currentFrame, null);
        this.init(owner, method);
        while (this.numInstructionsToProcess > 0) {
            int insnIndex = this.instructionsToProcess[--this.numInstructionsToProcess];
            Frame<V> oldFrame = this.frames[insnIndex];
            Subroutine subroutine = this.subroutines[insnIndex];
            this.inInstructionsToProcess[insnIndex] = false;
            AbstractInsnNode insnNode = null;
            try {
                insnNode = method.instructions.get(insnIndex);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.merge(insnIndex + 1, oldFrame, subroutine);
                    this.newControlFlowEdge(insnIndex, insnIndex + 1);
                } else {
                    currentFrame.init(oldFrame).execute(insnNode, this.interpreter);
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : new Subroutine(subroutine);
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode jumpInsn = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            currentFrame.initJumpTarget(insnOpcode, null);
                            this.merge(insnIndex + 1, currentFrame, subroutine);
                            this.newControlFlowEdge(insnIndex, insnIndex + 1);
                        }
                        int jumpInsnIndex = this.insnList.indexOf((AbstractInsnNode)jumpInsn.label);
                        currentFrame.initJumpTarget(insnOpcode, jumpInsn.label);
                        if (insnOpcode == 168) {
                            this.merge(jumpInsnIndex, currentFrame, new Subroutine(jumpInsn.label, method.maxLocals, jumpInsn));
                        } else {
                            this.merge(jumpInsnIndex, currentFrame, subroutine);
                        }
                        this.newControlFlowEdge(insnIndex, jumpInsnIndex);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf((AbstractInsnNode)lookupSwitchInsn.dflt);
                        currentFrame.initJumpTarget(insnOpcode, lookupSwitchInsn.dflt);
                        this.merge(targetInsnIndex, currentFrame, subroutine);
                        this.newControlFlowEdge(insnIndex, targetInsnIndex);
                        int i3 = 0;
                        while (i3 < lookupSwitchInsn.labels.size()) {
                            label = (LabelNode)lookupSwitchInsn.labels.get(i3);
                            targetInsnIndex = this.insnList.indexOf((AbstractInsnNode)label);
                            currentFrame.initJumpTarget(insnOpcode, label);
                            this.merge(targetInsnIndex, currentFrame, subroutine);
                            this.newControlFlowEdge(insnIndex, targetInsnIndex);
                            ++i3;
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf((AbstractInsnNode)tableSwitchInsn.dflt);
                        currentFrame.initJumpTarget(insnOpcode, tableSwitchInsn.dflt);
                        this.merge(targetInsnIndex, currentFrame, subroutine);
                        this.newControlFlowEdge(insnIndex, targetInsnIndex);
                        int i4 = 0;
                        while (i4 < tableSwitchInsn.labels.size()) {
                            label = (LabelNode)tableSwitchInsn.labels.get(i4);
                            currentFrame.initJumpTarget(insnOpcode, label);
                            targetInsnIndex = this.insnList.indexOf((AbstractInsnNode)label);
                            this.merge(targetInsnIndex, currentFrame, subroutine);
                            this.newControlFlowEdge(insnIndex, targetInsnIndex);
                            ++i4;
                        }
                    } else if (insnOpcode == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException(insnNode, "RET instruction outside of a subroutine");
                        }
                        int i5 = 0;
                        while (i5 < subroutine.callers.size()) {
                            JumpInsnNode caller = subroutine.callers.get(i5);
                            int jsrInsnIndex = this.insnList.indexOf((AbstractInsnNode)caller);
                            if (this.frames[jsrInsnIndex] != null) {
                                this.merge(jsrInsnIndex + 1, this.frames[jsrInsnIndex], currentFrame, this.subroutines[jsrInsnIndex], subroutine.localsUsed);
                                this.newControlFlowEdge(insnIndex, jsrInsnIndex + 1);
                            }
                            ++i5;
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        if (subroutine != null) {
                            if (insnNode instanceof VarInsnNode) {
                                int var = ((VarInsnNode)insnNode).var;
                                subroutine.localsUsed[var] = true;
                                if (insnOpcode == 22 || insnOpcode == 24 || insnOpcode == 55 || insnOpcode == 57) {
                                    subroutine.localsUsed[var + 1] = true;
                                }
                            } else if (insnNode instanceof IincInsnNode) {
                                int var = ((IincInsnNode)insnNode).var;
                                subroutine.localsUsed[var] = true;
                            }
                        }
                        this.merge(insnIndex + 1, currentFrame, subroutine);
                        this.newControlFlowEdge(insnIndex, insnIndex + 1);
                    }
                }
                List<TryCatchBlockNode> insnHandlers = this.handlers[insnIndex];
                if (insnHandlers == null) continue;
                for (TryCatchBlockNode tryCatchBlock : insnHandlers) {
                    Type catchType = tryCatchBlock.type == null ? Type.getObjectType((String)"java/lang/Throwable") : Type.getObjectType((String)tryCatchBlock.type);
                    if (!this.newControlFlowExceptionEdge(insnIndex, tryCatchBlock)) continue;
                    Frame<V> handler = this.newFrame(oldFrame);
                    handler.clearStack();
                    handler.push(this.interpreter.newExceptionValue(tryCatchBlock, handler, catchType));
                    this.merge(this.insnList.indexOf((AbstractInsnNode)tryCatchBlock.handler), handler, subroutine);
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction " + insnIndex + ": " + e.getMessage(), e);
            }
            catch (RuntimeException e) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insnIndex + ": " + e.getMessage(), e);
            }
        }
        return this.frames;
    }

    private void findSubroutine(int insnIndex, Subroutine subroutine, List<AbstractInsnNode> jsrInsns) throws AnalyzerException {
        ArrayList<Integer> instructionIndicesToProcess = new ArrayList<Integer>();
        instructionIndicesToProcess.add(insnIndex);
        while (!instructionIndicesToProcess.isEmpty()) {
            int currentInsnIndex = (Integer)instructionIndicesToProcess.remove(instructionIndicesToProcess.size() - 1);
            if (currentInsnIndex < 0 || currentInsnIndex >= this.insnListSize) {
                throw new AnalyzerException(null, "Execution can fall off the end of the code");
            }
            if (this.subroutines[currentInsnIndex] != null) continue;
            this.subroutines[currentInsnIndex] = new Subroutine(subroutine);
            AbstractInsnNode currentInsn = this.insnList.get(currentInsnIndex);
            if (currentInsn instanceof JumpInsnNode) {
                if (currentInsn.getOpcode() == 168) {
                    jsrInsns.add(currentInsn);
                } else {
                    JumpInsnNode jumpInsn = (JumpInsnNode)currentInsn;
                    instructionIndicesToProcess.add(this.insnList.indexOf((AbstractInsnNode)jumpInsn.label));
                }
            } else if (currentInsn instanceof TableSwitchInsnNode) {
                TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)currentInsn;
                this.findSubroutine(this.insnList.indexOf((AbstractInsnNode)tableSwitchInsn.dflt), subroutine, jsrInsns);
                int i = tableSwitchInsn.labels.size() - 1;
                while (i >= 0) {
                    labelNode = (LabelNode)tableSwitchInsn.labels.get(i);
                    instructionIndicesToProcess.add(this.insnList.indexOf((AbstractInsnNode)labelNode));
                    --i;
                }
            } else if (currentInsn instanceof LookupSwitchInsnNode) {
                LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)currentInsn;
                this.findSubroutine(this.insnList.indexOf((AbstractInsnNode)lookupSwitchInsn.dflt), subroutine, jsrInsns);
                int i = lookupSwitchInsn.labels.size() - 1;
                while (i >= 0) {
                    labelNode = (LabelNode)lookupSwitchInsn.labels.get(i);
                    instructionIndicesToProcess.add(this.insnList.indexOf((AbstractInsnNode)labelNode));
                    --i;
                }
            }
            List<TryCatchBlockNode> insnHandlers = this.handlers[currentInsnIndex];
            if (insnHandlers != null) {
                for (TryCatchBlockNode tryCatchBlock : insnHandlers) {
                    instructionIndicesToProcess.add(this.insnList.indexOf((AbstractInsnNode)tryCatchBlock.handler));
                }
            }
            switch (currentInsn.getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    break;
                }
                default: {
                    instructionIndicesToProcess.add(currentInsnIndex + 1);
                }
            }
        }
    }

    private Frame<V> computeInitialFrame(String owner, MethodNode method) {
        Type[] argumentTypes;
        boolean isInstanceMethod;
        Frame<V> frame = this.newFrame(method.maxLocals, method.maxStack);
        int currentLocal = 0;
        boolean bl = isInstanceMethod = (method.access & 8) == 0;
        if (isInstanceMethod) {
            Type ownerType = Type.getObjectType((String)owner);
            frame.setLocal(currentLocal, this.interpreter.newParameterValue(isInstanceMethod, currentLocal, ownerType));
            ++currentLocal;
        }
        Type[] typeArray = argumentTypes = Type.getArgumentTypes((String)method.desc);
        int n = argumentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type argumentType = typeArray[n2];
            frame.setLocal(currentLocal, this.interpreter.newParameterValue(isInstanceMethod, currentLocal, argumentType));
            ++currentLocal;
            if (argumentType.getSize() == 2) {
                frame.setLocal(currentLocal, this.interpreter.newEmptyValue(currentLocal));
                ++currentLocal;
            }
            ++n2;
        }
        while (currentLocal < method.maxLocals) {
            frame.setLocal(currentLocal, this.interpreter.newEmptyValue(currentLocal));
            ++currentLocal;
        }
        frame.setReturn(this.interpreter.newReturnTypeValue(Type.getReturnType((String)method.desc)));
        return frame;
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    public List<TryCatchBlockNode> getHandlers(int insnIndex) {
        return this.handlers[insnIndex];
    }

    protected void init(String owner, MethodNode method) throws AnalyzerException {
    }

    protected Frame<V> newFrame(int numLocals, int numStack) {
        return new Frame(numLocals, numStack);
    }

    protected Frame<V> newFrame(Frame<? extends V> frame) {
        return new Frame<V>(frame);
    }

    protected void newControlFlowEdge(int insnIndex, int successorIndex) {
    }

    protected boolean newControlFlowExceptionEdge(int insnIndex, int successorIndex) {
        return true;
    }

    protected boolean newControlFlowExceptionEdge(int insnIndex, TryCatchBlockNode tryCatchBlock) {
        return this.newControlFlowExceptionEdge(insnIndex, this.insnList.indexOf((AbstractInsnNode)tryCatchBlock.handler));
    }

    private void merge(int insnIndex, Frame<V> frame, Subroutine subroutine) throws AnalyzerException {
        boolean changed;
        Frame<V> oldFrame = this.frames[insnIndex];
        if (oldFrame == null) {
            this.frames[insnIndex] = this.newFrame(frame);
            changed = true;
        } else {
            changed = oldFrame.merge(frame, this.interpreter);
        }
        Subroutine oldSubroutine = this.subroutines[insnIndex];
        if (oldSubroutine == null) {
            if (subroutine != null) {
                this.subroutines[insnIndex] = new Subroutine(subroutine);
                changed = true;
            }
        } else if (subroutine != null) {
            changed |= oldSubroutine.merge(subroutine);
        }
        if (changed && !this.inInstructionsToProcess[insnIndex]) {
            this.inInstructionsToProcess[insnIndex] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = insnIndex;
        }
    }

    private void merge(int insnIndex, Frame<V> frameBeforeJsr, Frame<V> frameAfterRet, Subroutine subroutineBeforeJsr, boolean[] localsUsed) throws AnalyzerException {
        boolean changed;
        frameAfterRet.merge(frameBeforeJsr, localsUsed);
        Frame<V> oldFrame = this.frames[insnIndex];
        if (oldFrame == null) {
            this.frames[insnIndex] = this.newFrame(frameAfterRet);
            changed = true;
        } else {
            changed = oldFrame.merge(frameAfterRet, this.interpreter);
        }
        Subroutine oldSubroutine = this.subroutines[insnIndex];
        if (oldSubroutine != null && subroutineBeforeJsr != null) {
            changed |= oldSubroutine.merge(subroutineBeforeJsr);
        }
        if (changed && !this.inInstructionsToProcess[insnIndex]) {
            this.inInstructionsToProcess[insnIndex] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = insnIndex;
        }
    }
}

