/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.analysis;

import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;

public class BasicVerifier
extends BasicInterpreter {
    public BasicVerifier() {
        super(458752);
        if (this.getClass() != BasicVerifier.class) {
            throw new IllegalStateException();
        }
    }

    protected BasicVerifier(int api) {
        super(api);
    }

    @Override
    public BasicValue copyOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        BasicValue expected;
        switch (insn.getOpcode()) {
            case 21: 
            case 54: {
                expected = BasicValue.INT_VALUE;
                break;
            }
            case 23: 
            case 56: {
                expected = BasicValue.FLOAT_VALUE;
                break;
            }
            case 22: 
            case 55: {
                expected = BasicValue.LONG_VALUE;
                break;
            }
            case 24: 
            case 57: {
                expected = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 25: {
                if (!value.isReference()) {
                    throw new AnalyzerException(insn, null, "an object reference", value);
                }
                return value;
            }
            case 58: {
                if (!value.isReference() && !BasicValue.RETURNADDRESS_VALUE.equals(value)) {
                    throw new AnalyzerException(insn, null, "an object reference or a return address", value);
                }
                return value;
            }
            default: {
                return value;
            }
        }
        if (!((Object)expected).equals(value)) {
            throw new AnalyzerException(insn, null, expected, value);
        }
        return value;
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        BasicValue expected;
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 145: 
            case 146: 
            case 147: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 188: 
            case 189: {
                expected = BasicValue.INT_VALUE;
                break;
            }
            case 118: 
            case 139: 
            case 140: 
            case 141: 
            case 174: {
                expected = BasicValue.FLOAT_VALUE;
                break;
            }
            case 117: 
            case 136: 
            case 137: 
            case 138: 
            case 173: {
                expected = BasicValue.LONG_VALUE;
                break;
            }
            case 119: 
            case 142: 
            case 143: 
            case 144: 
            case 175: {
                expected = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 180: {
                expected = this.newValue(Type.getObjectType((String)((FieldInsnNode)insn).owner));
                break;
            }
            case 190: {
                if (!this.isArrayValue(value)) {
                    throw new AnalyzerException(insn, null, "an array reference", value);
                }
                return super.unaryOperation(insn, value);
            }
            case 176: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                if (!value.isReference()) {
                    throw new AnalyzerException(insn, null, "an object reference", value);
                }
                return super.unaryOperation(insn, value);
            }
            case 179: {
                expected = this.newValue(Type.getType((String)((FieldInsnNode)insn).desc));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (!this.isSubTypeOf(value, expected)) {
            throw new AnalyzerException(insn, null, expected, value);
        }
        return super.unaryOperation(insn, value);
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        BasicValue expected1;
        BasicValue expected2 = switch (insn.getOpcode()) {
            case 46 -> {
                expected1 = this.newValue(Type.getType((String)"[I"));
                yield BasicValue.INT_VALUE;
            }
            case 51 -> {
                expected1 = this.isSubTypeOf(value1, this.newValue(Type.getType((String)"[Z"))) ? this.newValue(Type.getType((String)"[Z")) : this.newValue(Type.getType((String)"[B"));
                yield BasicValue.INT_VALUE;
            }
            case 52 -> {
                expected1 = this.newValue(Type.getType((String)"[C"));
                yield BasicValue.INT_VALUE;
            }
            case 53 -> {
                expected1 = this.newValue(Type.getType((String)"[S"));
                yield BasicValue.INT_VALUE;
            }
            case 47 -> {
                expected1 = this.newValue(Type.getType((String)"[J"));
                yield BasicValue.INT_VALUE;
            }
            case 48 -> {
                expected1 = this.newValue(Type.getType((String)"[F"));
                yield BasicValue.INT_VALUE;
            }
            case 49 -> {
                expected1 = this.newValue(Type.getType((String)"[D"));
                yield BasicValue.INT_VALUE;
            }
            case 50 -> {
                expected1 = this.newValue(Type.getType((String)"[Ljava/lang/Object;"));
                yield BasicValue.INT_VALUE;
            }
            case 96, 100, 104, 108, 112, 120, 122, 124, 126, 128, 130, 159, 160, 161, 162, 163, 164 -> {
                expected1 = BasicValue.INT_VALUE;
                yield BasicValue.INT_VALUE;
            }
            case 98, 102, 106, 110, 114, 149, 150 -> {
                expected1 = BasicValue.FLOAT_VALUE;
                yield BasicValue.FLOAT_VALUE;
            }
            case 97, 101, 105, 109, 113, 127, 129, 131, 148 -> {
                expected1 = BasicValue.LONG_VALUE;
                yield BasicValue.LONG_VALUE;
            }
            case 121, 123, 125 -> {
                expected1 = BasicValue.LONG_VALUE;
                yield BasicValue.INT_VALUE;
            }
            case 99, 103, 107, 111, 115, 151, 152 -> {
                expected1 = BasicValue.DOUBLE_VALUE;
                yield BasicValue.DOUBLE_VALUE;
            }
            case 165, 166 -> {
                expected1 = BasicValue.REFERENCE_VALUE;
                yield BasicValue.REFERENCE_VALUE;
            }
            case 181 -> {
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                expected1 = this.newValue(Type.getObjectType((String)fieldInsn.owner));
                yield this.newValue(Type.getType((String)fieldInsn.desc));
            }
            default -> throw new AssertionError();
        };
        if (!this.isSubTypeOf(value1, expected1)) {
            throw new AnalyzerException(insn, "First argument", expected1, value1);
        }
        if (!this.isSubTypeOf(value2, expected2)) {
            throw new AnalyzerException(insn, "Second argument", expected2, value2);
        }
        if (insn.getOpcode() == 50) {
            return this.getElementValue(value1);
        }
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) throws AnalyzerException {
        BasicValue expected1;
        BasicValue expected3 = switch (insn.getOpcode()) {
            case 79 -> {
                expected1 = this.newValue(Type.getType((String)"[I"));
                yield BasicValue.INT_VALUE;
            }
            case 84 -> {
                expected1 = this.isSubTypeOf(value1, this.newValue(Type.getType((String)"[Z"))) ? this.newValue(Type.getType((String)"[Z")) : this.newValue(Type.getType((String)"[B"));
                yield BasicValue.INT_VALUE;
            }
            case 85 -> {
                expected1 = this.newValue(Type.getType((String)"[C"));
                yield BasicValue.INT_VALUE;
            }
            case 86 -> {
                expected1 = this.newValue(Type.getType((String)"[S"));
                yield BasicValue.INT_VALUE;
            }
            case 80 -> {
                expected1 = this.newValue(Type.getType((String)"[J"));
                yield BasicValue.LONG_VALUE;
            }
            case 81 -> {
                expected1 = this.newValue(Type.getType((String)"[F"));
                yield BasicValue.FLOAT_VALUE;
            }
            case 82 -> {
                expected1 = this.newValue(Type.getType((String)"[D"));
                yield BasicValue.DOUBLE_VALUE;
            }
            case 83 -> {
                expected1 = value1;
                yield BasicValue.REFERENCE_VALUE;
            }
            default -> throw new AssertionError();
        };
        if (!this.isSubTypeOf(value1, expected1)) {
            throw new AnalyzerException(insn, "First argument", "a " + expected1 + " array reference", value1);
        }
        if (!BasicValue.INT_VALUE.equals(value2)) {
            throw new AnalyzerException(insn, "Second argument", BasicValue.INT_VALUE, value2);
        }
        if (!this.isSubTypeOf(value3, expected3)) {
            throw new AnalyzerException(insn, "Third argument", expected3, value3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            for (BasicValue basicValue : values) {
                if (BasicValue.INT_VALUE.equals(basicValue)) continue;
                throw new AnalyzerException(insn, null, BasicValue.INT_VALUE, basicValue);
            }
        } else {
            void var4_9;
            int n = 0;
            int j = 0;
            if (opcode != 184 && opcode != 186) {
                void var4_8;
                Type owner = Type.getObjectType((String)((MethodInsnNode)insn).owner);
                ++var4_8;
                if (!this.isSubTypeOf(values.get(n), this.newValue(owner))) {
                    throw new AnalyzerException(insn, "Method owner", this.newValue(owner), values.get(0));
                }
            }
            String methodDescriptor = opcode == 186 ? ((InvokeDynamicInsnNode)insn).desc : ((MethodInsnNode)insn).desc;
            Type[] args = Type.getArgumentTypes((String)methodDescriptor);
            while (var4_9 < values.size()) {
                BasicValue actual;
                BasicValue expected = this.newValue(args[j++]);
                if (this.isSubTypeOf(actual = values.get((int)(++var4_9)), expected)) continue;
                throw new AnalyzerException(insn, "Argument " + j, expected, actual);
            }
        }
        return super.naryOperation(insn, (List)values);
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, BasicValue value, BasicValue expected) throws AnalyzerException {
        if (!this.isSubTypeOf(value, expected)) {
            throw new AnalyzerException(insn, "Incompatible return type", expected, value);
        }
    }

    protected boolean isArrayValue(BasicValue value) {
        return value.isReference();
    }

    protected BasicValue getElementValue(BasicValue objectArrayValue) throws AnalyzerException {
        return BasicValue.REFERENCE_VALUE;
    }

    protected boolean isSubTypeOf(BasicValue value, BasicValue expected) {
        return value.equals(expected);
    }
}

