/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.usb4java.BufferUtils;

public final class ControlSetup {
    private final ByteBuffer controlSetup;

    ControlSetup(ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        this.controlSetup = BufferUtils.slice(buffer, 0, 8);
        this.controlSetup.order(ByteOrder.LITTLE_ENDIAN);
    }

    public byte bmRequestType() {
        return this.controlSetup.get(0);
    }

    public void setBmRequestType(byte bmRequestType) {
        this.controlSetup.put(0, bmRequestType);
    }

    public byte bRequest() {
        return this.controlSetup.get(1);
    }

    public void setBRequest(byte bRequest) {
        this.controlSetup.put(1, bRequest);
    }

    public short wValue() {
        return this.controlSetup.getShort(2);
    }

    public void setWValue(short wValue) {
        this.controlSetup.putShort(2, wValue);
    }

    public short wIndex() {
        return this.controlSetup.getShort(4);
    }

    public void setWIndex(short wIndex) {
        this.controlSetup.putShort(4, wIndex);
    }

    public short wLength() {
        return this.controlSetup.getShort(6);
    }

    public void setWLength(short wLength) {
        this.controlSetup.putShort(6, wLength);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.controlSetup == null ? 0 : this.controlSetup.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ControlSetup other = (ControlSetup)obj;
        return !(this.controlSetup == null ? other.controlSetup != null : !this.controlSetup.equals(other.controlSetup));
    }

    public String toString() {
        return String.format("libusb control setup with buffer %s", this.controlSetup.toString());
    }
}

