/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.usb4java.LoaderException;

public final class Loader {
    private static final int BUFFER_SIZE = 8192;
    private static File tmp;
    private static boolean loaded;

    static {
        loaded = false;
    }

    private Loader() {
    }

    private static String getOS() {
        String os = System.getProperty("os.name").toLowerCase().replace(" ", "");
        if (os.contains("windows")) {
            return "win32";
        }
        if (os.equals("macosx") || os.equals("macos")) {
            return "darwin";
        }
        return os;
    }

    private static String getArch() {
        String arch = System.getProperty("os.arch").toLowerCase().replace(" ", "");
        if (arch.equals("i386")) {
            return "x86";
        }
        if (arch.equals("amd64") || arch.equals("x86_64")) {
            return "x86-64";
        }
        if (arch.equals("arm64")) {
            return "aarch64";
        }
        if (arch.equals("armhf") || arch.equals("aarch32") || arch.equals("armv7l")) {
            return "arm";
        }
        return arch;
    }

    private static String getExt() {
        String os = Loader.getOS();
        String key = "usb4java.libext." + Loader.getOS();
        String ext = System.getProperty(key);
        if (ext != null) {
            return ext;
        }
        if (os.equals("linux") || os.equals("freebsd") || os.equals("sunos")) {
            return "so";
        }
        if (os.equals("win32")) {
            return "dll";
        }
        if (os.equals("darwin")) {
            return "dylib";
        }
        throw new LoaderException("Unable to determine the shared library file extension for operating system '" + os + "'. Please specify Java parameter -D" + key + "=<FILE-EXTENSION>");
    }

    private static File createTempDirectory() {
        if (tmp != null) {
            return tmp;
        }
        try {
            tmp = File.createTempFile("usb4java", null);
            if (!tmp.delete()) {
                throw new IOException("Unable to delete temporary file " + tmp);
            }
            if (!tmp.mkdirs()) {
                throw new IOException("Unable to create temporary directory " + tmp);
            }
            tmp.deleteOnExit();
            return tmp;
        }
        catch (IOException e) {
            throw new LoaderException("Unable to create temporary directory for usb4java natives: " + e, e);
        }
    }

    private static String getPlatform() {
        return String.valueOf(Loader.getOS()) + "-" + Loader.getArch();
    }

    private static String getLibName() {
        return "libusb4java." + Loader.getExt();
    }

    private static String getExtraLibName() {
        return null;
    }

    private static void copy(InputStream input, File output) throws IOException {
        byte[] buffer = new byte[8192];
        try (FileOutputStream stream = new FileOutputStream(output);){
            int read;
            while ((read = input.read(buffer)) != -1) {
                stream.write(buffer, 0, read);
            }
        }
    }

    private static String extractLibrary(String platform, String lib) {
        String source = String.valueOf('/') + Loader.class.getPackage().getName().replace('.', '/') + '/' + platform + "/" + lib;
        URL url = Loader.class.getResource(source);
        if (url == null) {
            throw new LoaderException("Native library not found in classpath: " + source);
        }
        if ("file".equals(url.getProtocol())) {
            try {
                return new File(url.toURI()).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                throw new LoaderException(e.toString(), e);
            }
        }
        File dest = new File(Loader.createTempDirectory(), lib);
        try {
            InputStream stream = Loader.class.getResourceAsStream(source);
            if (stream == null) {
                throw new LoaderException("Unable to find " + source + " in the classpath");
            }
            try {
                Loader.copy(stream, dest);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new LoaderException("Unable to extract native library " + source + " to " + dest + ": " + e, e);
        }
        dest.deleteOnExit();
        return dest.getAbsolutePath();
    }

    public static synchronized void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        String platform = Loader.getPlatform();
        String lib = Loader.getLibName();
        String extraLib = Loader.getExtraLibName();
        if (extraLib != null) {
            System.load(Loader.extractLibrary(platform, extraLib));
        }
        System.load(Loader.extractLibrary(platform, lib));
    }
}

