/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.baos.BaosLink;
import tuwien.auto.calimero.baos.BaosLinkAdapter;
import tuwien.auto.calimero.baos.BaosService;
import tuwien.auto.calimero.baos.ip.BaosLinkIp;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.LinkEvent;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.tools.DeviceInfo;
import tuwien.auto.calimero.tools.Main;

public class BaosClient
implements Runnable {
    private static final String tool = MethodHandles.lookup().lookupClass().getSimpleName();
    private static final Logger out = LogService.getLogger((String)("calimero.tools." + tool));
    private static final Duration defaultTimeout = Duration.ofSeconds(2L);
    private final Map<String, Object> options = new HashMap<String, Object>();
    private BaosLink link;
    private final BlockingQueue<BaosService> rcvQueue = new LinkedBlockingQueue<BaosService>();
    private final Map<Integer, DPT> dpIdToDpt = new ConcurrentHashMap<Integer, DPT>();
    private volatile boolean closed;
    private static final DateTimeFormatter isoVariants = DateTimeFormatter.ofPattern("[yyyyMMdd][yyyy-MM-dd]['T'[HHmmss][HH:mm:ss][HHmm][HH:mm]][z][XXXXX][XXXX]['['VV']']");

    public BaosClient(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            BaosClient baos = new BaosClient(args);
            Main.ShutdownHandler sh = new Main.ShutdownHandler().register();
            baos.run();
            sh.unregister();
        }
        catch (Throwable t) {
            out.error("tool options", t);
        }
    }

    @Override
    public void run() {
        block10: {
            Throwable thrown = null;
            boolean canceled = false;
            try {
                this.start();
                if (this.options.containsKey("about")) {
                    return;
                }
                try {
                    if (this.options.containsKey("repl")) {
                        this.runRepl();
                        break block10;
                    }
                    this.issueBaosService();
                }
                catch (IOException | RuntimeException | KNXException e) {
                    thrown = e;
                }
                catch (InterruptedException interruptedException) {
                    canceled = true;
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                this.quit();
                this.onCompletion((Exception)thrown, canceled);
            }
        }
    }

    public void start() throws KNXException, InterruptedException {
        if (this.options.containsKey("about")) {
            ((Runnable)this.options.get("about")).run();
            return;
        }
        this.link = this.newBaosLink();
        this.link.addLinkListener(new NetworkLinkListener(){

            @LinkEvent
            void baosService(BaosService svc) {
                BaosClient.this.rcvQueue.offer(svc);
                BaosClient.this.onBaosEvent(svc);
            }

            public void linkClosed(CloseEvent e) {
                BaosClient.this.quit();
                BaosClient.this.onCompletion(null, e.getInitiator() != 0);
            }
        });
    }

    public void quit() {
        this.closed = true;
        BaosLink lnk = this.link;
        if (lnk != null) {
            lnk.close();
        }
    }

    public static String manufacturer(int mf) {
        return DeviceInfo.manufacturer(mf);
    }

    protected void executeBaosCommand(String cmd) throws KNXException, InterruptedException {
        this.issueBaosService(cmd.split(" +"));
    }

    protected void onBaosEvent(BaosService svc) {
        BaosClient.out(LocalTime.now().truncatedTo(ChronoUnit.MILLIS) + " " + svc);
        if (svc.error() != BaosService.ErrorCode.NoError) {
            return;
        }
        int subService = svc.subService();
        if (subService == 5 || subService == 193 || subService == 10 || subService == 9) {
            try {
                for (BaosService.Item item : svc.items()) {
                    if (subService == 10) {
                        Object instant = item.info();
                        String value = this.translate(item.id(), item.data());
                        BaosClient.out(instant + " DP #" + item.id() + " = " + value);
                        continue;
                    }
                    if (subService == 9) {
                        String state = BaosClient.datapointHistoryState((Integer)item.info());
                        int entries = ByteBuffer.wrap(item.data()).getInt() & 0xFFFFFFFF;
                        BaosClient.out("DP #" + item.id() + " history " + state + ", " + entries + " entries");
                        continue;
                    }
                    String value = this.translate(item.id(), item.data());
                    BaosClient.out("DP #" + item.id() + " (" + item.info() + ") = " + value);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            out.info("BAOS communication was stopped");
        }
        if (thrown != null) {
            out.error("completed with error", (Throwable)thrown);
        }
    }

    private BaosLink newBaosLink() throws KNXException, InterruptedException {
        boolean ft12 = this.options.containsKey("ft12");
        boolean usb = this.options.containsKey("usb");
        if (ft12 || usb) {
            return BaosLinkAdapter.asBaosLink((KNXNetworkLink)Main.newLink(this.options));
        }
        InetSocketAddress local = Main.createLocalSocket(this.options);
        InetAddress addr = Main.parseHost((String)this.options.get("host"));
        int port = (Integer)this.options.get("port");
        InetSocketAddress remote = new InetSocketAddress(addr, port);
        if (this.options.containsKey("udp")) {
            return BaosLinkIp.newUdpLink((InetSocketAddress)local, (InetSocketAddress)remote);
        }
        TcpConnection connection = Main.tcpConnection(local, remote);
        return BaosLinkIp.newTcpLink((TcpConnection)connection);
    }

    private String translate(int dpId, byte[] data) throws InterruptedException {
        try {
            DPTXlator xlator = this.translatorFor(dpId);
            xlator.setData(data);
            return xlator.getValue();
        }
        catch (KNXException kNXException) {
            return DataUnitBuilder.toHex((byte[])data, (String)" ");
        }
    }

    private DPTXlator translatorFor(int dpId) throws KNXException, InterruptedException {
        DPT dpt = this.dpIdToDpt.get(dpId);
        if (dpt != null) {
            return TranslatorTypes.createTranslator((DPT)dpt, (byte[])new byte[0]);
        }
        BaosService desc = this.datapointDescription(dpId);
        if (desc.items().isEmpty()) {
            throw new KNXFormatException("no datapoint description for DP #" + dpId);
        }
        byte[] data = ((BaosService.Item)desc.items().get(0)).data();
        int mainNumber = data[2] & 0xFF;
        DPTXlator xlator = TranslatorTypes.createTranslator((int)mainNumber, (int)0, (byte[])new byte[0]);
        this.dpIdToDpt.put(dpId, xlator.getType());
        return xlator;
    }

    private BaosService datapointDescription(int dpId) throws KNXException, InterruptedException {
        BaosService desc = BaosService.getDatapointDescription((int)dpId, (int)1);
        this.link.send(desc);
        return this.waitForResponse(desc.subService());
    }

    private BaosService waitForResponse(int subService) throws InterruptedException {
        long start = System.nanoTime();
        long end = start + ((Duration)this.options.get("timeout")).toNanos();
        long remaining = end - start;
        while (remaining > 0L) {
            BaosService svc = this.rcvQueue.poll(remaining, TimeUnit.NANOSECONDS);
            if (svc != null && svc.subService() == subService) {
                return svc;
            }
            remaining = end - System.nanoTime();
        }
        return null;
    }

    private BaosService parse(String[] args) throws KNXException, InterruptedException {
        if (args.length < 2) {
            throw new KNXIllegalArgumentException("command too short: " + List.of(args));
        }
        switch (args[0]) {
            case "get": {
                return BaosClient.get(args);
            }
            case "set": {
                return this.set(args);
            }
        }
        throw new KNXIllegalArgumentException("unknown command " + args[0]);
    }

    private static BaosService get(String[] args) {
        String svc = args[1];
        int id = BaosClient.unsigned(args[2]);
        int items = args.length > 3 ? BaosClient.unsigned(args[3]) : 1;
        switch (svc) {
            case "property": {
                return BaosService.getServerItem((BaosService.Property)BaosService.Property.of((int)id), (int)items);
            }
            case "value": {
                BaosService.ValueFilter filter = args.length > 4 ? BaosClient.valueFilter(args[4]) : BaosService.ValueFilter.All;
                return BaosService.getDatapointValue((int)id, (int)items, (BaosService.ValueFilter)filter);
            }
            case "timer": {
                return BaosService.getTimer((int)id, (int)items);
            }
            case "description": 
            case "desc": {
                return BaosService.getDatapointDescription((int)id, (int)items);
            }
            case "history": {
                Instant start = Instant.EPOCH;
                Instant end = Instant.now();
                return BaosService.getDatapointHistory((int)id, (int)items, (Instant)start, (Instant)end);
            }
            case "hs": {
                return BaosService.getDatapointHistoryState((int)id, (int)items);
            }
        }
        throw new KNXIllegalArgumentException("unsupported BAOS service '" + svc + "'");
    }

    private BaosService set(String[] args) throws KNXException, InterruptedException {
        String svc = args[1];
        int id = BaosClient.unsigned(args[2]);
        switch (svc) {
            case "property": {
                return BaosService.setServerItem((BaosService.Item[])new BaosService.Item[]{BaosService.Item.property((BaosService.Property)BaosService.Property.of((int)id), (byte[])DataUnitBuilder.fromHex((String)args[3]))});
            }
            case "value": {
                return BaosService.setDatapointValue((BaosService.Item[])new BaosService.Item[]{this.parseDatapointValue(id, Arrays.copyOfRange(args, 3, args.length))});
            }
            case "timer": {
                return this.setTimer(id, args);
            }
            case "history": {
                String cmd = String.valueOf(args[4]) + (args.length > 5 ? args[5] : "");
                return BaosService.setDatapointHistoryCommand((int)id, (int)BaosClient.unsigned(args[3]), (BaosService.HistoryCommand)BaosService.HistoryCommand.of((String)cmd));
            }
        }
        throw new KNXIllegalArgumentException("unsupported BAOS service '" + svc + "'");
    }

    private static BaosService.ValueFilter valueFilter(String arg) {
        switch (arg) {
            case "all": {
                return BaosService.ValueFilter.All;
            }
            case "valid": {
                return BaosService.ValueFilter.ValidOnly;
            }
            case "updated": {
                return BaosService.ValueFilter.UpdatedOnly;
            }
        }
        throw new KNXIllegalArgumentException("unknown value filter " + arg);
    }

    private BaosService.Item<BaosService.DatapointCommand> parseDatapointValue(int dpId, String[] args) throws KNXException, InterruptedException {
        BaosService.DatapointCommand cmd = BaosService.DatapointCommand.of((int)BaosClient.unsigned(args[0]));
        switch (cmd) {
            case NoCommand: 
            case SendValueOnBus: 
            case ReadValueViaBus: 
            case ClearTransmissionState: {
                return BaosService.Item.datapoint((int)dpId, (BaosService.DatapointCommand)cmd, (byte[])new byte[0]);
            }
            case SetValue: 
            case SetValueAndSendOnBus: {
                DPTXlator xlator;
                if (BaosClient.isDpt(args[1])) {
                    String dptId = BaosClient.fromDptName(args[1]);
                    xlator = TranslatorTypes.createTranslator((String)dptId, (byte[])new byte[0]);
                    this.dpIdToDpt.put(dpId, xlator.getType());
                    xlator.setValue(args[2]);
                } else {
                    xlator = this.translatorFor(dpId);
                    xlator.setValue(args[1]);
                }
                return BaosService.Item.datapoint((int)dpId, (BaosService.DatapointCommand)cmd, (byte[])xlator.getData());
            }
        }
        throw new IllegalStateException(cmd.toString());
    }

    private BaosService setTimer(int id, String[] args) throws KNXException, InterruptedException {
        String action;
        switch (action = args[3]) {
            case "delete": {
                return BaosService.setTimer((BaosService.Timer[])new BaosService.Timer[]{BaosService.Timer.delete((int)id)});
            }
            case "oneshot": {
                ZonedDateTime dateTime = BaosClient.parseDateTime(args[4]);
                int dpId = BaosClient.unsigned(args[5]);
                BaosService.Item<BaosService.DatapointCommand> valueItem = this.parseDatapointValue(dpId, Arrays.copyOfRange(args, 6, args.length));
                byte[] job = BaosClient.timerJobSetValue(valueItem);
                return BaosService.setTimer((BaosService.Timer[])new BaosService.Timer[]{BaosService.Timer.oneShot((int)id, (ZonedDateTime)dateTime, (byte[])job, (String)"")});
            }
            case "interval": {
                ZonedDateTime start = BaosClient.parseDateTime(args[4]);
                ZonedDateTime end = BaosClient.parseDateTime(args[5]);
                Duration interval = Duration.parse(args[6]);
                int dpId = BaosClient.unsigned(args[7]);
                BaosService.Item<BaosService.DatapointCommand> valueItem = this.parseDatapointValue(dpId, Arrays.copyOfRange(args, 8, args.length));
                byte[] job = BaosClient.timerJobSetValue(valueItem);
                return BaosService.setTimer((BaosService.Timer[])new BaosService.Timer[]{BaosService.Timer.interval((int)id, (ZonedDateTime)start, (ZonedDateTime)end, (Duration)interval, (byte[])job, (String)"")});
            }
        }
        throw new KNXIllegalArgumentException("unsupported timer action '" + action + "'");
    }

    private static byte[] timerJobSetValue(BaosService.Item<BaosService.DatapointCommand> value) {
        byte[] data = value.data();
        return ByteBuffer.allocate(4 + data.length).putShort((short)value.id()).put((byte)((BaosService.DatapointCommand)value.info()).ordinal()).put((byte)data.length).put(data).array();
    }

    private static String datapointHistoryState(int state) {
        switch (state) {
            case 0: {
                return "inactive";
            }
            case 1: {
                return "available";
            }
            case 2: {
                return "active";
            }
            case 3: {
                return "active available";
            }
        }
        return String.valueOf(state) + " (unknown)";
    }

    private static String fromDptName(String id) {
        if ("switch".equals(id)) {
            return "1.001";
        }
        if ("bool".equals(id)) {
            return "1.002";
        }
        if ("dimmer".equals(id)) {
            return "3.007";
        }
        if ("blinds".equals(id)) {
            return "3.008";
        }
        if ("string".equals(id)) {
            return "16.001";
        }
        if ("temp".equals(id)) {
            return "9.001";
        }
        if ("float".equals(id)) {
            return "9.002";
        }
        if ("float2".equals(id)) {
            return "9.002";
        }
        if ("float4".equals(id)) {
            return "14.005";
        }
        if ("ucount".equals(id)) {
            return "5.010";
        }
        if ("int".equals(id)) {
            return "13.001";
        }
        if ("angle".equals(id)) {
            return "5.003";
        }
        if ("percent".equals(id)) {
            return "5.001";
        }
        if ("%".equals(id)) {
            return "5.001";
        }
        if (!"-".equals(id) && !Character.isDigit(id.charAt(0))) {
            throw new KnxRuntimeException("unrecognized DPT '" + id + "'");
        }
        return id;
    }

    private void issueBaosService() throws KNXException, InterruptedException {
        if (!this.options.containsKey("cmd")) {
            return;
        }
        this.issueBaosService((String[])this.options.get("cmd"));
    }

    private void issueBaosService(String[] args) throws KNXException, InterruptedException {
        BaosService svc = this.parse(args);
        BaosClient.out(svc);
        this.link.send(svc);
        this.waitForResponse(svc.subService());
    }

    private void runRepl() throws IOException, KNXException, InterruptedException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        while (true) {
            if (!in.ready() && !this.closed) {
                Thread.sleep(250L);
                continue;
            }
            if (this.closed) break;
            String line = in.readLine();
            if (line == null) continue;
            String[] s = line.trim().split(" +");
            if (s.length == 1 && "exit".equalsIgnoreCase(s[0])) {
                return;
            }
            if (s.length == 1 && ("?".equals(s[0]) || "help".equals(s[0]))) {
                BaosClient.out(BaosClient.listCommandsAndDptAliases(new StringJoiner(System.lineSeparator()), false));
            }
            if (s.length == 1 && "properties".equals(s[0])) {
                BaosClient.out(BaosClient.listSupportedProperties());
            }
            if (s.length == 1 && "commands".equals(s[0])) {
                BaosClient.out(BaosClient.listSupportedDpCommands());
            }
            if (s.length <= 1) continue;
            String cmd = s[0];
            boolean get = cmd.equals("get");
            boolean set = cmd.equals("set");
            try {
                if (get || set) {
                    this.issueBaosService(s);
                    continue;
                }
                BaosClient.out("unknown command '" + cmd + "'");
            }
            catch (KNXTimeoutException e) {
                BaosClient.out(e.getMessage());
            }
            catch (RuntimeException | KNXException e) {
                out.error("[{}]", (Object)line, (Object)e);
            }
        }
    }

    private void parseOptions(String[] args) {
        if (args.length == 0) {
            this.options.put("about", BaosClient::showToolInfo);
            return;
        }
        this.options.put("port", 12004);
        this.options.put("medium", new TPSettings());
        this.options.put("timeout", defaultTimeout);
        Main.PeekingIterator<String> i = new Main.PeekingIterator<String>(List.of(args).iterator());
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", BaosClient::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (arg.equals("get")) {
                if (!i.hasNext()) break;
                this.options.put("cmd", this.remainingOptions(arg, i));
                continue;
            }
            if (arg.equals("set")) {
                if (!i.hasNext()) break;
                this.options.put("cmd", this.remainingOptions(arg, i));
                continue;
            }
            if (Main.isOption(arg, "timeout", "t")) {
                this.options.put("timeout", Duration.ofSeconds(Integer.decode(i.next()).intValue()));
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (this.options.containsKey("usb") && !this.options.containsKey("host")) {
            this.options.put("host", "");
        }
        if (!this.options.containsKey("host") || this.options.containsKey("ft12") && this.options.containsKey("usb")) {
            throw new KNXIllegalArgumentException("specify either IP host, serial port, or device");
        }
        if (!this.options.containsKey("cmd")) {
            this.options.put("repl", null);
        }
    }

    private String[] remainingOptions(String arg, Iterator<String> i) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(arg);
        i.forEachRemaining(list::add);
        return (String[])list.toArray(String[]::new);
    }

    static ZonedDateTime parseDateTime(CharSequence dateTime) {
        TemporalAccessor temporalAccessor = isoVariants.parseBest(dateTime, ZonedDateTime::from, LocalDateTime::from, LocalDate::from);
        if (temporalAccessor instanceof ZonedDateTime) {
            return (ZonedDateTime)temporalAccessor;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault());
        }
        return ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault());
    }

    private static boolean isDpt(String s) {
        if (s.startsWith("-")) {
            return false;
        }
        String id = BaosClient.fromDptName(s);
        return Pattern.matches("[0-9][0-9]*\\.[0-9][0-9][0-9]", id);
    }

    private static void showToolInfo() {
        BaosClient.out(String.valueOf(tool) + " - KNX BAOS communication");
        Main.showVersion();
        BaosClient.out("Type --help for help message");
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        joiner.add("Usage: " + tool + " [options] <host|port> <command>");
        Main.printCommonOptions(joiner);
        BaosClient.listCommandsAndDptAliases(joiner, true);
        BaosClient.out(joiner);
    }

    private static StringJoiner listCommandsAndDptAliases(StringJoiner joiner, boolean showMonitor) {
        joiner.add("Supported BAOS commands:");
        joiner.add("  get {property|value|timer|history|description}  get a property, value, timer, history, or description");
        joiner.add("  set {property|value|timer|history}              set a property, value, timer, or history");
        joiner.add("");
        joiner.add("get property <id> [<items>]");
        joiner.add("set property <id> <hex value>");
        joiner.add("get description <id> [<items>]");
        joiner.add("get value <id> [<items> [all|valid|updated]]");
        joiner.add("set value <id> <cmd> [value]");
        joiner.add("get history <id> [items]");
        joiner.add("set history <id> <items> <clear [start] | start | stop [clear]>");
        joiner.add("get timer <id> [<items>]");
        joiner.add("set timer <id> delete");
        joiner.add("set timer <id> oneshot <date/time> <dpId> <cmd> [<value>]");
        joiner.add("set timer <id> interval <start date/time> <end date/time> ... <dpId> [<value>]");
        return joiner;
    }

    private static StringJoiner listSupportedProperties() {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        BaosService.Property[] propertyArray = BaosService.Property.values();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            BaosService.Property property = propertyArray[n2];
            if (property.id() != 0) {
                joiner.add(String.format("%2d = %s", property.id(), property));
            }
            ++n2;
        }
        return joiner;
    }

    private static StringJoiner listSupportedDpCommands() {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        BaosService.DatapointCommand[] datapointCommandArray = BaosService.DatapointCommand.values();
        int n = datapointCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            BaosService.DatapointCommand cmd = datapointCommandArray[n2];
            joiner.add(String.format("%2d = %s", cmd.ordinal(), cmd));
            ++n2;
        }
        return joiner;
    }

    private static void out(Object s) {
        System.out.println(s);
    }

    private static int unsigned(String s) {
        return Integer.parseUnsignedInt(s);
    }
}

