/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.StringJoiner;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.datapoint.DatapointMap;
import tuwien.auto.calimero.datapoint.StateDP;
import tuwien.auto.calimero.tools.KnxProject;
import tuwien.auto.calimero.tools.Main;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlInputFactory;
import tuwien.auto.calimero.xml.XmlOutputFactory;
import tuwien.auto.calimero.xml.XmlReader;
import tuwien.auto.calimero.xml.XmlWriter;

public class DatapointImporter
implements Runnable {
    private final DatapointMap<StateDP> datapoints = new DatapointMap();
    private final String input;
    private final String output;
    private boolean freeStyle;
    private char[] projectPwd = new char[0];

    public static void main(String ... args) {
        if (args.length == 0) {
            DatapointImporter.showToolInfo();
            return;
        }
        String arg = args[0];
        if ("-h".equals(arg) || "--help".equals(arg)) {
            DatapointImporter.showUsage();
        } else if ("--version".equals(arg)) {
            Main.showVersion();
        } else {
            new DatapointImporter(args).run();
        }
    }

    public DatapointImporter(String ... args) {
        int i = 0;
        while (args[i].startsWith("--")) {
            if ("--freestyle".equals(args[i])) {
                this.freeStyle = true;
                ++i;
                continue;
            }
            if (!"--pwd".equals(args[i])) break;
            this.projectPwd = args[i + 1].toCharArray();
            i += 2;
        }
        this.input = args[i++];
        this.output = args.length > i ? args[i++] : null;
    }

    @Override
    public void run() {
        String ext = this.input.substring(this.input.lastIndexOf(46) + 1);
        if (ext.equalsIgnoreCase("xml")) {
            this.importAddressesFromXml(this.input);
        } else if (ext.equals("knxproj")) {
            KnxProject project = KnxProject.from(Path.of(this.input, new String[0]));
            if (project.encrypted()) {
                if (this.projectPwd.length == 0) {
                    System.err.println("project file is encrypted, password required!");
                    return;
                }
                project.decrypt(this.projectPwd);
            }
            try {
                project.datapoints().getDatapoints().forEach(arg_0 -> this.datapoints.add(arg_0));
            }
            catch (KNXFormatException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.importAddressesFromCsv(this.input);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.datapoints.getDatapoints().isEmpty()) {
            DatapointImporter.out("no datapoints found");
            return;
        }
        if (this.freeStyle) {
            GroupAddress.addressStyle((GroupAddress.Presentation)GroupAddress.Presentation.FreeStyle);
        }
        Throwable throwable = null;
        Object var3_6 = null;
        try (XmlWriter writer = this.createXmlWriter();){
            this.datapoints.save(writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private XmlWriter createXmlWriter() {
        XmlOutputFactory fac = XmlOutputFactory.newInstance();
        return this.output != null ? fac.createXMLWriter(this.output) : fac.createXMLStreamWriter((OutputStream)System.out);
    }

    private void importAddressesFromCsv(String file) throws IOException {
        Files.lines(Path.of(file, new String[0]), StandardCharsets.UTF_8).map(line -> line.split("\"[\t;]\"")).map(DatapointImporter::parseDatapoint).flatMap(Optional::stream).forEach(arg_0 -> this.datapoints.add(arg_0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importAddressesFromXml(String uri) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XmlReader reader = XmlInputFactory.newInstance().createXMLReader(uri);){
            if (reader.getEventType() != 1) {
                reader.nextTag();
            }
            if (reader.getEventType() != 1) throw new KNXMLException("GroupAddress-Export element not found", reader);
            if (!reader.getLocalName().equals("GroupAddress-Export")) {
                throw new KNXMLException("GroupAddress-Export element not found", reader);
            }
            while (true) {
                if (reader.next() == 8) {
                    return;
                }
                if (reader.getEventType() != 1 || !reader.getLocalName().equals("GroupAddress")) continue;
                DatapointImporter.parseDatapoint(reader).ifPresent(arg_0 -> this.datapoints.add(arg_0));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static Optional<StateDP> parseDatapoint(XmlReader reader) {
        String address = reader.getAttributeValue(null, "Address");
        String name = reader.getAttributeValue(null, "Name");
        String dpt = Optional.ofNullable(reader.getAttributeValue(null, "DPTs")).orElse("");
        return DatapointImporter.parseDatapoint(address, name, dpt);
    }

    private static Optional<StateDP> parseDatapoint(String[] columns) {
        return DatapointImporter.parseDatapoint(columns[1], columns[0].substring(1), columns[5]);
    }

    private static Optional<StateDP> parseDatapoint(String address, String name, String dpt) {
        try {
            GroupAddress group = new GroupAddress(address);
            Object[] types = DatapointImporter.parseDpt(dpt);
            StateDP datapoint = new StateDP(group, name, ((Integer)types[0]).intValue(), (String)types[1]);
            System.out.println("import " + datapoint);
            return Optional.of(datapoint);
        }
        catch (KNXFormatException kNXFormatException) {
            return Optional.empty();
        }
    }

    private static Object[] parseDpt(String dpt) {
        String[] mainSub = dpt.replace("DPT-", "").replace("DPST-", "").split("-", 0);
        int main = 0;
        String dptId = "";
        if (mainSub.length >= 1 && !mainSub[0].isEmpty()) {
            main = Integer.parseInt(mainSub[0]);
        }
        if (mainSub.length == 2) {
            dptId = String.format("%d.%03d", main, Integer.parseInt(mainSub[1]));
        }
        return new Object[]{main, dptId};
    }

    private static void showToolInfo() {
        String name = MethodHandles.lookup().lookupClass().getSimpleName();
        DatapointImporter.out(String.valueOf(name) + " - Import datapoints from a KNX project (.knxproj) or group addresses file (.xml|.csv)");
        Main.showVersion();
        DatapointImporter.out("Use --help for help message");
    }

    private static void showUsage() {
        String name = MethodHandles.lookup().lookupClass().getSimpleName();
        StringJoiner joiner = new StringJoiner(System.getProperty("line.separator"));
        joiner.add("Usage: " + name + " [options] <project.knxproj or group addresses file [.xml|.csv]> [<output file (xml)>]");
        joiner.add("       if no output file is specified, imported datapoints are written to the standard output");
        joiner.add("Options:");
        joiner.add("  -h --help                  show this help and exit");
        joiner.add("  --version                  show tool/library version and exit");
        joiner.add("  --pwd                      password for encrypted KNX projects");
        joiner.add("  --freestyle                use unformatted KNX address presentation in the output");
        System.out.println(joiner);
    }

    private static void out(Object o) {
        System.out.println(o);
    }
}

