/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlatorBoolean;
import tuwien.auto.calimero.dptxlator.DptXlator16BitSet;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.LocalDeviceManagementIp;
import tuwien.auto.calimero.mgmt.LocalDeviceManagementUsb;
import tuwien.auto.calimero.mgmt.ManagementClient;
import tuwien.auto.calimero.mgmt.PropertyAdapter;
import tuwien.auto.calimero.mgmt.PropertyClient;
import tuwien.auto.calimero.mgmt.RemotePropertyServiceAdapter;
import tuwien.auto.calimero.serial.usb.UsbConnection;
import tuwien.auto.calimero.tools.Main;

public class DeviceInfo
implements Runnable {
    private static final String tool = "DeviceInfo";
    private static final int addresstableObject = 1;
    private static final int assoctableObject = 2;
    private static final int appProgramObject = 3;
    private static final int interfaceProgramObject = 4;
    private static final int cemiServerObject = 8;
    private static final int knxnetipObject = 11;
    private static final int securityObject = 17;
    private static final int rfMediumObject = 19;
    private static final int pidHardwareType = 78;
    private final Map<Integer, List<Integer>> ifObjects = new HashMap<Integer, List<Integer>>();
    private static Logger out = LogService.getLogger((String)"calimero.tools");
    private ManagementClient mc;
    private Destination d;
    private PropertyClient pc;
    private final Map<String, Object> options = new HashMap<String, Object>();
    private DeviceDescriptor dd;
    private boolean isSystemB;
    private boolean groupAddressesDone;
    private final Set<String> categories = new HashSet<String>();
    private String category = "General";
    private static final int legacyPidFilteringModeSelect = 62;
    private static final int legacyPidFilteringModeSupport = 63;
    private static final int addrManufact = 260;
    private static final int addrDevType = 261;
    private static final int addrVersion = 263;
    private static final int addrPeiType = 265;
    private static final int addrRunError = 269;
    private static final int addrRoutingCnt = 270;
    private static final int addrGroupObjTablePtr = 274;
    private static final int addrGroupAddrTable = 278;
    private static final int addrGroupAddrTableMask5705 = 16384;
    private static final Map<Integer, String> manufacturer = new HashMap<Integer, String>();

    static {
        manufacturer.put(1, "Siemens");
        manufacturer.put(2, "ABB");
        manufacturer.put(4, "Albrecht Jung");
        manufacturer.put(5, "Bticino");
        manufacturer.put(6, "Berker");
        manufacturer.put(7, "Busch-Jaeger Elektro");
        manufacturer.put(8, "GIRA Giersiepen");
        manufacturer.put(9, "Hager Electro");
        manufacturer.put(10, "Insta GmbH");
        manufacturer.put(11, "LEGRAND Appareillage \u00e9lectrique");
        manufacturer.put(12, "Merten");
        manufacturer.put(14, "ABB SpA-SACE Division");
        manufacturer.put(22, "Siedle & S\u00f6hne");
        manufacturer.put(24, "Eberle");
        manufacturer.put(25, "GEWISS");
        manufacturer.put(27, "Albert Ackermann");
        manufacturer.put(28, "Schupa GmbH");
        manufacturer.put(29, "ABB SCHWEIZ");
        manufacturer.put(30, "Feller");
        manufacturer.put(31, "Glamox AS");
        manufacturer.put(32, "DEHN & S\u00d6HNE");
        manufacturer.put(33, "CRABTREE");
        manufacturer.put(34, "eVoKNX");
        manufacturer.put(36, "Paul Hochk\u00f6pper");
        manufacturer.put(37, "Altenburger Electronic");
        manufacturer.put(41, "Gr\u00e4sslin");
        manufacturer.put(42, "Simon");
        manufacturer.put(44, "VIMAR");
        manufacturer.put(45, "Moeller Geb\u00e4udeautomation KG");
        manufacturer.put(46, "Eltako");
        manufacturer.put(49, "Bosch-Siemens Haushaltsger\u00e4te");
        manufacturer.put(52, "RITTO GmbH&Co.KG");
        manufacturer.put(53, "Power Controls");
        manufacturer.put(55, "ZUMTOBEL");
        manufacturer.put(57, "Phoenix Contact");
        manufacturer.put(61, "WAGO Kontakttechnik");
        manufacturer.put(62, "knXpresso");
        manufacturer.put(66, "Wieland Electric");
        manufacturer.put(67, "Hermann Kleinhuis");
        manufacturer.put(69, "Stiebel Eltron");
        manufacturer.put(71, "Tehalit");
        manufacturer.put(72, "Theben AG");
        manufacturer.put(73, "Wilhelm Rutenbeck");
        manufacturer.put(75, "Winkhaus");
        manufacturer.put(76, "Robert Bosch");
        manufacturer.put(78, "Somfy");
        manufacturer.put(80, "Woertz");
        manufacturer.put(81, "Viessmann Werke");
        manufacturer.put(82, "IMI Hydronic Engineering");
        manufacturer.put(83, "Joh. Vaillant");
        manufacturer.put(85, "AMP Deutschland");
        manufacturer.put(89, "Bosch Thermotechnik GmbH");
        manufacturer.put(90, "SEF - ECOTEC");
        manufacturer.put(92, "DORMA GmbH + Co. KG");
        manufacturer.put(93, "WindowMaster A/S");
        manufacturer.put(94, "Walther Werke");
        manufacturer.put(95, "ORAS");
        manufacturer.put(97, "D\u00e4twyler");
        manufacturer.put(98, "Electrak");
        manufacturer.put(99, "Techem");
        manufacturer.put(100, "Schneider Electric Industries SAS");
        manufacturer.put(101, "WHD Wilhelm Huber + S\u00f6hne");
        manufacturer.put(102, "Bischoff Elektronik");
        manufacturer.put(104, "JEPAZ");
        manufacturer.put(105, "RTS Automation");
        manufacturer.put(106, "EIBMARKT GmbH");
        manufacturer.put(107, "WAREMA Renkhoff SE");
        manufacturer.put(108, "Eelectron");
        manufacturer.put(109, "Belden Wire & Cable B.V.");
        manufacturer.put(110, "Becker-Antriebe GmbH");
        manufacturer.put(111, "J.Stehle+S\u00f6hne GmbH");
        manufacturer.put(112, "AGFEO");
        manufacturer.put(113, "Zennio");
        manufacturer.put(114, "TAPKO Technologies");
        manufacturer.put(115, "HDL");
        manufacturer.put(116, "Uponor");
        manufacturer.put(117, "se Lightmanagement AG");
        manufacturer.put(118, "Arcus-eds");
        manufacturer.put(119, "Intesis");
        manufacturer.put(120, "Herholdt Controls srl");
        manufacturer.put(121, "Niko-Zublin");
        manufacturer.put(122, "Durable Technologies");
        manufacturer.put(123, "Innoteam");
        manufacturer.put(124, "ise GmbH");
        manufacturer.put(125, "TEAM FOR TRONICS");
        manufacturer.put(126, "CIAT");
        manufacturer.put(127, "Remeha BV");
        manufacturer.put(128, "ESYLUX");
        manufacturer.put(129, "BASALTE");
        manufacturer.put(130, "Vestamatic");
        manufacturer.put(131, "MDT technologies");
        manufacturer.put(132, "Warendorfer K\u00fcchen GmbH");
        manufacturer.put(133, "Video-Star");
        manufacturer.put(134, "Sitek");
        manufacturer.put(135, "CONTROLtronic");
        manufacturer.put(136, "function Technology");
        manufacturer.put(137, "AMX");
        manufacturer.put(138, "ELDAT");
        manufacturer.put(139, "Panasonic");
        manufacturer.put(140, "Pulse Technologies");
        manufacturer.put(141, "Crestron");
        manufacturer.put(142, "STEINEL professional");
        manufacturer.put(143, "BILTON LED Lighting");
        manufacturer.put(144, "denro AG");
        manufacturer.put(145, "GePro");
        manufacturer.put(146, "preussen automation");
        manufacturer.put(147, "Zoppas Industries");
        manufacturer.put(148, "MACTECH");
        manufacturer.put(149, "TECHNO-TREND");
        manufacturer.put(150, "FS Cables");
        manufacturer.put(151, "Delta Dore");
        manufacturer.put(152, "Eissound");
        manufacturer.put(153, "Cisco");
        manufacturer.put(154, "Dinuy");
        manufacturer.put(155, "iKNiX");
        manufacturer.put(156, "Rademacher Ger\u00e4te-Elektronik GmbH");
        manufacturer.put(157, "EGi Electroacustica General Iberica");
        manufacturer.put(158, "Bes \u2013 Ingenium");
        manufacturer.put(159, "ElabNET");
        manufacturer.put(160, "Blumotix");
        manufacturer.put(161, "Hunter Douglas");
        manufacturer.put(162, "APRICUM");
        manufacturer.put(163, "TIANSU Automation");
        manufacturer.put(164, "Bubendorff");
        manufacturer.put(165, "MBS GmbH");
        manufacturer.put(166, "Enertex Bayern GmbH");
        manufacturer.put(167, "BMS");
        manufacturer.put(168, "Sinapsi");
        manufacturer.put(169, "Embedded Systems SIA");
        manufacturer.put(170, "KNX1");
        manufacturer.put(171, "Tokka");
        manufacturer.put(172, "NanoSense");
        manufacturer.put(173, "PEAR Automation GmbH");
        manufacturer.put(174, "DGA");
        manufacturer.put(175, "Lutron");
        manufacturer.put(176, "AIRZONE \u2013 ALTRA");
        manufacturer.put(177, "Lithoss Design Switches");
        manufacturer.put(178, "3ATEL");
        manufacturer.put(179, "Philips Controls");
        manufacturer.put(180, "VELUX A/S");
        manufacturer.put(181, "LOYTEC");
        manufacturer.put(182, "Ekinex S.p.A.");
        manufacturer.put(183, "SIRLAN Technologies");
        manufacturer.put(184, "ProKNX SAS");
        manufacturer.put(185, "IT GmbH");
        manufacturer.put(186, "RENSON");
        manufacturer.put(187, "HEP Group");
        manufacturer.put(188, "Balmart");
        manufacturer.put(189, "GFS GmbH");
        manufacturer.put(190, "Schenker Storen AG");
        manufacturer.put(191, "Algodue Elettronica S.r.L.");
        manufacturer.put(192, "ABB France");
        manufacturer.put(193, "maintronic");
        manufacturer.put(194, "Vantage");
        manufacturer.put(195, "Foresis");
        manufacturer.put(196, "Research & Production Association SEM");
        manufacturer.put(197, "Weinzierl Engineering GmbH");
        manufacturer.put(198, "M\u00f6hlenhoff W\u00e4rmetechnik GmbH");
        manufacturer.put(199, "PKC-GROUP Oyj");
        manufacturer.put(200, "B.E.G.");
        manufacturer.put(201, "Elsner Elektronik GmbH");
        manufacturer.put(202, "Siemens Building Technologies (HK/China) Ltd.");
        manufacturer.put(204, "Eutrac");
        manufacturer.put(205, "Gustav Hensel GmbH & Co. KG");
        manufacturer.put(206, "GARO AB");
        manufacturer.put(207, "Waldmann Lichttechnik");
        manufacturer.put(208, "SCH\u00dcCO");
        manufacturer.put(209, "EMU");
        manufacturer.put(210, "JNet Systems AG");
        manufacturer.put(214, "O.Y.L. Electronics");
        manufacturer.put(215, "Galax System");
        manufacturer.put(216, "Disch");
        manufacturer.put(217, "Aucoteam");
        manufacturer.put(218, "Luxmate Controls");
        manufacturer.put(219, "Danfoss");
        manufacturer.put(220, "AST GmbH");
        manufacturer.put(222, "WILA Leuchten");
        manufacturer.put(223, "b+b Automations- und Steuerungstechnik");
        manufacturer.put(225, "Lingg & Janke");
        manufacturer.put(227, "Sauter");
        manufacturer.put(228, "SIMU");
        manufacturer.put(232, "Theben HTS AG");
        manufacturer.put(233, "Amann GmbH");
        manufacturer.put(234, "BERG Energiekontrollsysteme GmbH");
        manufacturer.put(235, "H\u00fcppe Form Sonnenschutzsysteme GmbH");
        manufacturer.put(237, "Oventrop KG");
        manufacturer.put(238, "Griesser AG");
        manufacturer.put(239, "IPAS GmbH");
        manufacturer.put(240, "elero GmbH");
        manufacturer.put(241, "Ardan Production and Industrial Controls Ltd.");
        manufacturer.put(242, "Metec Me\u00dftechnik GmbH");
        manufacturer.put(244, "ELKA-Elektronik GmbH");
        manufacturer.put(245, "ELEKTROANLAGEN D. NAGEL");
        manufacturer.put(246, "Tridonic Bauelemente GmbH");
        manufacturer.put(248, "Stengler Gesellschaft");
        manufacturer.put(249, "Schneider Electric (MG)");
        manufacturer.put(250, "KNX Association");
        manufacturer.put(251, "VIVO");
        manufacturer.put(252, "Hugo M\u00fcller GmbH & Co KG");
        manufacturer.put(253, "Siemens HVAC");
        manufacturer.put(254, "APT");
        manufacturer.put(256, "HighDom");
        manufacturer.put(257, "Top Services");
        manufacturer.put(258, "ambiHome");
        manufacturer.put(259, "DATEC electronic AG");
        manufacturer.put(260, "ABUS Security-Center");
        manufacturer.put(261, "Lite-Puter");
        manufacturer.put(262, "Tantron Electronic");
        manufacturer.put(263, "Interra");
        manufacturer.put(264, "DKX Tech");
        manufacturer.put(265, "Viatron");
        manufacturer.put(266, "Nautibus");
        manufacturer.put(267, "ON Semiconductor");
        manufacturer.put(268, "Longchuang");
        manufacturer.put(269, "Air-On AG");
        manufacturer.put(270, "ib-company GmbH");
        manufacturer.put(271, "Sation Factory");
        manufacturer.put(272, "Agentilo GmbH");
        manufacturer.put(273, "Makel Elektrik");
        manufacturer.put(274, "Helios Ventilatoren");
        manufacturer.put(275, "Otto Solutions Pte Ltd");
        manufacturer.put(276, "Airmaster");
        manufacturer.put(277, "Vallox GmbH");
        manufacturer.put(278, "Dalitek");
        manufacturer.put(279, "ASIN");
        manufacturer.put(280, "Bridges Intelligence Technology Inc.");
        manufacturer.put(281, "ARBONIA");
        manufacturer.put(282, "KERMI");
        manufacturer.put(283, "PROLUX");
        manufacturer.put(284, "ClicHome");
        manufacturer.put(285, "COMMAX");
        manufacturer.put(286, "EAE");
        manufacturer.put(287, "Tense");
        manufacturer.put(288, "Seyoung Electronics");
        manufacturer.put(289, "Lifedomus");
        manufacturer.put(290, "EUROtronic Technology GmbH");
        manufacturer.put(291, "tci");
        manufacturer.put(292, "Rishun Electronic");
        manufacturer.put(293, "Zipato");
        manufacturer.put(294, "cm-security GmbH & Co KG");
        manufacturer.put(295, "Qing Cables");
        manufacturer.put(296, "LABIO");
        manufacturer.put(297, "Coster Tecnologie Elettroniche S.p.A.");
        manufacturer.put(298, "E.G.E");
        manufacturer.put(299, "NETxAutomation");
        manufacturer.put(300, "tecalor");
        manufacturer.put(301, "Urmet Electronics (Huizhou) Ltd.");
        manufacturer.put(302, "Peiying Building Control");
        manufacturer.put(303, "BPT S.p.A. a Socio Unico");
        manufacturer.put(304, "Kanontec - KanonBUS");
        manufacturer.put(305, "ISER Tech");
        manufacturer.put(306, "Fineline");
        manufacturer.put(307, "CP Electronics Ltd");
        manufacturer.put(308, "Niko-Servodan A/S");
        manufacturer.put(309, "Simon");
        manufacturer.put(310, "GM modular pvt. Ltd.");
        manufacturer.put(311, "FU CHENG Intelligence");
        manufacturer.put(312, "NexKon");
        manufacturer.put(313, "FEEL s.r.l");
        manufacturer.put(314, "Not Assigned");
        manufacturer.put(315, "Shenzhen Fanhai Sanjiang Electronics Co., Ltd.");
        manufacturer.put(316, "Jiuzhou Greeble");
        manufacturer.put(317, "Aum\u00fcller Aumatic GmbH");
        manufacturer.put(318, "Etman Electric");
        manufacturer.put(319, "EMT Controls");
        manufacturer.put(320, "ZidaTech AG");
        manufacturer.put(321, "IDGS bvba");
        manufacturer.put(322, "dakanimo");
        manufacturer.put(323, "Trebor Automation AB");
        manufacturer.put(324, "Satel sp. z o.o.");
        manufacturer.put(325, "Russound, Inc.");
        manufacturer.put(326, "Midea Heating & Ventilating Equipment CO LTD");
        manufacturer.put(327, "Consorzio Terranuova");
        manufacturer.put(328, "Wolf Heiztechnik GmbH");
        manufacturer.put(329, "SONTEC");
        manufacturer.put(330, "Belcom Cables Ltd.");
        manufacturer.put(331, "Guangzhou SeaWin Electrical Technologies Co., Ltd.");
        manufacturer.put(332, "Acrel");
        manufacturer.put(333, "Franke Aquarotter GmbH");
        manufacturer.put(334, "Orion Systems");
        manufacturer.put(335, "Schrack Technik GmbH");
        manufacturer.put(336, "INSPRID");
        manufacturer.put(337, "Sunricher");
        manufacturer.put(338, "Menred automation system(shanghai) Co.,Ltd.");
        manufacturer.put(339, "Aurex");
        manufacturer.put(340, "Josef Barthelme GmbH & Co. KG");
        manufacturer.put(341, "Architecture Numerique");
        manufacturer.put(342, "UP GROUP");
        manufacturer.put(343, "Teknos-Avinno");
        manufacturer.put(344, "Ningbo Dooya Mechanic & Electronic Technology");
        manufacturer.put(345, "Thermokon Sensortechnik GmbH");
        manufacturer.put(346, "BELIMO Automation AG");
        manufacturer.put(347, "Zehnder Group International AG");
        manufacturer.put(348, "sks Kinkel Elektronik");
        manufacturer.put(349, "ECE Wurmitzer GmbH");
        manufacturer.put(350, "LARS");
        manufacturer.put(351, "URC");
        manufacturer.put(352, "LightControl");
        manufacturer.put(353, "ShenZhen YM");
        manufacturer.put(354, "MEAN WELL Enterprises Co. Ltd.");
        manufacturer.put(355, "OSix");
        manufacturer.put(356, "AYPRO Technology");
        manufacturer.put(357, "Hefei Ecolite Software");
        manufacturer.put(358, "Enno");
        manufacturer.put(359, "OHOSURE");
        manufacturer.put(360, "Garefowl");
        manufacturer.put(361, "GEZE");
        manufacturer.put(362, "LG Electronics Inc.");
        manufacturer.put(363, "SMC interiors");
        manufacturer.put(365, "SCS Cable");
        manufacturer.put(366, "Hoval");
        manufacturer.put(367, "CANST");
        manufacturer.put(368, "HangZhou Berlin");
        manufacturer.put(369, "EVN-Lichttechnik");
        manufacturer.put(370, "rutec");
        manufacturer.put(371, "Finder");
        manufacturer.put(372, "Fujitsu General Limited");
        manufacturer.put(373, "ZF Friedrichshafen AG");
        manufacturer.put(374, "Crealed");
        manufacturer.put(375, "Miles Magic Automation Private Limited");
        manufacturer.put(376, "E+");
        manufacturer.put(377, "Italcond");
        manufacturer.put(378, "SATION");
        manufacturer.put(379, "NewBest");
        manufacturer.put(380, "GDS DIGITAL SYSTEMS");
        manufacturer.put(381, "Iddero");
        manufacturer.put(382, "MBNLED");
        manufacturer.put(383, "VITRUM");
        manufacturer.put(384, "ekey biometric systems GmbH");
        manufacturer.put(385, "AMC");
        manufacturer.put(386, "TRILUX GmbH & Co. KG");
        manufacturer.put(387, "WExcedo");
        manufacturer.put(388, "VEMER SPA");
        manufacturer.put(389, "Alexander B\u00fcrkle GmbH & Co KG");
        manufacturer.put(390, "Seetroll");
        manufacturer.put(391, "Shenzhen HeGuang");
        manufacturer.put(392, "Not Assigned");
        manufacturer.put(393, "TRANE B.V.B.A");
        manufacturer.put(394, "CAREL");
        manufacturer.put(395, "Prolite Controls");
        manufacturer.put(396, "BOSMER");
        manufacturer.put(397, "EUCHIPS");
        manufacturer.put(398, "connect (Thinka connect)");
        manufacturer.put(399, "PEAKnx a DOGAWIST company ");
        manufacturer.put(400, "ACEMATIC");
        manufacturer.put(401, "ELAUSYS");
        manufacturer.put(402, "ITK Engineering AG");
        manufacturer.put(403, "INTEGRA METERING AG");
        manufacturer.put(404, "FMS Hospitality Pte Ltd");
        manufacturer.put(405, "Nuvo");
        manufacturer.put(406, "u::Lux GmbH");
        manufacturer.put(407, "Brumberg Leuchten");
        manufacturer.put(408, "Lime");
        manufacturer.put(409, "Great Empire International Group Co., Ltd.");
        manufacturer.put(410, "Kavoshpishro Asia");
        manufacturer.put(411, "V2 SpA");
        manufacturer.put(412, "Johnson Controls");
        manufacturer.put(413, "Arkud");
        manufacturer.put(414, "Iridium Ltd.");
        manufacturer.put(415, "bsmart");
        manufacturer.put(416, "BAB TECHNOLOGIE GmbH");
        manufacturer.put(417, "NICE Spa");
        manufacturer.put(418, "Redfish Group Pty Ltd");
        manufacturer.put(419, "SABIANA spa");
        manufacturer.put(420, "Ubee Interactive Europe");
        manufacturer.put(421, "Rexel");
        manufacturer.put(422, "Ges Teknik A.S.");
        manufacturer.put(423, "Ave S.p.A. ");
        manufacturer.put(424, "Zhuhai Ltech Technology Co., Ltd. ");
        manufacturer.put(425, "ARCOM");
        manufacturer.put(426, "VIA Technologies, Inc.");
        manufacturer.put(427, "FEELSMART.");
        manufacturer.put(428, "SUPCON");
        manufacturer.put(429, "MANIC");
        manufacturer.put(430, "TDE GmbH");
        manufacturer.put(431, "Nanjing Shufan Information technology Co.,Ltd.");
        manufacturer.put(432, "EWTech");
        manufacturer.put(433, "Kluger Automation GmbH");
        manufacturer.put(434, "JoongAng Control");
        manufacturer.put(435, "GreenControls Technology Sdn. Bhd.");
        manufacturer.put(436, "IME S.p.a.");
        manufacturer.put(437, "SiChuan HaoDing");
        manufacturer.put(438, "Mindjaga Ltd.");
        manufacturer.put(439, "RuiLi Smart Control");
        manufacturer.put(440, "3S-Smart Software Solutions GmbH");
        manufacturer.put(441, "Moorgen Deutschland GmbH");
        manufacturer.put(442, "CULLMANN TECH");
        manufacturer.put(443, "Merck Window Technologies B.V.");
        manufacturer.put(444, "ABEGO");
        manufacturer.put(445, "myGEKKO");
        manufacturer.put(446, "Ergo3 Sarl");
        manufacturer.put(447, "STmicroelectronics International N.V.");
        manufacturer.put(448, "cjc systems");
        manufacturer.put(449, "Sudoku");
        manufacturer.put(451, "AZ e-lite Pte Ltd");
        manufacturer.put(452, "Arlight");
        manufacturer.put(453, "Gr\u00fcnbeck Wasseraufbereitung GmbH");
        manufacturer.put(454, "Module Electronic");
        manufacturer.put(455, "KOPLAT");
        manufacturer.put(456, "Guangzhou Letour Life Technology Co., Ltd");
        manufacturer.put(457, "ILEVIA");
        manufacturer.put(458, "LN SYSTEMTEQ");
        manufacturer.put(459, "Hisense SmartHome");
        manufacturer.put(460, "Flink Automation System");
        manufacturer.put(461, "xxter bv");
        manufacturer.put(462, "lynxus technology");
        manufacturer.put(463, "ROBOT S.A.");
        manufacturer.put(464, "Shenzhen Atte Smart Life Co.,Ltd.");
        manufacturer.put(465, "Noblesse");
        manufacturer.put(466, "Advanced Devices");
        manufacturer.put(467, "Atrina Building Automation Co. Ltd");
        manufacturer.put(468, "Guangdong Daming Laffey electric Co., Ltd.");
        manufacturer.put(469, "Westerstrand Urfabrik AB");
        manufacturer.put(470, "Control4 Corporate");
        manufacturer.put(471, "Ontrol");
        manufacturer.put(472, "Starnet");
        manufacturer.put(473, "BETA CAVI");
        manufacturer.put(474, "EaseMore");
        manufacturer.put(475, "Vivaldi srl");
        manufacturer.put(476, "Gree Electric Appliances,Inc. of Zhuhai");
        manufacturer.put(477, "HWISCON");
        manufacturer.put(478, "Shanghai ELECON Intelligent Technology Co., Ltd.");
        manufacturer.put(479, "Kampmann");
        manufacturer.put(480, "Impolux GmbH / LEDIMAX");
        manufacturer.put(481, "Evaux");
        manufacturer.put(482, "Webro Cables & Connectors Limited");
        manufacturer.put(483, "Shanghai E-tech Solution");
        manufacturer.put(484, "Guangzhou HOKO Electric Co.,Ltd.");
        manufacturer.put(485, "LAMMIN HIGH TECH CO.,LTD");
        manufacturer.put(486, "Shenzhen Merrytek Technology Co., Ltd");
        manufacturer.put(487, "I-Luxus");
        manufacturer.put(488, "Elmos Semiconductor AG");
        manufacturer.put(489, "EmCom Technology Inc");
        manufacturer.put(490, "project innovations GmbH");
        manufacturer.put(491, "Itc");
        manufacturer.put(492, "ABB LV Installation Materials Company Ltd, Beijing");
        manufacturer.put(493, "Maico ");
        manufacturer.put(494, "Total Solution GmbH");
        manufacturer.put(495, "ELAN SRL");
        manufacturer.put(496, "MinhHa Technology co.,Ltd");
        manufacturer.put(497, "Zhejiang Tianjie Industrial CORP.");
        manufacturer.put(498, "iAutomation Pty Limited");
        manufacturer.put(499, "Extron");
        manufacturer.put(500, "Freedompro");
        manufacturer.put(501, "Voxior Inc.");
        manufacturer.put(502, "EOS Saunatechnik GmbH");
        manufacturer.put(503, "KUSATEK GmbH");
        manufacturer.put(504, "EisB\u00e4r Scada");
        manufacturer.put(505, "AUTOMATISMI BENINCA S.P.A.");
        manufacturer.put(506, "Blendom");
        manufacturer.put(507, "Madel Air Technical diffusion");
        manufacturer.put(508, "NIKO");
        manufacturer.put(509, "Bosch Rexroth AG");
        manufacturer.put(512, "C&M Products");
        manufacturer.put(513, "H\u00f6rmann KG Verkaufsgesellschaft");
        manufacturer.put(514, "Shanghai Rajayasa co.,LTD");
        manufacturer.put(515, "SUZUKI");
        manufacturer.put(516, "Silent Gliss International Ltd.");
        manufacturer.put(517, "BEE Controls (ADGSC Group)");
        manufacturer.put(518, "xDTecGmbH");
        manufacturer.put(519, "OSRAM");
        manufacturer.put(520, "Lebenor");
        manufacturer.put(521, "automaneng");
        manufacturer.put(522, "Honeywell Automation Solution control (China)");
        manufacturer.put(523, "Hangzhou binthen Intelligence Technology Co.,Ltd");
        manufacturer.put(524, "ETA Heiztechnik");
        manufacturer.put(525, "DIVUS GmbH");
        manufacturer.put(526, "Nanjing Taijiesai Intelligent Technology Co. Ltd.");
        manufacturer.put(527, "Lunatone");
        manufacturer.put(528, "ZHEJIANG SCTECH BUILDING INTELLIGENT");
        manufacturer.put(529, "Foshan Qite Technology Co., Ltd.");
        manufacturer.put(530, "NOKE");
        manufacturer.put(531, "LANDCOM");
        manufacturer.put(532, "Stork AS");
        manufacturer.put(533, "Hangzhou Shendu Technology Co., Ltd.");
        manufacturer.put(534, "CoolAutomation");
        manufacturer.put(535, "Aprstern");
        manufacturer.put(536, "sonnen");
        manufacturer.put(537, "DNAKE");
    }

    public DeviceInfo(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            DeviceInfo d = new DeviceInfo(args);
            Main.ShutdownHandler sh = new Main.ShutdownHandler().register();
            d.run();
            sh.unregister();
        }
        catch (Throwable t) {
            out.error("parsing options", t);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Throwable thrown = null;
        boolean canceled = false;
        IndividualAddress device = (IndividualAddress)this.options.get("device");
        try {
            if (this.options.isEmpty()) {
                DeviceInfo.out("DeviceInfo - Read KNX device information");
                Main.showVersion();
                DeviceInfo.out("Type --help for help message");
                return;
            }
            if (this.options.containsKey("about")) {
                ((Runnable)this.options.get("about")).run();
                return;
            }
            try {
                if (device != null) {
                    Throwable throwable = null;
                    Object var5_11 = null;
                    try {
                        KNXNetworkLink link = this.createLink();
                        try {
                            try (RemotePropertyServiceAdapter adapter = new RemotePropertyServiceAdapter(link, device, e -> {}, true);){
                                this.mc = adapter.managementClient();
                                this.d = adapter.destination();
                                this.pc = new PropertyClient((PropertyAdapter)adapter);
                                out.info("Reading data from device {}, might take some seconds ...", (Object)device);
                                this.readDeviceInfo();
                            }
                            if (link == null) return;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (link == null) throw throwable;
                            link.close();
                            throw throwable;
                        }
                        link.close();
                        return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                if (this.options.containsKey("usb")) {
                    Throwable throwable = null;
                    Object var5_14 = null;
                    try {
                        UsbConnection conn = new UsbConnection((String)this.options.get("host"));
                        try {
                            try (LocalDeviceManagementUsb adapter = new LocalDeviceManagementUsb(conn, e -> {}, false);){
                                this.dd = conn.deviceDescriptor();
                                this.pc = new PropertyClient((PropertyAdapter)adapter);
                                out.info("Reading info of KNX USB adapter {}, might take some seconds ...", (Object)this.dd);
                                this.readDeviceInfo();
                            }
                            if (conn == null) return;
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            if (conn == null) throw throwable;
                            conn.close();
                            throw throwable;
                        }
                        conn.close();
                        return;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                            throw throwable;
                        } else {
                            if (throwable == throwable5) throw throwable;
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                Throwable throwable = null;
                Object var5_17 = null;
                try (LocalDeviceManagementIp adapter = Main.newLocalDeviceMgmtIP(this.options, closed -> {});){
                    this.pc = new PropertyClient((PropertyAdapter)adapter);
                    out.info("Reading info of KNXnet/IP {}, might take some seconds ...", (Object)adapter.getName());
                    this.readDeviceInfo();
                    return;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        throw throwable;
                    } else {
                        if (throwable == throwable6) throw throwable;
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (RuntimeException | KNXException e2) {
                thrown = e2;
                return;
            }
            catch (InterruptedException interruptedException) {
                canceled = true;
                Thread.currentThread().interrupt();
            }
            return;
        }
        finally {
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    protected void onDeviceInformation(Parameter parameter, String value, byte[] raw) {
    }

    protected void onDeviceInformation(Item item) {
        this.out(item);
        this.onDeviceInformation(item.parameter(), item.value(), item.raw());
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            out.info("reading device info canceled");
        }
        if (thrown != null) {
            out.error("completed", (Throwable)thrown);
        }
    }

    private void out(Item item) {
        boolean printCategory = this.categories.add(item.category());
        if (printCategory && !"General".equals(item.category())) {
            DeviceInfo.out(String.valueOf(System.lineSeparator()) + item.category());
        }
        String s = String.valueOf(item.parameter().friendlyName()) + " = " + item.value();
        String hex = item.raw().length > 0 ? "0x" + DataUnitBuilder.toHex((byte[])item.raw(), (String)"") : "n/a";
        int n = Math.max(1, 60 - s.length());
        String detail = "";
        DeviceInfo.out(String.valueOf(s) + detail);
    }

    private String interfaceObjectName(int objectIndex) {
        for (Map.Entry<Integer, List<Integer>> entry : this.ifObjects.entrySet()) {
            if (!entry.getValue().contains(objectIndex)) continue;
            return PropertyClient.getObjectTypeName((int)entry.getKey());
        }
        return "";
    }

    private void findInterfaceObjects() throws KNXException, InterruptedException {
        if (this.readElements(0, 1) <= 0) {
            return;
        }
        int objects = this.readElements(0, 71);
        if (objects > 0) {
            byte[] data = this.read(0, 71, 1, objects);
            if (data == null) {
                return;
            }
            int i = 0;
            while (i < data.length / 2) {
                int type = (data[2 * i] & 0xFF) << 8 | data[2 * i + 1] & 0xFF;
                this.ifObjects.compute(type, (__, v) -> v == null ? new ArrayList() : v).add(i);
                ++i;
            }
        } else {
            this.ifObjects.put(0, List.of(Integer.valueOf(0)));
            int i = 1;
            while (i < 100) {
                int type = (int)DeviceInfo.toUnsigned(this.read(i, 1));
                if (type < 0) break;
                this.ifObjects.compute(type, (__, v) -> v == null ? new ArrayList() : v).add(i);
                ++i;
            }
            if (this.ifObjects.size() == 1) {
                this.ifObjects.put(8, List.of(Integer.valueOf(1)));
                out.info("Device implements only Device Object and cEMI Object");
            }
        }
    }

    private void readDeviceInfo() throws KNXException, InterruptedException {
        if (this.dd != null) {
            this.dd = this.deviceDescriptor(this.dd.toByteArray());
        } else if (this.mc != null) {
            this.dd = this.deviceDescriptor(this.mc.readDeviceDesc(this.d, 0));
        }
        if (this.dd != null) {
            if (this.dd == DeviceDescriptor.DD0.TYPE_1013) {
                this.readPL110Bcu1();
            } else if (this.dd == DeviceDescriptor.DD0.TYPE_0010 || this.dd == DeviceDescriptor.DD0.TYPE_0011 || this.dd == DeviceDescriptor.DD0.TYPE_0012) {
                this.readTP1Bcu1();
            } else if (this.dd == DeviceDescriptor.DD0.TYPE_0020 || this.dd == DeviceDescriptor.DD0.TYPE_0021 || this.dd == DeviceDescriptor.DD0.TYPE_0025) {
                this.readTP1Bcu2();
            } else if (this.dd == DeviceDescriptor.DD0.TYPE_0700 || this.dd == DeviceDescriptor.DD0.TYPE_0701) {
                this.readTP1Bcu1();
            } else {
                this.findInterfaceObjects();
            }
        } else {
            this.findInterfaceObjects();
        }
        boolean bl = this.isSystemB = this.dd == DeviceDescriptor.DD0.TYPE_07B0 || this.dd == DeviceDescriptor.DD0.TYPE_17B0 || this.dd == DeviceDescriptor.DD0.TYPE_27B0 || this.dd == DeviceDescriptor.DD0.TYPE_57B0;
        if (this.ifObjects.containsKey(0)) {
            this.readDeviceObject(0);
        }
        this.readActualPeiType();
        this.programmingMode();
        this.iterate(3, idx -> {
            this.readUnsigned((int)idx, 16, false, CommonParameter.RequiredPeiType);
            this.readProgram((int)idx);
        });
        this.iterate(4, this::readProgram);
        this.iterate(1, this::readLoadState);
        this.iterate(2, this::readLoadState);
        if (this.mc != null && !this.groupAddressesDone) {
            this.readGroupAddresses();
        }
        this.iterate(8, this::readCemiServerObject);
        this.iterate(19, this::readRFMediumObject);
        try {
            this.iterate(11, this::readKnxipInfo);
        }
        catch (InterruptedException | KNXException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.iterate(17, this::readSecurityObject);
    }

    private <E extends Exception> void iterate(int objectType, ThrowingConsumer<Integer, E> consumer) throws E {
        int i = 0;
        for (Integer idx : this.objectIndices(objectType)) {
            this.category = String.valueOf(this.interfaceObjectName(idx)) + (++i > 1 ? " " + i : "");
            consumer.accept(idx);
        }
    }

    private List<Integer> objectIndices(int objectType) {
        return this.ifObjects.getOrDefault(objectType, List.of());
    }

    private void programmingMode() throws KNXFormatException, InterruptedException {
        DPTXlatorBoolean x = new DPTXlatorBoolean(DPTXlatorBoolean.DPT_SWITCH);
        try {
            if (this.ifObjects.containsKey(0)) {
                x.setData(this.pc.getProperty(0, 54, 1, 1));
                this.putResult((Parameter)CommonParameter.ProgrammingMode, x.getValue(), x.getData());
                return;
            }
        }
        catch (KNXException kNXException) {}
        try {
            if (this.mc != null) {
                x.setData(this.mc.readMemory(this.d, 96, 1));
                this.putResult((Parameter)CommonParameter.ProgrammingMode, x.getValue(), x.getData());
            }
        }
        catch (KNXException e) {
            out.error("reading memory location 0x60", (Throwable)e);
        }
    }

    private DeviceDescriptor.DD0 deviceDescriptor(byte[] data) {
        DeviceDescriptor.DD0 dd = DeviceDescriptor.DD0.from((byte[])data);
        this.putResult((Parameter)CommonParameter.DeviceDescriptor, dd.toString(), dd.maskVersion());
        this.putResult((Parameter)CommonParameter.KnxMedium, DeviceInfo.toMediumTypeString(dd.mediumType()), dd.mediumType());
        this.putResult((Parameter)CommonParameter.FirmwareType, DeviceInfo.toFirmwareTypeString(dd.firmwareType()), dd.firmwareType());
        this.putResult((Parameter)CommonParameter.FirmwareVersion, "" + dd.firmwareVersion(), dd.firmwareVersion());
        return dd;
    }

    private void readDeviceObject(int objectIdx) throws InterruptedException {
        this.read(CommonParameter.Manufacturer, objectIdx, 12, data -> DeviceInfo.manufacturer((int)DeviceInfo.toUnsigned(data)));
        this.readUnsigned(objectIdx, 15, true, CommonParameter.OrderInfo);
        this.read(CommonParameter.SerialNumber, objectIdx, 11, DeviceInfo::knxSerialNumber);
        this.readUnsigned(objectIdx, 16, false, CommonParameter.ActualPeiType);
        this.readUnsigned(objectIdx, 78, true, CommonParameter.HardwareType);
        this.readUnsigned(objectIdx, 9, false, CommonParameter.FirmwareRevision);
        byte[] data2 = this.read(CommonParameter.DeviceDescriptor, objectIdx, 83);
        if (data2 != null) {
            DeviceDescriptor.DD0 profile = DeviceDescriptor.DD0.from((byte[])data2);
            if (this.dd == null) {
                this.dd = this.deviceDescriptor(data2);
            } else if (!profile.equals((Object)this.dd)) {
                this.putResult((Parameter)InternalParameter.AdditionalProfile, profile.toString(), data2);
            }
        }
        try {
            byte[] profileSna = this.read(CommonParameter.DeviceAddress, objectIdx, 57);
            byte[] profileDev = this.read(objectIdx, 58);
            byte[] profileAddr = new byte[]{profileSna[0], profileDev[0]};
            IndividualAddress ia = new IndividualAddress(profileAddr);
            this.putResult((Parameter)CommonParameter.DeviceAddress, "Additional profile address " + ia, ia.toByteArray());
        }
        catch (Exception exception) {}
        try {
            byte[] svcCtrl = this.read(InternalParameter.IndividualAddressWriteEnabled, objectIdx, 8);
            boolean indAddrWriteEnabled = (svcCtrl[1] & 4) == 4;
            this.putResult((Parameter)InternalParameter.IndividualAddressWriteEnabled, indAddrWriteEnabled ? "yes" : "no", svcCtrl[1] & 4);
            int services = svcCtrl[0] & 0xFF;
            String formatted = String.format("%8s", Integer.toBinaryString(services)).replace(' ', '0');
            this.putResult((Parameter)InternalParameter.ServiceControl, "Disabled services on EMI [Mgmt App TL-conn Switch TL-group Network Link User]: " + formatted, services);
        }
        catch (Exception exception) {}
        try {
            this.read(CommonParameter.DomainAddress, objectIdx, 82, bytes -> DataUnitBuilder.toHex((byte[])bytes, (String)""));
        }
        catch (Exception exception) {}
        this.read(CommonParameter.SoftwareVersion, objectIdx, 25, DeviceInfo::version);
        this.readUnsigned(objectIdx, 56, false, CommonParameter.MaxApduLength);
        this.read(InternalParameter.ErrorFlags, objectIdx, 53, DeviceInfo::errorFlags);
    }

    private void readCemiServerObject(int objectIndex) throws InterruptedException {
        this.read(CemiParameter.MediumType, objectIndex, 51, DeviceInfo::mediumTypes);
        this.read(CemiParameter.SupportedCommModes, objectIndex, 64, DeviceInfo::supportedCommModes);
        this.read(CemiParameter.SelectedCommMode, objectIndex, 52, DeviceInfo::commMode);
        try {
            byte[] dev = this.read(CemiParameter.ClientAddress, objectIndex, 58);
            byte[] sna = this.read(objectIndex, 57);
            byte[] addr = new byte[]{sna[0], dev[0]};
            IndividualAddress ia = new IndividualAddress(addr);
            this.putResult((Parameter)CemiParameter.ClientAddress, "USB cEMI client address " + ia, ia.toByteArray());
        }
        catch (Exception exception) {}
        this.readSupportedFilteringModes(objectIndex, 65);
        this.readSelectedFilteringMode(objectIndex, 66);
        this.readSupportedFilteringModes(objectIndex, 63);
        this.readSelectedFilteringMode(objectIndex, 62);
        try {
            this.cEmiExtensionRfBiBat(objectIndex);
        }
        catch (Exception exception) {}
        try {
            byte[] data = this.read(objectIndex, 60);
            int selected = data[0] & 0xFF;
            boolean slave = (data[0] & 4) == 4;
            boolean master = (data[0] & 2) == 2;
            boolean async = (data[0] & 1) == 1;
            String formatted = "BiBat slave " + slave + ", BiBat master " + master + ", async " + async;
            this.putResult((Parameter)CemiParameter.SelectedRfMode, formatted, selected);
        }
        catch (Exception exception) {}
    }

    private void readSupportedFilteringModes(int objectIndex, int pid) {
        try {
            this.read(CemiParameter.SupportedFilteringModes, objectIndex, pid, filters -> {
                int filter = filters[1] & 0xFF;
                boolean grp = (filter & 8) == 8;
                boolean doa = (filter & 4) == 4;
                boolean rep = (filter & 2) == 2;
                boolean ownIa = (filter & 1) == 1;
                return "ext. group addresses " + grp + ", domain address " + doa + ", repeated frames " + rep + ", own individual address " + ownIa;
            });
        }
        catch (Exception exception) {}
    }

    private void readSelectedFilteringMode(int objectIndex, int pid) {
        try {
            this.read(CemiParameter.SelectedFilteringModes, objectIndex, pid, filters -> {
                boolean ownIa;
                int selected = filters[1] & 0xFF;
                boolean grp = (selected & 8) == 8;
                boolean doa = (selected & 4) == 4;
                boolean rep = (selected & 2) == 2;
                boolean bl = ownIa = (selected & 1) == 1;
                if (selected == 0) {
                    return "all supported filters active";
                }
                return "disabled frame filters: ext. group addresses " + grp + ", domain address " + doa + ", repeated frames " + rep + ", own individual address " + ownIa;
            });
        }
        catch (Exception exception) {}
    }

    private void cEmiExtensionRfBiBat(int objectIndex) throws KNXException, InterruptedException {
        this.read(CemiParameter.SupportedRfModes, objectIndex, 61, support -> {
            boolean slave = (support[0] & 4) == 4;
            boolean master = (support[0] & 2) == 2;
            boolean async = (support[0] & 1) == 1;
            return "BiBat slave " + slave + ", BiBat master " + master + ", Async " + async;
        });
    }

    private static String supportedCommModes(byte[] commModes) {
        int modes = commModes[1] & 0xFF;
        boolean tll = (modes & 8) == 8;
        boolean raw = (modes & 4) == 4;
        boolean bm = (modes & 2) == 2;
        boolean dll = (modes & 1) == 1;
        String s = "Transport layer local " + tll + ", Data link layer modes: normal " + dll + ", busmonitor " + bm + ", raw mode " + raw;
        return s;
    }

    private static String commMode(byte[] data) {
        int commMode = data[0] & 0xFF;
        switch (commMode) {
            case 0: {
                return "Data link layer";
            }
            case 1: {
                return "Data link layer busmonitor";
            }
            case 2: {
                return "Data link layer raw frames";
            }
            case 6: {
                return "cEMI transport layer";
            }
            case 255: {
                return "no layer";
            }
        }
        return "unknown/unspecified (" + commMode + ")";
    }

    private void readRFMediumObject(int objectIndex) {
        try {
            this.read(RfParameter.DomainAddress, objectIndex, 56, doa -> "0x" + DataUnitBuilder.toHex((byte[])doa, (String)""));
        }
        catch (Exception exception) {}
    }

    private void readSystemState() throws InterruptedException {
        int state = this.readMem(96, 1);
        state &= 0x7F;
        String[] mode = new String[]{"Programming mode", "Normal operation", "Transport layer", "Application layer", "Serial PEI interface (msg protocol)", "User program", "Programming mode (ind. address)"};
        StringBuilder sb = new StringBuilder();
        int bit = 0;
        while (bit < 7) {
            if ((state & 1 << bit) != 0) {
                sb.append(mode[bit]).append(", ");
            }
            ++bit;
        }
        this.putResult((Parameter)CommonParameter.SystemState, sb.toString(), state);
    }

    private void readActualPeiType() throws InterruptedException {
        if (this.mc == null) {
            return;
        }
        try {
            int v = this.mc.readADC(this.d, 4, 1);
            int peitype = (10 * v + 60) / 128;
            this.putResult((Parameter)CommonParameter.ActualPeiType, DeviceInfo.toPeiTypeString(peitype), peitype);
        }
        catch (KNXException e) {
            out.error("reading actual PEI type (A/D converter channel {}, repeat {})", new Object[]{4, 1, e});
        }
    }

    private void readSecurityObject(int objectIndex) throws InterruptedException {
        byte[] empty = new byte[]{};
        this.readFunctionPropertyState((Parameter)SecurityParameter.SecurityMode, 17, 51, 0, empty, DeviceInfo::toOnOff);
        this.read(SecurityParameter.SecurityFailure, objectIndex, 57, DeviceInfo::toYesNo);
        byte[] readFailureCounters = new byte[1];
        this.readFunctionPropertyState((Parameter)SecurityParameter.SecurityFailureCounters, 17, 55, 0, readFailureCounters, DeviceInfo::securityFailureCounters);
        int i = 0;
        while (i < 5) {
            byte[] failure = new byte[]{(byte)i};
            Optional<byte[]> result = this.readFunctionPropertyState((Parameter)SecurityParameter.LastSecurityFailure, 17, 55, 1, failure, DeviceInfo::latestSecurityFailure);
            if (result.isEmpty()) break;
            ++i;
        }
    }

    private static String toOnOff(byte[] data) {
        return (data[2] & 1) != 0 ? "on" : "off";
    }

    private static String toYesNo(byte[] data) {
        return (data[0] & 1) != 0 ? "yes" : "no";
    }

    private static String securityFailureCounters(byte[] data) {
        ByteBuffer counters = ByteBuffer.wrap(data, 3, data.length - 3);
        int scfErrors = counters.getShort() & 0xFFFF;
        int seqNoErrors = counters.getShort() & 0xFFFF;
        int cryptoErrors = counters.getShort() & 0xFFFF;
        int accessRoleErrors = counters.getShort() & 0xFFFF;
        return "control field " + scfErrors + ", sequence " + seqNoErrors + ", cryptographic " + cryptoErrors + ", access " + accessRoleErrors;
    }

    private static String latestSecurityFailure(byte[] data) {
        ByteBuffer msgInfo = ByteBuffer.wrap(data, 3, data.length - 3);
        IndividualAddress src = new IndividualAddress(msgInfo.getShort() & 0xFFFF);
        int dstRaw = msgInfo.getShort() & 0xFFFF;
        int ctrl2 = msgInfo.get() & 0xFF;
        boolean group = (ctrl2 & 0x80) != 0;
        GroupAddress dst = group ? new GroupAddress(dstRaw) : new IndividualAddress(dstRaw);
        byte[] seqData = new byte[6];
        msgInfo.get(seqData);
        long seqNo = DeviceInfo.toUnsigned(seqData);
        String[] errorTypes = new String[]{"reserved", "invalid SCF", "sequence error", "cryptographic error", "error against access & roles"};
        String error = errorTypes[msgInfo.get() & 0xFF];
        return String.format("%s->%s seq %d: %s", src, dst, seqNo, error);
    }

    private static String errorFlags(byte[] data) {
        if ((data[0] & 0xFF) == 255) {
            return "everything OK";
        }
        String[] description = new String[]{"System 1 internal system error", "Illegal system state", "Checksum / CRC error in internal non-volatile memory", "Stack overflow error", "Inconsistent system tables", "Physical transceiver error", "System 2 internal system error", "System 3 internal system error"};
        ArrayList<String> errors = new ArrayList<String>();
        int i = 0;
        while (i < 8) {
            if ((data[0] & 1 << i) == 0) {
                errors.add(description[i]);
            }
            ++i;
        }
        return errors.stream().collect(Collectors.joining(", "));
    }

    private void putResult(Parameter p, String formatted, long raw) {
        this.putResult(p, formatted, ByteBuffer.allocate(8).putLong(raw).array());
    }

    private void putResult(Parameter p, String formatted, int raw) {
        this.putResult(p, formatted, ByteBuffer.allocate(4).putInt(raw).array());
    }

    private void putResult(Parameter p, String formatted, byte[] raw) {
        Item item = new Item(this.category, p, formatted, raw);
        this.onDeviceInformation(item);
    }

    private void readPL110Bcu1() throws InterruptedException {
        this.readMem(258, 2, "DoA ", true, (Parameter)CommonParameter.DomainAddress);
        this.readBcuInfo(true);
    }

    private void readTP1Bcu1() throws InterruptedException {
        this.readMem(257, 3, "KNX manufacturer data ", true, (Parameter)CommonParameter.ManufacturerData);
        this.readBcuInfo(true);
    }

    private void readTP1Bcu2() throws InterruptedException, KNXException {
        this.readMem(257, 2, "KNX manufacturer ", DeviceInfo::manufacturer, (Parameter)CommonParameter.Manufacturer);
        long appId = this.readMemLong(259, 5);
        String appMf = DeviceInfo.manufacturer((int)appId >> 24);
        long swDev = appId >> 8 & 0xFFL;
        long swVersion = appId & 0xFFL;
        out.info("appId 0x{} - app manufacturer: {}, SW dev type {}, SW version {}", new Object[]{Long.toHexString(appId), appMf, swDev, swVersion});
        this.readBcuInfo(false);
        this.findInterfaceObjects();
    }

    private void readBcuInfo(boolean bcu1) throws InterruptedException {
        if (bcu1) {
            this.readMem(260, 1, "KNX manufacturer ", DeviceInfo::manufacturer, (Parameter)CommonParameter.Manufacturer);
            this.readMem(261, 2, "Device type number ", true, (Parameter)CommonParameter.DeviceTypeNumber);
        }
        this.readMem(263, 1, "SW version ", i -> DeviceInfo.version(new byte[]{(byte)i.intValue()}), (Parameter)CommonParameter.SoftwareVersion);
        this.readMem(265, 1, "Hardware PEI type ", DeviceInfo::toPeiTypeString, (Parameter)CommonParameter.RequiredPeiType);
        this.readMem(269, 1, "Run error 0x", DeviceInfo::decodeRunError, (Parameter)CommonParameter.RunError);
        this.readSystemState();
        this.readMem(270, 1, "Routing count ", v -> Integer.toString(v >> 4 & 7), (Parameter)CommonParameter.RoutingCount);
        this.readMem(274, 1, "Group object table location ", true, (Parameter)CommonParameter.GroupObjTableLocation);
        this.readGroupAddresses();
    }

    private void readGroupAddresses() throws InterruptedException {
        int memLocation;
        if (this.dd.equals(DeviceDescriptor.DD0.TYPE_5705)) {
            memLocation = 16384;
        } else if (this.ifObjects.containsKey(1)) {
            int addresstableObjectIdx = this.ifObjects.get(1).get(0);
            int tableSize = this.readElements(addresstableObjectIdx, 23);
            if (tableSize > 0) {
                StringJoiner joiner = new StringJoiner(", ");
                int i = 0;
                while (i < tableSize) {
                    GroupAddress group = new GroupAddress(this.read(addresstableObjectIdx, 23, i + 1, 1));
                    joiner.add(group.toString());
                    ++i;
                }
                this.groupAddressesDone = true;
                this.putResult((Parameter)CommonParameter.GroupAddresses, joiner.toString(), new byte[0]);
                return;
            }
            memLocation = (int)DeviceInfo.toUnsigned(this.read(addresstableObjectIdx, 7));
            if (memLocation <= 0) {
                return;
            }
        } else {
            memLocation = 278;
        }
        int lengthSize = this.isSystemB ? 2 : 1;
        int entries = this.readMem(memLocation, lengthSize, "Group address table entries ", false, (Parameter)CommonParameter.GroupAddressTableEntries);
        int startAddr = memLocation + lengthSize;
        if (!this.isSystemB && entries > 0) {
            this.readMem(startAddr, 2, "", v -> new IndividualAddress(v & Short.MAX_VALUE).toString(), (Parameter)CommonParameter.DeviceAddress);
            startAddr += 2;
        }
        StringBuilder sb = new StringBuilder();
        int i = this.isSystemB ? 0 : 1;
        while (i < entries) {
            int raw = this.readMem(startAddr, 2);
            GroupAddress group = new GroupAddress(raw & Short.MAX_VALUE);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(group);
            if ((raw & 0x8000) == 32768) {
                sb.append("(R)");
            }
            startAddr += 2;
            ++i;
        }
        this.groupAddressesDone = true;
        this.putResult((Parameter)CommonParameter.GroupAddresses, sb.toString(), new byte[0]);
    }

    private void readKnxipInfo(int objectIndex) throws KNXException, InterruptedException {
        boolean manual;
        this.read(KnxipParameter.DeviceName, () -> this.readFriendlyName(objectIndex));
        byte[] data = this.read(KnxipParameter.Capabilities, objectIndex, 68, DeviceInfo::toCapabilitiesString).orElse(new byte[2]);
        boolean supportsTunneling = (data[1] & 1) == 1;
        this.read(KnxipParameter.MacAddress, objectIndex, 64, mac -> DataUnitBuilder.toHex((byte[])mac, (String)":"));
        data = this.read(KnxipParameter.CurrentIPAssignment, objectIndex, 54, DeviceInfo::toIPAssignmentString).orElse(new byte[1]);
        int currentIPAssignment = data[0] & 0xF;
        boolean dhcpOrBoot = (data[0] & 6) != 0;
        byte[] currentIP = this.readIp(KnxipParameter.CurrentIPAddress, objectIndex, 57);
        byte[] currentMask = this.readIp(KnxipParameter.CurrentSubnetMask, objectIndex, 58);
        byte[] currentGw = this.readIp(KnxipParameter.CurrentDefaultGateway, objectIndex, 59);
        if (dhcpOrBoot) {
            this.readIp(KnxipParameter.DhcpServer, objectIndex, 63);
        }
        boolean bl = manual = ((data = this.read(KnxipParameter.ConfiguredIPAssignment, objectIndex, 55, config -> {
            int ipAssignment = config[0] & 0xF;
            return ipAssignment != currentIPAssignment ? DeviceInfo.toIPAssignmentString(config) : "";
        }).orElse(new byte[1]))[0] & 1) == 1;
        if (manual) {
            this.read(KnxipParameter.IPAddress, objectIndex, 60, ip -> Arrays.equals(currentIP, ip) ? "" : DeviceInfo.toIP(ip));
            this.read(KnxipParameter.SubnetMask, objectIndex, 61, mask -> Arrays.equals(currentMask, mask) ? "" : DeviceInfo.toIP(mask));
            this.read(KnxipParameter.DefaultGateway, objectIndex, 62, gw -> Arrays.equals(currentGw, gw) ? "" : DeviceInfo.toIP(gw));
        }
        this.readIp(KnxipParameter.RoutingMulticast, objectIndex, 66);
        this.readUnsigned(objectIndex, 67, false, KnxipParameter.TimeToLive);
        this.readUnsigned(objectIndex, 74, false, KnxipParameter.TransmitToIP);
        if (supportsTunneling) {
            int elements = this.readElements(objectIndex, 53);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < elements) {
                data = this.read(objectIndex, 53, i + 1, 1, false);
                sb.append(new IndividualAddress(data)).append(" ");
                ++i;
            }
            this.putResult((Parameter)KnxipParameter.AdditionalIndividualAddresses, sb.toString(), new byte[0]);
        }
    }

    private void readProgram(int objectIdx) throws InterruptedException {
        this.read(CommonParameter.ProgramVersion, objectIdx, 13, DeviceInfo::programVersion);
        this.readLoadState(objectIdx);
        this.read(CommonParameter.RunStateControl, objectIdx, 6, DeviceInfo::getRunState);
    }

    private static String programVersion(byte[] data) {
        if (data.length != 5) {
            return DataUnitBuilder.toHex((byte[])data, (String)"");
        }
        int mfr = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        return String.format("%s %02x%02x v%d.%d", DeviceInfo.manufacturer(mfr), data[2], data[3], (data[4] & 0xFF) >> 4, data[4] & 0xF);
    }

    private void readLoadState(int objectIdx) throws InterruptedException {
        Optional<byte[]> data = this.read(CommonParameter.LoadStateControl, objectIdx, 5, DeviceInfo::getLoadState);
        boolean hasErrorCode = this.isSystemB;
        if (hasErrorCode && data.isPresent() && data.get()[0] == 3) {
            this.read(CommonParameter.LoadStateError, objectIdx, 28, error -> {
                try {
                    return TranslatorTypes.createTranslator((String)"20.011", (byte[])error).getValue();
                }
                catch (KNXException kNXException) {
                    return "";
                }
            });
        }
    }

    private Optional<byte[]> readFunctionPropertyState(Parameter p, int objectType, int propertyId, int service, byte[] info, Function<byte[], String> representation) throws InterruptedException {
        Optional<byte[]> data = Optional.ofNullable(this.readFunctionPropertyState(p, objectType, propertyId, service, info));
        data.map(representation).filter(Predicate.not(String::isEmpty)).ifPresent(formatted -> this.putResult(p, (String)formatted, (byte[])data.get()));
        return data;
    }

    private byte[] readFunctionPropertyState(Parameter p, int objectType, int propertyId, int service, byte ... info) throws InterruptedException {
        if (this.mc == null) {
            return null;
        }
        out.debug("read function property state {}({})|{} service {}", new Object[]{objectType, 1, propertyId, service});
        try {
            return this.mc.readFunctionPropertyState(this.d, objectType, 1, propertyId, service, info);
        }
        catch (KNXException e) {
            out.debug(e.getMessage());
            return null;
        }
    }

    private Optional<byte[]> read(Parameter p, int objectIndex, int pid, Function<byte[], String> representation) throws InterruptedException {
        Optional<byte[]> data = Optional.ofNullable(this.read(p, objectIndex, pid));
        data.map(representation).filter(Predicate.not(String::isEmpty)).ifPresent(formatted -> this.putResult(p, (String)formatted, (byte[])data.get()));
        return data;
    }

    private void read(Parameter p, Callable<String> c) throws KNXLinkClosedException, InterruptedException {
        try {
            out.debug("read {} ...", (Object)p.friendlyName());
            String s = c.call();
            this.putResult(p, s, s.getBytes(StandardCharsets.ISO_8859_1));
        }
        catch (InterruptedException | KNXLinkClosedException e) {
            throw e;
        }
        catch (KNXRemoteException e) {
            out.warn("reading {}: {}", (Object)p, (Object)e.getMessage());
        }
        catch (Exception e) {
            out.error("error reading {}", (Object)p, (Object)e);
        }
    }

    private byte[] readIp(Parameter p, int objectIndex, int pid) throws InterruptedException {
        return this.read(p, objectIndex, pid, DeviceInfo::toIP).orElse(new byte[4]);
    }

    private String readFriendlyName(int objectIndex) throws KNXException, InterruptedException {
        byte[] data;
        char[] name = new char[30];
        int start = 0;
        do {
            data = this.pc.getProperty(objectIndex, 76, start + 1, 10);
            int i = 0;
            while (i < 10 && data[i] != 0) {
                name[start] = (char)(data[i] & 0xFF);
                ++i;
                ++start;
            }
        } while (start < 30 && data[9] != 0);
        return new String(name, 0, start);
    }

    private int readElements(int objectIndex, int pid) throws InterruptedException {
        byte[] elems = this.read(objectIndex, pid, 0, 1);
        return elems == null ? -1 : (int)DeviceInfo.toUnsigned(elems);
    }

    private byte[] read(int objectIndex, int pid) throws InterruptedException {
        return this.read(objectIndex, pid, 1, 1, true);
    }

    private byte[] read(Parameter p, int objectIndex, int pid) throws InterruptedException {
        out.debug("read {}|{} {}", new Object[]{objectIndex, pid, p.friendlyName()});
        return this.read(objectIndex, pid, 1, 1, false);
    }

    private byte[] read(int objectIndex, int pid, int start, int elements) throws InterruptedException {
        return this.read(objectIndex, pid, start, elements, true);
    }

    private byte[] read(int objectIndex, int pid, int start, int elements, boolean log) throws InterruptedException {
        if (log) {
            out.debug("read {}|{}", (Object)objectIndex, (Object)pid);
        }
        try {
            ByteArrayOutputStream res = new ByteArrayOutputStream();
            int i = start;
            while (i < start + elements) {
                byte[] data = this.pc.getProperty(objectIndex, pid, i, 1);
                res.write(data, 0, data.length);
                ++i;
            }
            return res.toByteArray();
        }
        catch (KNXException e) {
            out.debug("reading KNX property " + objectIndex + "|" + pid + ": " + e.getMessage());
            return null;
        }
    }

    private void readUnsigned(int objectIndex, int pid, boolean hex, Parameter p) throws InterruptedException {
        byte[] data = this.read(p, objectIndex, pid);
        if (data != null) {
            String formatted = hex ? DataUnitBuilder.toHex((byte[])data, (String)"") : Long.toString(DeviceInfo.toUnsigned(data));
            this.putResult(p, formatted, data);
        }
    }

    private int readMem(int startAddr, int bytes, String prefix, boolean hex, Parameter p) throws InterruptedException {
        out.debug("read 0x{}..0x{} {}", new Object[]{Long.toHexString(startAddr), Long.toHexString(startAddr + bytes), p.friendlyName()});
        long v = this.readMemLong(startAddr, bytes);
        if (v != -1L) {
            this.putResult(p, hex ? Long.toHexString(v) : Long.toString(v), v);
        }
        return (int)v;
    }

    private void readMem(int startAddr, int bytes, String prefix, Function<Integer, String> representation, Parameter p) throws InterruptedException {
        int v = this.readMem(startAddr, bytes);
        this.putResult(p, representation.apply(v), v);
    }

    private int readMem(int startAddr, int bytes) throws InterruptedException {
        return (int)this.readMemLong(startAddr, bytes);
    }

    private long readMemLong(int startAddr, int bytes) throws InterruptedException {
        try {
            return DeviceInfo.toUnsigned(this.mc.readMemory(this.d, startAddr, bytes));
        }
        catch (KNXException e) {
            out.debug("error reading 0x{}..0x{}: {}", new Object[]{Long.toHexString(startAddr), Long.toHexString(startAddr + bytes), e.toString()});
            return -1L;
        }
    }

    private KNXNetworkLink createLink() throws KNXException, InterruptedException {
        return Main.newLink(this.options);
    }

    private void parseOptions(String[] args) {
        if (args.length == 0) {
            return;
        }
        this.options.put("port", 3671);
        Iterator<String> i = List.of(args).iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", DeviceInfo::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "knx-address", "k")) {
                this.options.put("knx-address", Main.getAddress(i.next()));
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            if (!this.options.containsKey("device")) {
                try {
                    this.options.put("device", new IndividualAddress(arg));
                    continue;
                }
                catch (KNXFormatException e) {
                    throw new KNXIllegalArgumentException("KNX device " + e.toString(), (Throwable)e);
                }
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (!this.options.containsKey("host") || this.options.containsKey("ft12") && this.options.containsKey("usb")) {
            throw new KNXIllegalArgumentException("specify either IP host, serial port, or device");
        }
        if (!this.options.containsKey("device")) {
            String adapter;
            String string = this.options.containsKey("ft12") ? "FT1.2" : (adapter = this.options.containsKey("tpuart") ? "TP-UART" : "");
            if (!adapter.isEmpty()) {
                throw new KNXIllegalArgumentException("reading device info of local " + adapter + " interface is not supported, specify remote KNX device address");
            }
            if (this.options.containsKey("medium") || this.options.containsKey("domain")) {
                throw new KNXIllegalArgumentException("missing remote KNX device address");
            }
        }
        if (!this.options.containsKey("medium")) {
            this.options.put("medium", new TPSettings());
        }
        Main.setDomainAddress(this.options);
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        joiner.add("Usage: DeviceInfo [options] <host|port> [KNX device address]");
        Main.printCommonOptions(joiner);
        Main.printSecureOptions(joiner);
        DeviceInfo.out(joiner.toString());
    }

    private static void out(String s) {
        System.out.println(s);
    }

    private static long toUnsigned(byte[] data) {
        if (data == null || data.length > 8) {
            return -1L;
        }
        long value = 0L;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            value = value << 8 | (long)(b & 0xFF);
            ++n2;
        }
        return value;
    }

    private static String toIP(byte[] data) {
        try {
            if (data != null) {
                return InetAddress.getByAddress(data).getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return "n/a";
    }

    private static String toMediumTypeString(int type) {
        switch (type) {
            case 0: {
                return "Twisted Pair 1";
            }
            case 1: {
                return "Power-line 110";
            }
            case 2: {
                return "Radio Frequency";
            }
            case 5: {
                return "KNX IP";
            }
        }
        return "Type " + type;
    }

    private static String mediumTypes(byte[] data) {
        try {
            return TranslatorTypes.createTranslator((DPT)DptXlator16BitSet.DptMedia, (byte[])data).getValue();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String toFirmwareTypeString(int type) {
        switch (type) {
            case 0: {
                return "BCU 1, BCU 2, BIM M113";
            }
            case 1: {
                return "Unidirectional devices";
            }
            case 3: {
                return "Property based device management";
            }
            case 7: {
                return "BIM M112";
            }
            case 8: {
                return "IR Decoder, TP1 legacy";
            }
            case 9: {
                return "Repeater, Coupler";
            }
        }
        return "Type " + type;
    }

    private static String toPeiTypeString(int peitype) {
        if (peitype == -1 || peitype == 255) {
            return "n/a";
        }
        String[] desc = new String[]{"No adapter", "Illegal adapter", "4 inputs, 1 output (LED)", "Reserved", "2 inputs / 2 outputs, 1 output (LED)", "Reserved", "3 inputs / 1 output, 1 output (LED)", "Reserved", "5 inputs", "Reserved", "FT1.2 protocol", "Reserved", "Serial sync message protocol", "Reserved", "Serial sync data block protocol", "Reserved", "Serial async message protocol", "Programmable I/O", "Reserved", "4 outputs, 1 output (LED)", "Download"};
        return desc[peitype];
    }

    private static String decodeRunError(int runError) {
        String[] flags = new String[]{"SYS0_ERR: buffer error", "SYS1_ERR: system state parity error", "EEPROM corrupted", "Stack overflow", "OBJ_ERR: group object/assoc. table error", "SYS2_ERR: transceiver error", "SYS3_ERR: confirm error"};
        int bits = ~runError & 0xFF;
        if (bits == 0) {
            return "OK";
        }
        StringJoiner sb = new StringJoiner(", ");
        int i = 0;
        while (i < flags.length) {
            if ((bits & 1 << i) != 0) {
                sb.add(flags[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    private static String getLoadState(byte[] data) {
        if (data == null || data.length < 1) {
            return "n/a";
        }
        int state = data[0] & 0xFF;
        switch (state) {
            case 0: {
                return "Unloaded";
            }
            case 1: {
                return "Loaded";
            }
            case 2: {
                return "Loading";
            }
            case 3: {
                return "Error (during load process)";
            }
            case 4: {
                return "Unloading";
            }
            case 5: {
                return "Load Completing (Intermediate)";
            }
        }
        return "Invalid load status " + state;
    }

    private static String getRunState(byte[] data) {
        if (data == null || data.length < 1) {
            return "n/a";
        }
        int state = data[0] & 0xFF;
        switch (state) {
            case 0: {
                return "Halted";
            }
            case 1: {
                return "Running";
            }
            case 2: {
                return "Ready";
            }
            case 3: {
                return "Terminated";
            }
            case 4: {
                return "Starting";
            }
            case 5: {
                return "Shutting down";
            }
        }
        return "Invalid run state " + state;
    }

    private static String toIPAssignmentString(byte[] data) {
        int bitset = data[0] & 0xFF;
        StringJoiner joiner = new StringJoiner(", ");
        if ((bitset & 1) != 0) {
            joiner.add("manual");
        }
        if ((bitset & 2) != 0) {
            joiner.add("Bootstrap Protocol");
        }
        if ((bitset & 4) != 0) {
            joiner.add("DHCP");
        }
        if ((bitset & 8) != 0) {
            joiner.add("Auto IP");
        }
        return joiner.toString();
    }

    private static String toCapabilitiesString(byte[] data) {
        StringJoiner joiner = new StringJoiner(", ");
        if ((data[1] & 1) == 1) {
            joiner.add("Device Management");
        }
        if ((data[1] & 2) == 2) {
            joiner.add("Tunneling");
        }
        if ((data[1] & 4) == 4) {
            joiner.add("Routing");
        }
        if ((data[1] & 8) == 8) {
            joiner.add("Remote Logging");
        }
        if ((data[1] & 0x10) == 16) {
            joiner.add("Remote Configuration and Diagnosis");
        }
        if ((data[1] & 0x20) == 32) {
            joiner.add("Object Server");
        }
        return joiner.toString();
    }

    private static String knxSerialNumber(byte[] data) {
        String hex = DataUnitBuilder.toHex((byte[])data, (String)"");
        return String.valueOf(hex.substring(0, 4)) + ":" + hex.substring(4);
    }

    private static String version(byte[] data) {
        if (data.length == 1) {
            return String.valueOf((data[0] & 0xFF) >> 4) + "." + (data[0] & 0xF);
        }
        int magic = (data[0] & 0xFF) >> 3;
        int version = (data[0] & 7) << 2 | (data[1] & 0xC0) >> 6;
        int rev = data[1] & 0x3F;
        return "[" + magic + "] " + version + "." + rev;
    }

    static String manufacturer(int mf) {
        return manufacturer.getOrDefault(mf, "Unknown");
    }

    public static enum CemiParameter implements Parameter
    {
        MediumType,
        SupportedCommModes,
        SelectedCommMode,
        ClientAddress,
        SupportedRfModes,
        SelectedRfMode,
        SupportedFilteringModes,
        SelectedFilteringModes;

    }

    public static enum CommonParameter implements Parameter
    {
        DeviceDescriptor,
        KnxMedium,
        FirmwareType,
        FirmwareVersion,
        HardwareType,
        SerialNumber,
        DomainAddress,
        MaxApduLength,
        Manufacturer,
        ManufacturerData,
        DeviceTypeNumber,
        SoftwareVersion,
        ActualPeiType,
        RequiredPeiType,
        FirmwareRevision,
        RunError,
        ProgrammingMode,
        SystemState,
        RoutingCount,
        GroupObjTableLocation,
        GroupAddressTableEntries,
        DeviceAddress,
        GroupAddresses,
        ProgramVersion,
        LoadStateControl,
        LoadStateError,
        RunStateControl,
        OrderInfo;

    }

    public static enum InternalParameter implements Parameter
    {
        IndividualAddressWriteEnabled,
        ServiceControl,
        AdditionalProfile,
        ErrorFlags;

    }

    public static final class Item {
        private final String category;
        private final Parameter parameter;
        private final String value;
        private final byte[] raw;

        Item(String category, Parameter parameter, String value, byte[] raw) {
            this.category = category;
            this.parameter = parameter;
            this.value = value;
            this.raw = raw;
        }

        public String category() {
            return this.category;
        }

        public Parameter parameter() {
            return this.parameter;
        }

        public String value() {
            return this.value;
        }

        public byte[] raw() {
            return this.raw;
        }
    }

    public static enum KnxipParameter implements Parameter
    {
        DeviceName,
        Capabilities,
        MacAddress,
        IPAddress,
        SubnetMask,
        DefaultGateway,
        CurrentIPAddress,
        CurrentSubnetMask,
        CurrentDefaultGateway,
        IPAssignment,
        ConfiguredIPAssignment,
        DhcpServer,
        CurrentIPAssignment,
        RoutingMulticast,
        TimeToLive,
        TransmitToIP,
        AdditionalIndividualAddresses;

    }

    public static interface Parameter {
        public String name();

        default public String friendlyName() {
            return this.name().replaceAll("([A-Z])", " $1").replace("I P", "IP").trim();
        }
    }

    public static enum RfParameter implements Parameter
    {
        DomainAddress;

    }

    public static enum SecurityParameter implements Parameter
    {
        SecurityMode,
        SecurityFailure,
        SecurityFailureCounters,
        LastSecurityFailure;

    }

    @FunctionalInterface
    private static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

