/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.datapoint.DatapointMap;
import tuwien.auto.calimero.datapoint.StateDP;
import tuwien.auto.calimero.secure.KnxSecureException;
import tuwien.auto.calimero.xml.KNXMLException;

public final class KnxProject {
    private static final String knxproj = ".knxproj";
    private final Path project;
    private final String name;
    private volatile Document document;
    private static final byte[] zipAesEncryptionSalt = "21.project.ets.knx.org".getBytes(StandardCharsets.UTF_8);

    public static List<Path> list(Path dir) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> list = Files.list(dir);){
            return list.filter(path -> path.toString().endsWith(knxproj)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static KnxProject from(Path project) {
        try {
            Path root = project;
            if (project.toString().endsWith(knxproj)) {
                String extractDir = project.getFileName().toString().replace(knxproj, "");
                Path to = project.resolveSibling(extractDir);
                KnxProject.unzip(project, to);
                root = to;
            }
            Throwable throwable = null;
            Object var3_6 = null;
            try (Stream<Path> stream = Files.list(root);){
                Path path;
                String name = root.getFileName().toString();
                root = path = stream.filter(p -> p.getFileName().toString().startsWith("P-")).filter(p -> Files.isDirectory(p, new LinkOption[0]) || p.getFileName().toString().endsWith(".zip")).findFirst().orElseThrow(() -> new FileNotFoundException("KNX project does not contain project folder"));
                Document document = null;
                if (!path.toString().endsWith(".zip") || !KnxProject.isProjectEncrypted(path)) {
                    if (!Files.isDirectory(path, new LinkOption[0])) {
                        throw new FileNotFoundException("no root directory found for parsing");
                    }
                    document = KnxProject.parse(path);
                }
                return new KnxProject(root, name, document);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Throwable e) {
            throw new KNXMLException("parsing " + project, e);
        }
    }

    private KnxProject(Path project, String name, Document document) {
        this.project = project;
        this.name = name;
        this.document = document;
    }

    public String name() {
        return this.name;
    }

    public URI uri() {
        return this.project.getParent().toUri();
    }

    public boolean encrypted() {
        return this.document == null;
    }

    public void decrypt(char[] projectPassword) {
        if (this.document != null) {
            return;
        }
        Path to = Path.of(this.project.toString().replace(".zip", ""), new String[0]);
        try {
            try {
                KnxProject.unzip(this.project, to, projectPassword);
                this.document = KnxProject.parse(to);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (Throwable t) {
                throw new KNXMLException("loading encrypted project file \"" + this.project + "\"", t);
            }
        }
        finally {
            Arrays.fill(projectPassword, '\u0000');
            KnxProject.deleteRecursively(to);
        }
    }

    public DatapointMap<StateDP> datapoints() throws KNXFormatException {
        if (this.encrypted()) {
            throw new KnxSecureException("project \"" + this + "\" is encrypted");
        }
        DatapointMap datapoints = new DatapointMap();
        NodeList groupAddresses = this.document.getElementsByTagName("GroupAddress");
        int length = groupAddresses.getLength();
        int i = 0;
        while (i < length) {
            Node node = groupAddresses.item(i);
            NamedNodeMap attributes = node.getAttributes();
            GroupAddress address = new GroupAddress(KnxProject.attribute(attributes, "Address", ""));
            String name = KnxProject.attribute(attributes, "Name", "");
            Object[] dpt = KnxProject.parseDpt(KnxProject.attribute(attributes, "DatapointType", ""));
            StateDP dp = new StateDP(address, name, ((Integer)dpt[0]).intValue(), (String)dpt[1]);
            datapoints.add((Datapoint)dp);
            ++i;
        }
        return datapoints;
    }

    public String toString() {
        return this.name();
    }

    private static void unzip(Path project, Path to) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(project, new OpenOption[0]));){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                Path target = KnxProject.createPath(to, entry);
                if (!entry.isDirectory()) {
                    Files.copy(zis, target, StandardCopyOption.REPLACE_EXISTING);
                }
                entry = zis.getNextEntry();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean isProjectEncrypted(Path path) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ZipFile zipFile = new ZipFile(path.toString());){
            return zipFile.isEncrypted();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void unzip(Path protectedFile, Path to, char[] pwd) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile zipFile = new ZipFile(protectedFile.toString());){
            FileHeader fileHeader = zipFile.getFileHeader("0.xml");
            EncryptionMethod enc = fileHeader.getEncryptionMethod();
            char[] key = enc == EncryptionMethod.AES ? KnxProject.createAesKey(pwd) : pwd;
            zipFile.setPassword(key);
            zipFile.extractAll(to.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Path createPath(Path baseDir, ZipEntry zipEntry) throws IOException {
        Path path = baseDir.resolve(zipEntry.getName()).normalize();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return path;
    }

    private static void deleteRecursively(Path path) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Stream<Path> files = Files.walk(path, new FileVisitOption[0]);){
                files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Document parse(Path path) throws Exception {
        Path parse = path.resolve("0.xml");
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        return builder.parse(parse.toFile());
    }

    private static String attribute(NamedNodeMap attributes, String name, String defaultValue) {
        return Optional.ofNullable(attributes.getNamedItem(name)).map(Node::getNodeValue).orElse(defaultValue);
    }

    private static Object[] parseDpt(String dpt) {
        String[] mainSub = dpt.replace("DPT-", "").replace("DPST-", "").split("-", 0);
        int main = 0;
        String dptId = "";
        if (mainSub.length >= 1 && !mainSub[0].isEmpty()) {
            main = Integer.parseInt(mainSub[0]);
        }
        if (mainSub.length == 2) {
            dptId = String.format("%d.%03d", main, Integer.parseInt(mainSub[1]));
        }
        return new Object[]{main, dptId};
    }

    private static char[] createAesKey(char[] pwd) {
        try {
            byte[] key = KnxProject.deriveKey(pwd, zipAesEncryptionSalt, 65536, 32);
            return Base64.getEncoder().encodeToString(key).toCharArray();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new KnxSecureException("creating AES key for zip decryption", (Throwable)e);
        }
    }

    private static byte[] deriveKey(char[] pwd, byte[] salt, int iterations, int size) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = KnxProject.hmac("HmacSHA256", KnxProject.macKey(pwd));
        mac.update(salt);
        byte[] byArray = new byte[4];
        byArray[3] = 1;
        byte[] blockIdx = byArray;
        byte[] input = mac.doFinal(blockIdx);
        byte[] output = new byte[size];
        int i = 0;
        while (i < iterations) {
            int s = 0;
            while (s < size) {
                int n = s;
                output[n] = (byte)(output[n] ^ input[s]);
                ++s;
            }
            input = mac.doFinal(input);
            ++i;
        }
        return output;
    }

    private static byte[] macKey(char[] pwd) {
        ByteBuffer buffer = StandardCharsets.UTF_16LE.encode(CharBuffer.wrap(pwd));
        int len = buffer.remaining();
        byte[] macKey = new byte[len];
        buffer.get(macKey);
        buffer.clear().put(new byte[len]);
        return macKey;
    }

    private static Mac hmac(String algorithm, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(key, algorithm));
        return mac;
    }
}

