/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.ManagementClient;
import tuwien.auto.calimero.mgmt.RemotePropertyServiceAdapter;
import tuwien.auto.calimero.tools.Main;

public class Memory
implements Runnable {
    private static final String tool = "Memory";
    private static Logger out = LogService.getLogger((String)"calimero.tools");
    private ManagementClient mc;
    private Destination dst;
    private final Map<String, Object> options = new HashMap<String, Object>();

    public Memory(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            Memory d = new Memory(args);
            Main.ShutdownHandler sh = new Main.ShutdownHandler().register();
            d.run();
            sh.unregister();
        }
        catch (Throwable t) {
            out.error("parsing options", t);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Throwable thrown = null;
        boolean canceled = false;
        try {
            if (this.options.isEmpty()) {
                Memory.out("Memory - Access KNX device memory");
                Main.showVersion();
                Memory.out("Type --help for help message");
                return;
            }
            if (this.options.containsKey("about")) {
                ((Runnable)this.options.get("about")).run();
                return;
            }
            try {
                IndividualAddress device = (IndividualAddress)this.options.get("device");
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    KNXNetworkLink link = Main.newLink(this.options);
                    try {
                        try (RemotePropertyServiceAdapter adapter = new RemotePropertyServiceAdapter(link, device, e -> {}, true);){
                            this.mc = adapter.managementClient();
                            this.dst = adapter.destination();
                            this.readWriteMemory();
                        }
                        if (link == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (link == null) throw throwable;
                        link.close();
                        throw throwable;
                    }
                    link.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (RuntimeException | KNXException e2) {
                thrown = e2;
                return;
            }
            catch (InterruptedException interruptedException) {
                canceled = true;
                Thread.currentThread().interrupt();
            }
            return;
        }
        finally {
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    protected void onMemoryRead(byte[] data) {
        this.out(data);
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            out.info("memory access canceled");
        }
        if (thrown != null) {
            out.error("completed", (Throwable)thrown);
        }
    }

    private void out(byte[] data) {
        String s = this.options.containsKey("dec") ? new BigInteger(1, data).toString() : "0x" + DataUnitBuilder.toHex((byte[])data, (String)"");
        Memory.out(s);
    }

    private void readWriteMemory() throws KNXException, InterruptedException {
        boolean read = this.options.containsKey("read");
        if (read) {
            int startAddr = (Integer)this.options.get("read");
            int bytes = (Integer)this.options.get("bytes");
            out.debug("read {} 0x{}..0x{}", new Object[]{this.dst.getAddress(), Long.toHexString(startAddr), Long.toHexString(startAddr + bytes - 1)});
            byte[] data = this.mc.readMemory(this.dst, startAddr, bytes);
            this.onMemoryRead(data);
        } else {
            int startAddr = (Integer)this.options.get("write");
            String input = (String)this.options.get("data");
            byte[] data = this.options.containsKey("dec") ? new BigInteger(input).toByteArray() : DataUnitBuilder.fromHex((String)input);
            out.debug("write to {} 0x{}..0x{}: {}", new Object[]{this.dst.getAddress(), Long.toHexString(startAddr), Long.toHexString(startAddr + data.length - 1), DataUnitBuilder.toHex((byte[])data, (String)" ")});
            this.mc.writeMemory(this.dst, startAddr, data);
        }
    }

    private void parseOptions(String[] args) {
        if (args.length == 0) {
            return;
        }
        this.options.put("port", 3671);
        this.options.put("bytes", 1);
        Iterator<String> i = List.of(args).iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", Memory::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "knx-address", "k")) {
                this.options.put("knx-address", Main.getAddress(i.next()));
                continue;
            }
            if (Main.isOption(arg, "dec", null)) {
                this.options.put("dec", null);
                continue;
            }
            if (arg.equals("read") || arg.equals("r")) {
                this.options.put("read", Integer.decode(i.next()));
                if (!i.hasNext()) continue;
                this.options.put("bytes", Integer.parseInt(i.next()));
                continue;
            }
            if (arg.equals("write") || arg.equals("w")) {
                this.options.put("write", Integer.decode(i.next()));
                this.options.put("data", i.next());
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            if (!this.options.containsKey("device")) {
                try {
                    this.options.put("device", new IndividualAddress(arg));
                    continue;
                }
                catch (KNXFormatException e) {
                    throw new KNXIllegalArgumentException("KNX device " + e.toString(), (Throwable)e);
                }
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (this.options.containsKey("read") == this.options.containsKey("write")) {
            throw new KNXIllegalArgumentException("specify either read or write");
        }
        if (!this.options.containsKey("host") || this.options.containsKey("ft12") && this.options.containsKey("usb")) {
            throw new KNXIllegalArgumentException("specify either IP host, serial port, or device");
        }
        if (!this.options.containsKey("device")) {
            throw new KNXIllegalArgumentException("missing remote KNX device address");
        }
        if (!this.options.containsKey("medium")) {
            this.options.put("medium", new TPSettings());
        }
        Main.setDomainAddress(this.options);
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        joiner.add("Usage: Memory [options] <host|port> <KNX device address> read|write addr ...");
        joiner.add("Commands:");
        joiner.add("  read <address> [bytes]     read number of bytes (default 1) starting at memory address");
        joiner.add("  write <address> data       write data (hex default) to memory starting at address");
        Main.printCommonOptions(joiner);
        joiner.add("  --dec                      interpret memory data in decimal format");
        Main.printSecureOptions(joiner);
        Memory.out(joiner.toString());
    }

    private static void out(String s) {
        System.out.println(s);
    }
}

