/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.net.InetSocketAddress;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.LteHeeTag;
import tuwien.auto.calimero.cemi.CEMIBusMon;
import tuwien.auto.calimero.link.KNXNetworkMonitor;
import tuwien.auto.calimero.link.KNXNetworkMonitorFT12;
import tuwien.auto.calimero.link.KNXNetworkMonitorIP;
import tuwien.auto.calimero.link.KNXNetworkMonitorTpuart;
import tuwien.auto.calimero.link.KNXNetworkMonitorUsb;
import tuwien.auto.calimero.link.LinkListener;
import tuwien.auto.calimero.link.MonitorFrameEvent;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.RFLData;
import tuwien.auto.calimero.link.medium.RawFrame;
import tuwien.auto.calimero.link.medium.RawFrameBase;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.tools.Main;

public class NetworkMonitor
implements Runnable {
    private static final String tool = "NetworkMonitor";
    private static final String sep = System.getProperty("line.separator");
    private static Logger out = LogService.getLogger((String)"calimero.tools");
    private final Map<String, Object> options = new HashMap<String, Object>();
    private KNXNetworkMonitor m;
    private final LinkListener l = new LinkListener(){

        public void indication(FrameEvent e) {
            try {
                NetworkMonitor.this.onIndication(e);
            }
            catch (RuntimeException rte) {
                out.warn("on indication", (Throwable)rte);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void linkClosed(CloseEvent e) {
            out.info("network monitor closed (" + e.getReason() + ")");
            NetworkMonitor networkMonitor = NetworkMonitor.this;
            synchronized (networkMonitor) {
                NetworkMonitor.this.notify();
            }
        }
    };

    public NetworkMonitor(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            NetworkMonitor m = new NetworkMonitor(args);
            ShutdownHandler sh = m.new ShutdownHandler().register();
            m.run();
            sh.unregister();
        }
        catch (KNXIllegalArgumentException e) {
            out.error("parsing options", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable thrown = null;
        boolean canceled = false;
        try {
            try {
                this.start();
                NetworkMonitor networkMonitor = this;
                synchronized (networkMonitor) {
                    while (this.m != null && this.m.isOpen()) {
                        this.wait(500L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                canceled = true;
                Thread.currentThread().interrupt();
                this.quit();
                this.onCompletion((Exception)thrown, canceled);
            }
            catch (RuntimeException | KNXException e) {
                thrown = e;
                this.quit();
                this.onCompletion((Exception)thrown, canceled);
            }
        }
        finally {
            this.quit();
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    public void start() throws KNXException, InterruptedException {
        if (this.options.isEmpty()) {
            NetworkMonitor.out("NetworkMonitor - Monitor a KNX network (passive busmonitor mode)");
            Main.showVersion();
            NetworkMonitor.out("Type --help for help message");
            return;
        }
        if (this.options.containsKey("about")) {
            ((Runnable)this.options.get("about")).run();
            return;
        }
        this.m = this.createMonitor();
        this.m.setDecodeRawFrames(true);
        this.m.addMonitorListener(this.l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        if (this.m != null && this.m.isOpen()) {
            this.m.close();
            NetworkMonitor networkMonitor = this;
            synchronized (networkMonitor) {
                this.notifyAll();
            }
        }
    }

    protected void onIndication(FrameEvent e) {
        StringBuilder sb = new StringBuilder();
        CEMIBusMon frame = (CEMIBusMon)e.getFrame();
        boolean compact = this.options.containsKey("compact");
        if (compact) {
            sb.append("Seq ").append(frame.getSequenceNumber());
        } else {
            sb.append(frame);
        }
        RawFrame raw = ((MonitorFrameEvent)e).getRawFrame();
        if (raw != null) {
            sb.append(compact ? " " : " = ");
            sb.append(raw.toString());
            if (raw instanceof RawFrameBase) {
                RawFrameBase f = (RawFrameBase)raw;
                sb.append(": ").append(DataUnitBuilder.decode((byte[])f.getTPDU(), (KNXAddress)f.getDestination()));
                sb.append(" ").append(DataUnitBuilder.toHex((byte[])DataUnitBuilder.extractASDU((byte[])f.getTPDU()), (String)" "));
            } else if (raw instanceof RFLData) {
                RFLData rf = (RFLData)raw;
                try {
                    sb.append(": ");
                    String bibat = NetworkMonitor.decodeBibat(rf);
                    if (!bibat.isEmpty()) {
                        sb.append(bibat);
                    } else {
                        sb.append(DataUnitBuilder.decode((byte[])rf.getTpdu(), (KNXAddress)rf.getDestination()));
                        sb.append(" ").append(NetworkMonitor.decodeLteFrame(rf));
                    }
                }
                catch (Exception ex) {
                    out.error("decoding RF frame", (Throwable)ex);
                }
            }
        }
        System.out.println(LocalTime.now() + " " + sb.toString());
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            out.info("NetworkMonitor stopped");
        }
        if (thrown != null) {
            out.error(thrown.getMessage() != null ? thrown.getMessage() : thrown.getClass().getName());
        }
    }

    private KNXNetworkMonitor createMonitor() throws KNXException, InterruptedException {
        String host = (String)this.options.get("host");
        KNXMediumSettings medium = (KNXMediumSettings)this.options.get("medium");
        if (this.options.containsKey("ft12")) {
            try {
                return new KNXNetworkMonitorFT12(Integer.parseInt(host), medium);
            }
            catch (NumberFormatException numberFormatException) {
                return new KNXNetworkMonitorFT12(host, medium);
            }
        }
        if (this.options.containsKey("ft12-cemi")) {
            return KNXNetworkMonitorFT12.newCemiMonitor((String)host, (KNXMediumSettings)medium);
        }
        if (this.options.containsKey("usb")) {
            return new KNXNetworkMonitorUsb(host, medium);
        }
        if (this.options.containsKey("tpuart")) {
            return new KNXNetworkMonitorTpuart(host, true);
        }
        InetSocketAddress local = Main.createLocalSocket(this.options);
        InetSocketAddress remote = new InetSocketAddress(Main.parseHost(host), (int)((Integer)this.options.get("port")));
        boolean nat = this.options.containsKey("nat");
        if (this.options.containsKey("user")) {
            byte[] devAuth = (byte[])this.options.getOrDefault("device-key", new byte[0]);
            byte[] userKey = (byte[])this.options.getOrDefault("user-key", new byte[0]);
            return KNXNetworkMonitorIP.newSecureMonitorLink((InetSocketAddress)local, (InetSocketAddress)remote, (boolean)nat, (byte[])devAuth, (int)((Integer)this.options.get("user")), (byte[])userKey, (KNXMediumSettings)medium);
        }
        return new KNXNetworkMonitorIP(local, remote, nat, medium);
    }

    private void parseOptions(String[] args) {
        if (args.length == 0) {
            return;
        }
        this.options.put("port", 3671);
        this.options.put("medium", new TPSettings());
        Iterator<String> i = List.of(args).iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", NetworkMonitor::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "compact", "c")) {
                this.options.put("compact", null);
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (!this.options.containsKey("host") || this.options.containsKey("ft12") && this.options.containsKey("usb")) {
            throw new KNXIllegalArgumentException("specify either IP host, serial port, or device");
        }
        Main.setDomainAddress(this.options);
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(sep);
        joiner.add("Usage: NetworkMonitor [options] <host|port>");
        Main.printCommonOptions(joiner);
        joiner.add("  --compact -c               show incoming busmonitor indications in compact format");
        Main.printSecureOptions(joiner, false);
        NetworkMonitor.out(joiner.toString());
    }

    private static void out(String s) {
        System.out.println(s);
    }

    protected static String decodeLteFrame(RFLData frame) throws KNXFormatException {
        boolean lteExt;
        int extFormat = frame.getFrameType() & 0xF;
        boolean bl = lteExt = (extFormat & 0xC) == 4;
        if (!lteExt) {
            return "no LTE";
        }
        byte[] tpdu = frame.getTpdu();
        int pci = tpdu[0] & 0xFF;
        int tpci = pci >>> 6;
        if (tpci != RFLData.Tpci.UnnumberedData.ordinal()) {
            throw new KNXFormatException("LTE extended frame requires TPCI " + RFLData.Tpci.UnnumberedData);
        }
        return NetworkMonitor.decodeLteFrame(extFormat, frame.getDestination(), DataUnitBuilder.extractASDU((byte[])tpdu));
    }

    protected static String decodeLteFrame(int extFormat, KNXAddress dst, byte[] asdu) throws KNXFormatException {
        StringBuilder sb = new StringBuilder();
        LteHeeTag tag = LteHeeTag.from((int)extFormat, (GroupAddress)((GroupAddress)dst));
        sb.append(tag).append(' ');
        int iot = (asdu[0] & 0xFF) << 8 | asdu[1] & 0xFF;
        int ioi = asdu[2] & 0xFF;
        int pid = asdu[3] & 0xFF;
        if (pid == 255) {
            int companyCode = (asdu[4] & 0xFF) << 8 | asdu[5] & 0xFF;
            int privatePid = asdu[6] & 0xFF;
            sb.append("IOT " + iot + " OI " + ioi + " Company " + companyCode + " PID " + privatePid + ": " + DataUnitBuilder.toHex((byte[])Arrays.copyOfRange(asdu, 7, asdu.length), (String)""));
        } else {
            sb.append("IOT " + iot + " OI " + ioi + " PID " + pid + ": " + DataUnitBuilder.toHex((byte[])Arrays.copyOfRange(asdu, 4, asdu.length), (String)""));
        }
        return sb.toString();
    }

    protected static String decodeBibat(RFLData frame) throws KNXFormatException {
        int frameType = frame.getFrameType() >>> 4;
        byte[] tpdu = frame.getTpdu();
        if (frameType == 1) {
            return "Fast ACK";
        }
        if (frameType == 5) {
            return "RndPausePtr " + (tpdu[0] & 0xFF);
        }
        if (frameType == 6) {
            return "Retransmitter " + (tpdu[0] & 0xFF);
        }
        if (frameType == 7) {
            int ticks = (tpdu[0] & 0xFF) << 16 | (tpdu[1] & 0xFF) << 8 | tpdu[2] & 0xFF;
            double next = (double)(ticks * 10 / 16384) / 10.0;
            return "NextBlock " + next + " ms NextBlock# " + (tpdu[3] & 0xFF) + " RndPausePtr " + (tpdu[4] & 0xFF);
        }
        return "";
    }

    private final class ShutdownHandler
    extends Thread {
        private ShutdownHandler() {
        }

        private ShutdownHandler register() {
            Runtime.getRuntime().addShutdownHook(this);
            return this;
        }

        private void unregister() {
            try {
                Runtime.getRuntime().removeShutdownHook(this);
            }
            catch (IllegalStateException illegalStateException) {}
        }

        @Override
        public void run() {
            NetworkMonitor.this.quit();
        }
    }
}

