/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.LocalDeviceManagementIp;
import tuwien.auto.calimero.mgmt.LocalDeviceManagementUsb;
import tuwien.auto.calimero.mgmt.PropertyAdapter;
import tuwien.auto.calimero.mgmt.PropertyClient;
import tuwien.auto.calimero.mgmt.RemotePropertyServiceAdapter;
import tuwien.auto.calimero.serial.usb.UsbConnection;
import tuwien.auto.calimero.tools.DeviceInfo;
import tuwien.auto.calimero.tools.Main;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlInputFactory;
import tuwien.auto.calimero.xml.XmlReader;

public class Property
implements Runnable {
    private static final String tool = "Property";
    private static final String sep = System.getProperty("line.separator");
    static Logger out = LoggerFactory.getLogger((String)"calimero.tools");
    protected final Map<String, Object> options = new HashMap<String, Object>();
    protected PropertyClient pc;
    private KNXNetworkLink link;
    private Map<PropertyClient.PropertyKey, PropertyClient.Property> definitions;
    private final Map<Integer, Integer> objIndexToType = new HashMap<Integer, Integer>();
    private final Thread interruptOnClose;
    private boolean associationTableFormat1;
    private int groupDescriptorSize;
    private static final int pidGroupObjectTable = 51;
    private final Map<PropertyClient.PropertyKey, Function<byte[], String>> customFormatter = new HashMap<PropertyClient.PropertyKey, Function<byte[], String>>();
    private static final String delimiter = ", ";

    public Property(String[] args) {
        this.customFormatter.put(Property.key(21), Property::string);
        this.customFormatter.put(Property.key(13), Property::programVersion);
        this.customFormatter.put(Property.key(2), Property::string);
        this.customFormatter.put(Property.key(12), data -> DeviceInfo.manufacturer((data[0] & 0xFF) << 8 | data[1] & 0xFF));
        this.customFormatter.put(Property.key(5), Property::loadState);
        this.customFormatter.put(Property.key(25), Property::version);
        this.customFormatter.put(Property.key(1, 23), Property::groupAddresses);
        this.customFormatter.put(Property.key(0, 11), Property::knxSerialNumber);
        this.customFormatter.put(Property.key(0, 52), Property::maxRetryCount);
        this.customFormatter.put(Property.key(0, 83), Property::deviceDescriptor);
        this.customFormatter.put(Property.key(0, 53), Property::errorFlags);
        this.customFormatter.put(Property.key(0, 57), Property::subnetAddress);
        this.customFormatter.put(Property.key(2, 23), this::associationTable);
        this.customFormatter.put(Property.key(6, 51), data -> "communication " + (Property.bitSet(data[0], 0) ? "impossible" : "possible"));
        this.customFormatter.put(Property.key(6, 52), Property::lineCouplerConfig);
        this.customFormatter.put(Property.key(6, 53), Property::lineCouplerConfig);
        this.customFormatter.put(Property.key(6, 55), Property::lineCouplerGroupConfig);
        this.customFormatter.put(Property.key(6, 54), Property::lineCouplerGroupConfig);
        this.customFormatter.put(Property.key(6, 57), Property::couplerServiceControl);
        this.customFormatter.put(Property.key(9, 23), this::groupObjectDescriptors);
        this.customFormatter.put(Property.key(9, 51), this::groupObjectDescriptors);
        this.customFormatter.put(Property.key(9, 52), this::extGroupObjectReferences);
        this.customFormatter.put(Property.key(8, 83), Property::deviceDescriptor);
        this.customFormatter.put(Property.key(11, 83), Property::deviceDescriptor);
        this.customFormatter.put(Property.key(11, 64), data -> DataUnitBuilder.toHex((byte[])data, (String)":"));
        this.customFormatter.put(Property.key(11, 68), Property::deviceCapabilities);
        this.customFormatter.put(Property.key(11, 70), Property::routingCapabilities);
        this.customFormatter.put(Property.key(11, 57), Property::ipAddress);
        this.customFormatter.put(Property.key(11, 58), Property::ipAddress);
        this.customFormatter.put(Property.key(11, 59), Property::ipAddress);
        this.customFormatter.put(Property.key(11, 63), Property::ipAddress);
        this.customFormatter.put(Property.key(11, 60), Property::ipAddress);
        this.customFormatter.put(Property.key(11, 61), Property::ipAddress);
        this.customFormatter.put(Property.key(11, 62), Property::ipAddress);
        this.customFormatter.put(Property.key(11, 66), Property::ipAddress);
        this.customFormatter.put(Property.key(11, 65), Property::ipAddress);
        this.customFormatter.put(Property.key(11, 76), Property::string);
        this.customFormatter.put(Property.key(11, 54), Property::ipAssignmentMethod);
        this.customFormatter.put(Property.key(11, 55), Property::ipAssignmentMethod);
        this.customFormatter.put(Property.key(11, 52), Property::individualAddresses);
        this.customFormatter.put(Property.key(11, 53), Property::individualAddresses);
        this.customFormatter.put(Property.key(11, 56), data -> Property.ipAssignmentMethod(new byte[]{(byte)(data[0] << 1 | 1)}));
        this.interruptOnClose = Thread.currentThread();
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            new Property(args).run();
        }
        catch (Throwable t) {
            out.error("parsing option", t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Throwable thrown = null;
        boolean canceled = false;
        try {
            if (this.options.isEmpty()) {
                Property.out("Property - Access KNX properties");
                Main.showVersion();
                Property.out("Type --help for help message");
                return;
            }
            if (this.options.containsKey("about")) {
                ((Runnable)this.options.get("about")).run();
                return;
            }
            PropertyAdapter adapter = this.createAdapter();
            if (this.options.containsKey("reset") && adapter instanceof LocalDeviceManagementIp) {
                Property.out("send local device management reset request to " + this.options.get("host") + ":" + this.options.get("port"));
                LocalDeviceManagementIp ldm = (LocalDeviceManagementIp)adapter;
                ldm.reset();
                while (ldm.isOpen()) {
                    Thread.sleep(1000L);
                }
            }
            this.pc = new PropertyClient(adapter);
            String resource = "";
            try {
                block32: {
                    if (this.options.containsKey("definitions")) {
                        resource = (String)this.options.get("definitions");
                        this.pc.addDefinitions(new PropertyClient.XmlPropertyDefinitions().load(resource));
                    } else {
                        resource = "/properties.xml";
                        Throwable throwable = null;
                        Object var6_9 = null;
                        try {
                            InputStream is = Property.class.getResourceAsStream(resource);
                            try {
                                try (XmlReader r = XmlInputFactory.newInstance().createXMLStreamReader(is);){
                                    this.pc.addDefinitions(new PropertyClient.XmlPropertyDefinitions().load(r));
                                }
                                if (is == null) break block32;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (is == null) throw throwable;
                                is.close();
                                throw throwable;
                            }
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                }
                this.definitions = this.pc.getDefinitions();
            }
            catch (IOException | KNXMLException e) {
                out.error("loading definitions from " + resource + " failed", e);
            }
            this.runCommand((String[])this.options.get("command"));
            return;
        }
        catch (RuntimeException | KNXException e) {
            thrown = e;
            return;
        }
        catch (InterruptedException interruptedException) {
            canceled = true;
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            if (this.pc != null) {
                this.pc.close();
            }
            if (this.link != null) {
                this.link.close();
            }
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    private void adapterClosed(CloseEvent e) {
        Property.out("connection closed (" + e.getReason() + ")");
        if (e.getInitiator() != 0) {
            this.interruptOnClose.interrupt();
        }
    }

    protected void runCommand(String ... cmd) throws InterruptedException {
        if (cmd == null) {
            return;
        }
        try {
            String what = cmd[0];
            if ("get".equals(what)) {
                this.getProperty(cmd);
            } else if ("set".equals(what)) {
                this.setProperty(cmd);
            } else if ("scan".equals(what)) {
                this.scanProperties(cmd);
            } else if ("desc".equals(what)) {
                this.getDescription(cmd);
            } else if ("?".equals(what) || "help".equals(what)) {
                Property.showCommandList();
            } else {
                Property.out("unknown command ('?' or 'help' shows help)");
            }
        }
        catch (NumberFormatException e) {
            out.error("invalid number (" + e.getMessage() + ")");
        }
        catch (RuntimeException | KNXException e) {
            out.error(e.getMessage());
        }
    }

    private void notifyDescription(Description d) {
        this.objIndexToType.put(d.getObjectIndex(), d.getObjectType());
        this.onDescription(d);
    }

    protected void onDescription(Description d) {
        StringBuilder buf = new StringBuilder();
        buf.append("OI ").append(Property.alignRight(d.getObjectIndex(), 2));
        buf.append(", PI ").append(Property.alignRight(d.getPropIndex(), 2)).append(" |");
        buf.append(" OT ").append(Property.alignRight(d.getObjectType(), 3));
        buf.append(", PID ").append(Property.alignRight(d.getPID(), 3));
        buf.append(" | ");
        PropertyClient.Property p = this.getPropertyDef(d.getObjectType(), d.getPID());
        if (p == null) {
            p = this.getPropertyDef(-1, d.getPID());
        }
        if (p != null) {
            buf.append(p.getName());
            while (buf.length() < 65) {
                buf.append(' ');
            }
            buf.append(" (");
            buf.append(p.getPIDName());
            buf.append(")");
        } else {
            buf.append(new String(new char[33]).replace('\u0000', ' ')).append("(n/a)");
        }
        String pdtDef = p != null ? Integer.toString(p.getPDT()) : "-";
        buf.append(", PDT " + (d.getPDT() == -1 ? pdtDef : Integer.toString(d.getPDT())));
        buf.append(", curr. elems " + d.getCurrentElements());
        buf.append(", max. " + d.getMaxElements());
        buf.append(", r/w access " + d.getReadLevel() + "/" + d.getWriteLevel());
        buf.append(d.isWriteEnabled() ? ", w.enabled" : ", r.only");
        System.out.println(buf.toString());
    }

    protected void onPropertyValue(int idx, int pid, String value, List<byte[]> raw) {
        String rawValue = raw.stream().map(e -> DataUnitBuilder.toHex((byte[])e, (String)"")).collect(Collectors.joining(delimiter, " (", ")"));
        System.out.println(String.valueOf(value) + rawValue);
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            Property.out("reading property canceled");
        }
        if (thrown != null) {
            out.error("on completion", (Throwable)thrown);
        }
    }

    protected KNXNetworkLink link() {
        return this.link;
    }

    private PropertyAdapter createAdapter() throws KNXException, InterruptedException {
        String host = (String)this.options.get("host");
        if (this.options.containsKey("local")) {
            if (this.options.containsKey("usb")) {
                return this.createUsbAdapter(host);
            }
            if (!this.options.getOrDefault("user", 1).equals(1)) {
                throw new KnxRuntimeException("secure local device management requires user 1 (management user)");
            }
            return Main.newLocalDeviceMgmtIP(this.options, this::adapterClosed);
        }
        return this.createRemoteAdapter(host);
    }

    private PropertyAdapter createUsbAdapter(String device) throws KNXException, InterruptedException {
        UsbConnection usb = new UsbConnection(device);
        return new LocalDeviceManagementUsb(usb, this::adapterClosed, this.options.containsKey("emulatewriteenable"));
    }

    private PropertyAdapter createRemoteAdapter(String host) throws KNXException, InterruptedException {
        this.link = Main.newLink(this.options);
        IndividualAddress remote = (IndividualAddress)this.options.get("remote");
        byte[] authKey = (byte[])this.options.get("authorize");
        if (authKey != null) {
            RemotePropertyServiceAdapter adapter = new RemotePropertyServiceAdapter(this.link, remote, this::adapterClosed, authKey);
            out.info("{} granted access level {}", (Object)remote, (Object)adapter.accessLevel());
            return adapter;
        }
        return new RemotePropertyServiceAdapter(this.link, remote, this::adapterClosed, this.options.containsKey("connect"));
    }

    private static String alignRight(int value, int width) {
        return String.format("%1$" + width + "s", Integer.toString(value));
    }

    private PropertyClient.Property getPropertyDef(int objType, int pid) {
        if (this.definitions == null) {
            return null;
        }
        return this.definitions.get(new PropertyClient.PropertyKey(objType, pid));
    }

    private void parseOptions(String[] args) {
        if (args.length == 0) {
            return;
        }
        this.options.put("port", 3671);
        this.options.put("medium", new TPSettings());
        Main.PeekingIterator<String> i = new Main.PeekingIterator<String>(List.of(args).iterator());
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", Property::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "local", "l")) {
                this.options.put("local", null);
                continue;
            }
            if (Main.isOption(arg, "remote", "r")) {
                this.options.put("remote", Main.getAddress(i.next()));
                continue;
            }
            if (Main.isOption(arg, "definitions", "d")) {
                this.options.put("definitions", i.next());
                continue;
            }
            if (Main.isOption(arg, "knx-address", "k")) {
                this.options.put("knx-address", Main.getAddress(i.next()));
                continue;
            }
            if (Main.isOption(arg, "emulatewriteenable", "e")) {
                this.options.put("emulatewriteenable", null);
                continue;
            }
            if (Main.isOption(arg, "connect", "c")) {
                this.options.put("connect", null);
                continue;
            }
            if (Main.isOption(arg, "authorize", "a")) {
                this.options.put("authorize", Property.getAuthorizeKey(i.next()));
                continue;
            }
            if (arg.equals("reset")) {
                this.options.put("reset", null);
                continue;
            }
            if (this.parseCommand(i, arg)) continue;
            if (arg.equals("?")) {
                this.options.put("command", new String[]{"?"});
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (!this.options.containsKey("remote")) {
            this.options.put("local", null);
        }
        if (!this.options.containsKey("host")) {
            throw new KNXIllegalArgumentException("no communication device/host specified");
        }
        if (this.options.containsKey("ft12") && !this.options.containsKey("remote")) {
            throw new KNXIllegalArgumentException("--remote option is mandatory with --ft12");
        }
        Main.setDomainAddress(this.options);
    }

    private boolean parseCommand(Main.PeekingIterator<String> i, String arg) {
        if (!(arg.equals("get") || arg.equals("set") || arg.equals("desc") || arg.equals("scan"))) {
            return false;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(arg);
        try {
            while (i.hasNext()) {
                Integer.decode(i.peek());
                cmd.add(i.next());
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (arg.equals("desc") && i.hasNext() && "i".equals(i.peek())) {
            cmd.add(i.next());
            cmd.add(i.next());
        } else if (arg.equals("scan") && "all".equals(i.peek())) {
            cmd.add(i.next());
        }
        this.options.put("command", cmd.toArray(new String[0]));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void getProperty(String[] args) throws KNXException, InterruptedException {
        if (args.length == 2 && args[1].equals("?")) {
            Property.out("get object-idx pid [start-idx elements]");
        } else if (args.length == 3 || args.length == 5) {
            block25: {
                oi = Property.toInt(args[1]);
                pid = Property.toInt(args[2]);
                s = "";
                raw = new ArrayList<byte[]>();
                objType = -1;
                try {
                    objType = this.objIndexToType.getOrDefault(oi, -1);
                    if (this.customFormatter.containsKey(Property.key(objType, pid)) || this.customFormatter.containsKey(Property.key(pid))) {
                        throw new KNXException();
                    }
                    if (args.length == 3) {
                        x = this.pc.getPropertyTranslated(oi, pid, 1, 1);
                        s = x.getValue();
                        raw.add(x.getData());
                    } else {
                        start = Property.toInt(args[3]);
                        elements = Property.toInt(args[4]);
                        i = 0;
                        while (i < elements) {
                            min = Math.min(15, elements - i);
                            translator = this.pc.getPropertyTranslated(oi, pid, start + i, min);
                            data = translator.getData();
                            size = data.length / min;
                            allValues = translator.getAllValues();
                            if (!s.isEmpty()) {
                                s = String.valueOf(s) + ", ";
                            }
                            s = String.valueOf(s) + Arrays.asList(allValues).stream().collect(Collectors.joining(", "));
                            from = 0;
                            while (from < data.length) {
                                raw.add(Arrays.copyOfRange(data, from, from + size));
                                from += size;
                            }
                            i += 15;
                        }
                    }
                    break block25;
                }
                catch (RuntimeException | KNXException v0) {
                    if (objType == 2 && pid == 23) {
                        desc = this.pc.getDescription(oi, 23);
                        pdt = desc.getPDT();
                        v1 = this.associationTableFormat1 = pdt == 20;
                    }
                    if (objType == 9 && pid == 23) {
                        desc = this.pc.getDescription(oi, 23);
                        pdt = desc.getPDT();
                        switch (pdt) {
                            case 18: {
                                this.groupDescriptorSize = 2;
                                break;
                            }
                            case 19: {
                                this.groupDescriptorSize = 3;
                                break;
                            }
                            case 20: {
                                this.groupDescriptorSize = 4;
                                break;
                            }
                            case 22: {
                                this.groupDescriptorSize = 6;
                                break;
                            }
                            default: {
                                this.groupDescriptorSize = 0;
                            }
                        }
                    }
                    if (objType == 9 && pid == 51) {
                        this.groupDescriptorSize = 6;
                    }
                    if (args.length == 3) {
                        data = this.pc.getProperty(oi, pid, 1, 1);
                        s = this.customFormatter(objType, pid).map((Function<Function, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$48(byte[] java.util.function.Function ), (Ljava/util/function/Function;)Ljava/lang/String;)((byte[])data)).orElseGet((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$49(byte[] ), ()Ljava/lang/String;)((byte[])data));
                        raw.add(data);
                        break block25;
                    }
                    start = Property.toInt(args[3]);
                    elements = Property.toInt(args[4]);
                    collect = new ByteArrayOutputStream();
                    i = 0;
                    ** while (i < elements)
                }
lbl-1000:
                // 1 sources

                {
                    min = Math.min(15, elements - i);
                    part = this.pc.getProperty(oi, pid, start + i, min);
                    collect.writeBytes(part);
                    i += 15;
                    continue;
                }
lbl82:
                // 1 sources

                data = collect.toByteArray();
                if (data.length > 0) {
                    s = this.customFormatter(objType, pid).map((Function<Function, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$50(byte[] java.util.function.Function ), (Ljava/util/function/Function;)Ljava/lang/String;)((byte[])data)).orElseGet((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$51(byte[] int ), ()Ljava/lang/String;)((byte[])data, (int)elements));
                    size = data.length / elements;
                    from = 0;
                    while (from < data.length) {
                        raw.add(Arrays.copyOfRange(data, from, from + size));
                        from += size;
                    }
                    s = s.trim();
                }
            }
            this.onPropertyValue(oi, pid, s, raw);
        } else {
            Property.out("sorry, wrong number of arguments");
        }
    }

    private void getDescription(String[] args) throws KNXException, InterruptedException {
        if (args.length == 3) {
            this.notifyDescription(this.pc.getDescription(Property.toInt(args[1]), Property.toInt(args[2])));
        } else if (args.length == 4 && args[2].equals("i")) {
            this.notifyDescription(this.pc.getDescriptionByIndex(Property.toInt(args[1]), Property.toInt(args[3])));
        } else if (args.length == 2 && args[1].equals("?")) {
            Property.printHelp("desc object-idx pid" + sep + "desc object-idx \"i\" prop-idx");
        } else {
            Property.out("sorry, wrong number of arguments");
        }
    }

    private void setProperty(String[] args) throws KNXException, InterruptedException {
        if (args.length == 2 && args[1].equals("?")) {
            Property.printHelp("set object-idx pid [start-idx] string-value" + sep + "set object-idx pid start-idx elements [\"0x\"|\"0\"|\"b\"]data" + sep + "(use hexadecimal format for more than 8 byte data or leading zeros)");
            return;
        }
        if (args.length < 4 || args.length > 6) {
            Property.out("sorry, wrong number of arguments");
            return;
        }
        int cnt = args.length;
        int oi = Property.toInt(args[1]);
        int pid = Property.toInt(args[2]);
        if (cnt == 4) {
            this.pc.setProperty(oi, pid, 1, args[3]);
        } else if (cnt == 5) {
            this.pc.setProperty(oi, pid, Property.toInt(args[3]), args[4]);
        } else {
            int start = Property.toInt(args[3]);
            int elements = Property.toInt(args[4]);
            byte[] data = Property.toByteArray(args[5]);
            int typeSize = data.length / elements;
            if (typeSize == 0) {
                throw new KNXIllegalArgumentException(String.format("property data %s cannot be split into %d elements (type size 0)", args[5], elements));
            }
            int maxLength = 10 / typeSize * typeSize;
            int i = 0;
            while (i < data.length) {
                int len = Math.min(maxLength, data.length - i);
                this.pc.setProperty(oi, pid, start + i / typeSize, len / typeSize, Arrays.copyOfRange(data, i, i + len));
                i += maxLength;
            }
        }
    }

    private void scanProperties(String[] args) throws KNXException, InterruptedException {
        int cnt = args.length;
        if (cnt == 2 && args[1].equals("?")) {
            Property.printHelp("scan [object-idx] [\"all\" for all object properties]");
            return;
        }
        System.out.println("Object Index (OI), Property Index (PI), Object Type (OT), Property ID (PID)");
        if (cnt == 1) {
            this.pc.scanProperties(false, this::notifyDescription);
        } else if (cnt == 2) {
            if (args[1].equals("all")) {
                this.pc.scanProperties(true, this::notifyDescription);
            } else {
                this.pc.scanProperties(Property.toInt(args[1]), false, this::notifyDescription);
            }
        } else if (cnt == 3 && args[2].equals("all")) {
            this.pc.scanProperties(Property.toInt(args[1]), true, this::notifyDescription);
        } else {
            Property.out("sorry, wrong number of arguments");
            return;
        }
        System.out.println("scan complete");
    }

    private static void showCommandList() {
        StringBuilder buf = new StringBuilder();
        buf.append("commands: get | set | desc | scan (append ? for help)" + sep);
        buf.append("get  - read property value(s)" + sep);
        buf.append("set  - write property value(s)" + sep);
        buf.append("desc - read one property description" + sep);
        buf.append("scan - read property descriptions");
        Property.out(buf.toString());
    }

    private static void printHelp(String help) {
        Property.out(help);
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(sep);
        joiner.add("Usage: Property [options] <host|port> <command>");
        Main.printCommonOptions(joiner);
        joiner.add("  --local -l                 local device management");
        joiner.add("  --remote -r <KNX addr>     remote property service");
        joiner.add("  --definitions -d <file>    use property definition file");
        joiner.add("Options for local device management only:");
        joiner.add("  --emulatewriteenable -e    check write-enable of a property");
        joiner.add("Options for remote property services only:");
        joiner.add("  --connect -c               connection oriented mode");
        joiner.add("  --authorize -a <key>       authorize key to access KNX device");
        Main.printSecureOptions(joiner);
        joiner.add("Available commands:");
        joiner.add("  get <object-idx> <pid> [<start-idx> <elements>]     get the property value(s)");
        joiner.add("  set <object-idx> <pid> [start-idx] <string-value>   set the formatted property value (according to PDT)");
        joiner.add("  set <object-idx> <pid> <start-idx> <elements> [\"0x\"|\"0\"|\"b\"]<data>    set the property data");
        joiner.add("  desc <object-idx> <pid>                get the property description of the property ID");
        joiner.add("  desc <object-idx> \"i\" <prop-idx>       get the property description of the property index");
        joiner.add("  scan [<object-idx>]                    list interface object type descriptions");
        joiner.add("  scan [<object-idx>] \"all\"              list all property descriptions");
        joiner.add("  ?                                      show command help");
        Property.out(joiner.toString());
    }

    private static byte[] getAuthorizeKey(String key) {
        long value = Long.decode(key);
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new KNXIllegalArgumentException("invalid authorize key");
        }
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    private static int toInt(String number) {
        return Integer.decode(number);
    }

    private static byte[] toByteArray(String s) {
        if (s.startsWith("0x") || s.startsWith("0X")) {
            byte[] d = new byte[(s.length() - 1) / 2];
            int k = (s.length() & 1) != 0 ? 3 : 4;
            int i = 2;
            while (i < s.length()) {
                d[(i - 1) / 2] = (byte)Integer.parseInt(s.substring(i, k), 16);
                i = k;
                k += 2;
            }
            return d;
        }
        long l = s.length() > 1 && s.startsWith("0") ? Long.parseLong(s, 8) : (s.startsWith("b") ? Long.parseLong(s.substring(1), 2) : Long.parseLong(s));
        int i = 0;
        long test = l;
        while (test != 0L) {
            ++i;
            test /= 256L;
        }
        byte[] d = new byte[i == 0 ? 1 : i];
        while (i-- > 0) {
            d[i] = (byte)(l & 0xFFL);
            l /= 256L;
        }
        return d;
    }

    static void out(String s) {
        System.out.println(s);
    }

    private Optional<Function<byte[], String>> customFormatter(int objectType, int pid) {
        Function<byte[], String> formatter = this.customFormatter.get(Property.key(objectType, pid));
        return Optional.ofNullable(formatter != null ? formatter : this.customFormatter.get(Property.key(pid)));
    }

    private static PropertyClient.PropertyKey key(int pid) {
        return new PropertyClient.PropertyKey(-1, pid);
    }

    private static PropertyClient.PropertyKey key(int objectType, int pid) {
        return new PropertyClient.PropertyKey(objectType, pid);
    }

    private static String knxSerialNumber(byte[] data) {
        String hex = DataUnitBuilder.toHex((byte[])data, (String)"");
        return String.valueOf(hex.substring(0, 4)) + ":" + hex.substring(4);
    }

    private static String maxRetryCount(byte[] data) {
        return "Busy: " + (data[0] >> 4) + ", NAK: " + (data[0] & 7);
    }

    private static String couplerServiceControl(byte[] data) {
        byte v = data[0];
        StringJoiner joiner = new StringJoiner(delimiter);
        joiner.add("SNA inconsistency check: " + Property.enabled(v, 0));
        joiner.add("SNA heartbeat: " + Property.enabled(v, 1));
        joiner.add("Update SNA: " + Property.enabled(v, 2));
        joiner.add("SNA read: " + Property.enabled(v, 3));
        joiner.add("Distribute subline status: " + Property.enabled(v, 4));
        return joiner.toString();
    }

    private static String enabled(byte v, int bit) {
        return Property.bitSet(v, bit) ? "enabled" : "disabled";
    }

    private static String version(byte[] data) {
        int magic = (data[0] & 0xFF) >> 3;
        int version = (data[0] & 7) << 2 | (data[1] & 0xC0) >> 6;
        int rev = data[1] & 0x3F;
        return "[" + magic + "] " + version + "." + rev;
    }

    private static String individualAddresses(byte[] data) {
        StringJoiner joiner = new StringJoiner(delimiter);
        int i = 0;
        while (i < data.length) {
            int address = (data[i] & 0xFF) << 8 | data[i + 1] & 0xFF;
            joiner.add(new IndividualAddress(address).toString());
            i += 2;
        }
        return joiner.toString();
    }

    private static String groupAddresses(byte[] data) {
        StringJoiner joiner = new StringJoiner(delimiter);
        int i = 0;
        while (i < data.length) {
            int address = (data[i] & 0xFF) << 8 | data[i + 1] & 0xFF;
            joiner.add(new GroupAddress(address).toString());
            i += 2;
        }
        return joiner.toString();
    }

    private String associationTable(byte[] data) {
        StringJoiner joiner = new StringJoiner(delimiter);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        while (buffer.hasRemaining()) {
            int first = this.associationTableFormat1 ? buffer.getShort() & 0xFFFF : buffer.get() & 0xFF;
            int second = this.associationTableFormat1 ? buffer.getShort() & 0xFFFF : buffer.get() & 0xFF;
            String assoc = String.valueOf(first) + "=" + second;
            joiner.add(assoc);
        }
        return joiner.toString();
    }

    private String groupObjectDescriptors(byte[] data) {
        StringJoiner joiner = new StringJoiner(delimiter);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int groupObject = 1;
        String dptId = null;
        while (buffer.hasRemaining()) {
            int bitsize;
            int config;
            byte[] descriptor = new byte[this.groupDescriptorSize];
            buffer.get(descriptor);
            StringBuilder sb = new StringBuilder();
            switch (descriptor.length) {
                case 2: {
                    config = descriptor[0] & 0xFF;
                    bitsize = Property.valueFieldTypeToBits(descriptor[1] & 0xFF);
                    break;
                }
                case 3: {
                    config = descriptor[1] & 0xFF;
                    bitsize = Property.valueFieldTypeToBits(descriptor[2] & 0xFF);
                    break;
                }
                case 4: {
                    config = descriptor[2] & 0xFF;
                    bitsize = Property.valueFieldTypeToBits(descriptor[3] & 0xFF);
                    break;
                }
                case 6: {
                    config = descriptor[1] & 0xFF;
                    int mainType = (descriptor[2] & 0xFF) << 8 | descriptor[3] & 0xFF;
                    int subType = (descriptor[4] & 0xFF) << 8 | descriptor[5] & 0xFF;
                    dptId = String.format("%d.%03d", mainType, subType);
                    bitsize = Property.translatorBitSize(dptId);
                    break;
                }
                default: {
                    return DataUnitBuilder.toHex((byte[])data, (String)" ");
                }
            }
            Priority priority = Priority.get((int)(config & 3));
            boolean enable = (config & 4) != 0;
            boolean responder = (config & 8) != 0;
            boolean write = (config & 0x10) != 0;
            boolean transmit = (config & 0x40) != 0;
            boolean updateOnResponse = (config & 0x80) != 0;
            sb.append("GO#").append(groupObject).append(" ");
            sb.append(bitsize).append(bitsize == 1 ? " bit " : " bits ");
            if (dptId != null) {
                sb.append(dptId).append(" ");
            }
            StringJoiner commFlags = new StringJoiner("/");
            if (enable) {
                commFlags.add("C");
            }
            if (responder) {
                commFlags.add("R");
            }
            if (write) {
                commFlags.add("W");
            }
            if (transmit) {
                commFlags.add("T");
            }
            if (updateOnResponse) {
                commFlags.add("U");
            }
            sb.append("(").append(commFlags).append(delimiter).append(priority).append(")");
            joiner.add(sb);
            ++groupObject;
        }
        return joiner.toString();
    }

    private String extGroupObjectReferences(byte[] data) {
        StringJoiner joiner = new StringJoiner(delimiter);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        String s = "OT(Oinst)|PID ";
        while (buffer.hasRemaining()) {
            int ot = buffer.getShort() & 0xFFFF;
            int oi = buffer.get() & 0xFF;
            int pid = buffer.get() & 0xFF;
            int startIdx = buffer.getShort() & 0xFFFF;
            int bitOffset = buffer.get() & 0xFF;
            int conv = buffer.get() & 0xFF;
            s = String.valueOf(s) + String.format("%d(%d)|%d startidx %d bitoffset %d conv %d", ot, oi, pid, startIdx, bitOffset, conv);
            joiner.add(s);
            s = "";
        }
        return joiner.toString();
    }

    private static int valueFieldTypeToBits(int code) {
        int[] lowerFieldTypes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 16, 24, 32, 48, 64, 80, 112, 40, 56, 72, 88, 96, 104};
        if (code < lowerFieldTypes.length) {
            return lowerFieldTypes[code];
        }
        if (code == 255) {
            return 2016;
        }
        return (code - 6) * 8;
    }

    private static int translatorBitSize(String dptId) {
        try {
            return TranslatorTypes.createTranslator((String)dptId, (byte[])new byte[0]).bitSize();
        }
        catch (KNXException kNXException) {
            return 0;
        }
    }

    private static String errorFlags(byte[] data) {
        if ((data[0] & 0xFF) == 255) {
            return "everything OK";
        }
        String[] description = new String[]{"System 1 internal system error", "illegal system state", "checksum / CRC error in internal non-volatile memory", "stack overflow error", "inconsistent system tables", "physical transceiver error", "System 2 internal system error", "System 3 internal system error"};
        StringJoiner joiner = new StringJoiner(delimiter);
        int i = 0;
        while (i < 8) {
            if ((data[0] & 1 << i) == 0) {
                joiner.add(description[i]);
            }
            ++i;
        }
        return joiner.toString();
    }

    private static String subnetAddress(byte[] data) {
        int i = data[0] & 0xFF;
        return String.valueOf(i >> 4) + "." + (i & 0xF);
    }

    private static String programVersion(byte[] data) {
        if (data.length != 5) {
            return DataUnitBuilder.toHex((byte[])data, (String)"");
        }
        int mfr = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        return String.format("%s %02x%02x v%d.%d", DeviceInfo.manufacturer(mfr), data[2], data[3], (data[4] & 0xFF) >> 4, data[4] & 0xF);
    }

    private static String string(byte[] data) {
        return new String(data, StandardCharsets.ISO_8859_1);
    }

    private static String deviceCapabilities(byte[] data) {
        StringJoiner joiner = new StringJoiner(delimiter);
        if ((data[1] & 1) == 1) {
            joiner.add("Device Management");
        }
        if ((data[1] & 2) == 2) {
            joiner.add("Tunneling");
        }
        if ((data[1] & 4) == 4) {
            joiner.add("Routing");
        }
        if ((data[1] & 8) == 8) {
            joiner.add("Remote Logging");
        }
        if ((data[1] & 0x10) == 16) {
            joiner.add("Remote Configuration & Diagnosis");
        }
        if ((data[1] & 0x20) == 32) {
            joiner.add("Object Server");
        }
        return joiner.toString();
    }

    private static String routingCapabilities(byte[] data) {
        StringJoiner joiner = new StringJoiner(delimiter);
        byte b = data[0];
        if ((b & 1) == 1) {
            joiner.add("Queue overflow error count");
        }
        if ((b & 2) == 2) {
            joiner.add("Transmitted telegram count");
        }
        if ((b & 4) == 4) {
            joiner.add("Priority/FIFO");
        }
        if ((b & 8) == 8) {
            joiner.add("Multiple KNX installations");
        }
        if ((b & 0x10) == 16) {
            joiner.add("Group address mapping between installations");
        }
        return joiner.toString();
    }

    private static String ipAddress(byte[] data) {
        try {
            return InetAddress.getByAddress(data).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "n/a";
        }
    }

    private static String ipAssignmentMethod(byte[] data) {
        int bitset = data[0] & 0xFF;
        StringJoiner joiner = new StringJoiner(delimiter);
        if ((bitset & 1) != 0) {
            joiner.add("manual");
        }
        if ((bitset & 2) != 0) {
            joiner.add("Bootstrap Protocol");
        }
        if ((bitset & 4) != 0) {
            joiner.add("DHCP");
        }
        if ((bitset & 8) != 0) {
            joiner.add("Auto IP");
        }
        return joiner.toString();
    }

    private static String deviceDescriptor(byte[] data) {
        try {
            return DeviceDescriptor.from((byte[])data).toString();
        }
        catch (KNXFormatException kNXFormatException) {
            return DataUnitBuilder.toHex((byte[])data, (String)"");
        }
    }

    private static String lineCouplerConfig(byte[] data) {
        byte v = data[0];
        StringJoiner joiner = new StringJoiner(delimiter);
        int physFrame = v & 3;
        joiner.add("P2P frames: " + (physFrame == 1 ? "route all" : (physFrame == 2 ? "don't route" : (physFrame == 3 ? "normal mode" : "-"))));
        joiner.add(String.valueOf(Property.bitSet(v, 2) ? "repeat" : "don't repeat") + " on TX error");
        joiner.add("BC frames: " + (Property.bitSet(v, 3) ? "block" : "route"));
        joiner.add(String.valueOf(Property.bitSet(v, 4) ? "repeat" : "don't repeat") + " on TX error");
        joiner.add("MC ACK: " + (Property.bitSet(v, 5) ? "routed only" : "all"));
        int physIack = v >> 6 & 3;
        joiner.add("L2 P2P ACK: " + (physIack == 1 ? "normal mode" : (physIack == 2 ? "all" : (physIack == 3 ? "NACK all" : "-"))));
        return joiner.toString();
    }

    private static String lineCouplerGroupConfig(byte[] data) {
        byte v = data[0];
        StringJoiner joiner = new StringJoiner(delimiter);
        int group6fff = v & 3;
        joiner.add("group address \u2264 0x6fff (13/7/255): " + (group6fff == 1 ? "route all" : (group6fff == 2 ? "don't route" : (group6fff == 3 ? "routing table" : "-"))));
        int group7000 = v >> 2 & 3;
        joiner.add("group address \u2265 0x7000 (14/0/0): " + (group7000 == 1 ? "route all" : (group7000 == 2 ? "don't route" : (group7000 == 3 ? "routing table" : "-"))));
        joiner.add("TX error: " + (Property.bitSet(v, 4) ? "repeat" : "don't repeat"));
        return joiner.toString();
    }

    private static String loadState(byte[] data) {
        int state = data[0] & 0xFF;
        switch (state) {
            case 0: {
                return "unloaded";
            }
            case 1: {
                return "loaded";
            }
            case 2: {
                return "loading";
            }
            case 3: {
                return "error (during load process)";
            }
            case 4: {
                return "unloading";
            }
            case 5: {
                return "load completing";
            }
        }
        return "invalid load status " + state;
    }

    private static boolean bitSet(byte value, int bit) {
        return (value & 1 << bit) == 1 << bit;
    }

    private static /* synthetic */ String lambda$48(byte[] byArray, Function f) {
        return (String)f.apply(byArray);
    }

    private static /* synthetic */ String lambda$49(byte[] byArray) {
        return "0x" + DataUnitBuilder.toHex((byte[])byArray, (String)"");
    }

    private static /* synthetic */ String lambda$50(byte[] byArray, Function f) {
        return (String)f.apply(byArray);
    }

    private static /* synthetic */ String lambda$51(byte[] byArray, int n) {
        String tmp = "";
        String hex = DataUnitBuilder.toHex((byte[])byArray, (String)"");
        int chars = hex.length() / n;
        int k = 0;
        while (k < n) {
            tmp = String.valueOf(tmp) + "0x" + hex.substring(k * chars, (k + 1) * chars) + " ";
            ++k;
        }
        return tmp;
    }
}

