/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.LocalDeviceManagementIp;
import tuwien.auto.calimero.mgmt.ManagementClientImpl;
import tuwien.auto.calimero.tools.Main;

public class Restart
implements Runnable {
    private static final String tool = "Restart";
    private static final String sep = System.getProperty("line.separator");
    private final Map<String, Object> options = new HashMap<String, Object>();

    public Restart(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException | KNXFormatException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        try {
            new Restart(args).run();
        }
        catch (Throwable t) {
            Restart.out("error parsing arguments (use --help): " + t, new Throwable[0]);
        }
    }

    @Override
    public void run() {
        if (this.options.containsKey("about")) {
            ((Runnable)this.options.get("about")).run();
            return;
        }
        Throwable thrown = null;
        boolean canceled = false;
        IndividualAddress remote = (IndividualAddress)this.options.get("device");
        try {
            try {
                if (remote != null) {
                    this.remoteDeviceRestart(remote);
                } else {
                    this.localDeviceMgmtReset();
                }
            }
            catch (RuntimeException | KNXException e) {
                thrown = e;
                this.onCompletion((Exception)thrown, canceled);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                String msg = e.getMessage();
                if (msg != null) {
                    Restart.out(msg, new Throwable[0]);
                } else {
                    canceled = true;
                }
                this.onCompletion((Exception)thrown, canceled);
            }
        }
        finally {
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void remoteDeviceRestart(IndividualAddress remote) throws KNXException, InterruptedException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            KNXNetworkLink link = Main.newLink(this.options);
            try {
                try (ManagementClientImpl mgmt = new ManagementClientImpl(link);){
                    Destination destination = mgmt.createDestination(remote, false);
                    int restartType = (Integer)this.options.get("restart-type");
                    if (restartType > 0) {
                        boolean yes;
                        boolean bl = yes = this.options.containsKey("yes") || restartType == 1 || Restart.confirm(destination);
                        if (yes) {
                            int channel = (Integer)this.options.getOrDefault("channel", 0);
                            int time = mgmt.restart(destination, restartType, channel);
                            System.out.format("restart takes %d seconds%n", time > 0 ? time : 5);
                        }
                    } else {
                        mgmt.restart(destination);
                    }
                }
                if (link == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (link == null) throw throwable;
                link.close();
                throw throwable;
            }
            link.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void localDeviceMgmtReset() throws KNXConnectionClosedException, KNXTimeoutException, InterruptedException, KNXException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (LocalDeviceManagementIp mgmt = Main.newLocalDeviceMgmtIP(this.options, __ -> {});){
            int restartType = (Integer)this.options.get("restart-type");
            if (restartType != 0) {
                System.out.println("Using local device management, ignore restart type");
            }
            mgmt.reset();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean confirm(Destination destination) {
        System.out.format("Reset device %s? [y/N] ", destination.getAddress());
        try {
            String input = new BufferedReader(new InputStreamReader(System.in)).readLine();
            return "yes".equalsIgnoreCase(input) || "y".equalsIgnoreCase(input);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            Restart.out("Restart got canceled", new Throwable[0]);
        }
        if (thrown != null) {
            Restart.out("Restart error", thrown);
        }
    }

    private void parseOptions(String[] args) throws KNXFormatException {
        if (args.length == 0) {
            this.options.put("about", Restart::showToolInfo);
            return;
        }
        this.options.put("port", 3671);
        this.options.put("medium", new TPSettings());
        this.options.put("restart-type", 0);
        int restartType = -1;
        Iterator<String> i = List.of(args).iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", Restart::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "knx-address", "k")) {
                this.options.put("knx-address", Main.getAddress(i.next()));
                continue;
            }
            if (restartType == -1 && (restartType = Restart.restartType(arg)) >= 0) {
                this.options.put("restart-type", restartType);
                if (restartType != 2 && restartType != 5 && restartType != 6 && restartType != 7) continue;
                this.options.put("channel", Integer.parseUnsignedInt(i.next()));
                continue;
            }
            if (restartType >= 0 && Restart.restartType(arg) >= 0) {
                throw new KNXIllegalArgumentException("specify at most 1 restart type");
            }
            if (Main.isOption(arg, "yes", "y")) {
                this.options.put("yes", null);
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            this.options.put("device", new IndividualAddress(arg));
        }
        if (!this.options.containsKey("host")) {
            throw new KNXIllegalArgumentException("no communication device/host specified");
        }
        if (this.options.containsKey("ft12") && !this.options.containsKey("remote")) {
            throw new KNXIllegalArgumentException("--remote option is mandatory with --ft12");
        }
        Main.setDomainAddress(this.options);
    }

    private static int restartType(String option) {
        String code;
        switch (code = option.length() < 2 ? option : option.substring(2)) {
            case "basic": {
                return 0;
            }
            case "confirmed": {
                return 1;
            }
            case "reset-factory": 
            case "factory-reset": {
                return 2;
            }
            case "reset-address": {
                return 3;
            }
            case "reset-app": {
                return 4;
            }
            case "reset-params": {
                return 5;
            }
            case "reset-links": {
                return 6;
            }
            case "factory-keep-addr": {
                return 7;
            }
        }
        return -1;
    }

    private static void showToolInfo() {
        Restart.out("Restart - Restart a KNX interface or KNX device", new Throwable[0]);
        Main.showVersion();
        Restart.out("Use --help for help message", new Throwable[0]);
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(sep);
        joiner.add("Usage: Restart [options] <host|port> [<KNX device address>]");
        Main.printCommonOptions(joiner);
        joiner.add("  --yes -y                   automatic yes to reset confirmation");
        joiner.add("If a device address is supplied, the supported restart types are (select at most one):");
        joiner.add("  --basic                    basic restart without confirmation [default]");
        joiner.add("  --confirmed                basic restart with confirmation");
        joiner.add("  --factory-reset            factory reset (used with channel)");
        joiner.add("  --reset-address            reset device address to its default");
        joiner.add("  --reset-app                reset application program memory to default application");
        joiner.add("  --reset-params             reset application parameter memory (used with channel)");
        joiner.add("  --reset-links              reset links (used with channel)");
        joiner.add("  --factory-keep-addr        factory reset without resetting device addresses (used with channel)");
        Main.printSecureOptions(joiner);
        Restart.out(joiner.toString(), new Throwable[0]);
    }

    private static void out(CharSequence s, Throwable ... t) {
        if (t.length > 0 && t[0] != null) {
            System.out.print(s + ": ");
            t[0].printStackTrace();
        } else {
            System.out.println(s);
        }
    }
}

