/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero;

import java.util.EventObject;
import java.util.Optional;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIFactory;
import tuwien.auto.calimero.secure.SecurityControl;

public class FrameEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private final long id = System.nanoTime();
    private final CEMI c;
    private final byte[] b;
    private final boolean systemBroadcast;
    private final SecurityControl securityCtrl;

    public FrameEvent(Object source, CEMI frame) {
        this(source, frame, false);
    }

    public FrameEvent(Object source, CEMI frame, boolean systemBroadcast) {
        this(source, frame, systemBroadcast, null);
    }

    public FrameEvent(Object source, CEMI frame, boolean systemBroadcast, SecurityControl securityCtrl) {
        super(source);
        this.c = frame;
        this.b = null;
        this.systemBroadcast = systemBroadcast;
        this.securityCtrl = securityCtrl;
    }

    public FrameEvent(Object source, byte[] frame) {
        super(source);
        this.b = frame;
        this.c = null;
        this.systemBroadcast = false;
        this.securityCtrl = null;
    }

    public final CEMI getFrame() {
        return CEMIFactory.copy(this.c);
    }

    public final byte[] getFrameBytes() {
        return this.b != null ? (byte[])this.b.clone() : null;
    }

    public final long id() {
        return this.id;
    }

    public final boolean systemBroadcast() {
        return this.systemBroadcast;
    }

    public final Optional<SecurityControl> security() {
        return Optional.ofNullable(this.securityCtrl);
    }
}

