/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KnxRuntimeException;

public final class LteHeeTag {
    private final Type type;
    private final int tag;

    public static LteHeeTag from(String tag) {
        String[] split = tag.replaceAll("\\*", "0").split("/", -1);
        List levels = Arrays.stream(split).map(Integer::decode).collect(Collectors.toList());
        if (levels.size() == 1) {
            return new LteHeeTag(7, new GroupAddress((Integer)levels.get(0)));
        }
        return LteHeeTag.geoTag((Integer)levels.get(0), (Integer)levels.get(1), (Integer)levels.get(2));
    }

    public static LteHeeTag from(int eff, GroupAddress addr) {
        return new LteHeeTag(eff, addr);
    }

    public static LteHeeTag geoTag(int floor, int room, int subzone) {
        return new LteHeeTag(floor, room, subzone);
    }

    public static LteHeeTag hvacTag(HvacType type, int segmentOrZone) {
        return new LteHeeTag(type, segmentOrZone);
    }

    private LteHeeTag(int eff, GroupAddress addr) {
        if ((eff & 4) == 0) {
            throw new KNXIllegalArgumentException("not an LTE-HEE address");
        }
        this.type = Type.values()[eff & 3];
        this.tag = addr.getRawAddress();
    }

    private LteHeeTag(int floor, int room, int subzone) {
        boolean upper = floor >= 64;
        this.type = upper ? Type.UpperGeo : Type.LowerGeo;
        this.tag = (upper ? floor - 64 : floor) << 10 | room << 4 | subzone;
    }

    private LteHeeTag(HvacType type, int segmentOrZone) {
        this.type = Type.App;
        int hvacTypeId = 0;
        for (Map.Entry<Integer, HvacType> e : HvacType.map.entrySet()) {
            if (!e.getValue().equals((Object)type)) continue;
            hvacTypeId = e.getKey();
        }
        this.tag = hvacTypeId << 5 | segmentOrZone;
    }

    public Type type() {
        return this.type;
    }

    public boolean broadcast() {
        return this.tag == 0;
    }

    public int floor() {
        int aptFloor = (this.tag & 0xFC00) >> 10;
        if (aptFloor != 0) {
            aptFloor += this.type == Type.LowerGeo ? 0 : 64;
        }
        return aptFloor;
    }

    public int room() {
        return (this.tag & 0x3F0) >> 4;
    }

    public int subzone() {
        return this.tag & 0xF;
    }

    public int appDomain() {
        return this.tag & 0xF000;
    }

    public HvacType hvacType() {
        int mapping = this.tag >> 5;
        return HvacType.map.getOrDefault(mapping, HvacType.Reserved);
    }

    public int hvacZone() {
        return this.tag & 0x1F;
    }

    public int distributionSegment() {
        return this.tag & 0x1F;
    }

    public int producerSegment() {
        return this.tag >> 5 & 0xF;
    }

    public int producer() {
        return this.tag & 0x1F;
    }

    public int unassignedTag() {
        return this.tag & 0xFFF;
    }

    public GroupAddress toGroupAddress() {
        return new GroupAddress(this.tag);
    }

    public String toString() {
        if (this.tag == 0) {
            return "broadcast";
        }
        switch (this.type()) {
            case LowerGeo: 
            case UpperGeo: {
                return "floor/room/subzone " + LteHeeTag.wildcard(this.floor()) + "/" + LteHeeTag.wildcard(this.room()) + "/" + LteHeeTag.wildcard(this.subzone());
            }
            case App: {
                if (this.appDomain() != 0) {
                    return String.valueOf(this.appDomain()) + "/0x" + Integer.toHexString(this.unassignedTag()) + " (app)";
                }
                StringBuilder sb = new StringBuilder("HVAC ").append((Object)this.hvacType()).append(' ');
                switch (this.hvacType()) {
                    case ProdSegHotWater: 
                    case ProdSegColdWater: {
                        return sb.append(this.producerSegment()).append(' ').append(LteHeeTag.wildcard(this.hvacZone())).toString();
                    }
                    case Reserved: {
                        return sb.append(String.format("0b%8s", Integer.toBinaryString(this.unassignedTag())).replace(' ', '0')).toString();
                    }
                }
                return sb.append(LteHeeTag.wildcard(this.hvacZone())).toString();
            }
            case Unassigned: {
                return "unassigned tag 0x" + Integer.toHexString(this.unassignedTag());
            }
        }
        throw new KnxRuntimeException("" + (Object)((Object)this.type()));
    }

    private static String wildcard(int zone) {
        return zone == 0 ? "*" : "" + zone;
    }

    public static enum HvacType {
        Reserved,
        HotWaterDistribution,
        ColdWaterDistribution,
        VentDistribution,
        DhwZone,
        OutsideSensorZone,
        CalendarZone,
        ProdSegHotWater,
        ProdSegColdWater;

        private static final Map<Integer, HvacType> map;

        static {
            map = Map.of(1, HotWaterDistribution, 2, ColdWaterDistribution, 3, VentDistribution, 4, DhwZone, 5, OutsideSensorZone, 6, CalendarZone, 16, ProdSegHotWater, 32, ProdSegColdWater);
        }

        public String friendly() {
            return this.name().replaceAll("([A-Z])", " $1").trim();
        }
    }

    public static enum Type {
        LowerGeo,
        UpperGeo,
        App,
        Unassigned;

    }
}

