/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero;

import tuwien.auto.calimero.KNXIllegalArgumentException;

public enum Priority {
    SYSTEM,
    NORMAL,
    URGENT,
    LOW;

    public final int value = this.ordinal();

    public static Priority get(int value) {
        if (value == 1) {
            return NORMAL;
        }
        if (value == 0) {
            return SYSTEM;
        }
        if (value == 3) {
            return LOW;
        }
        if (value == 2) {
            return URGENT;
        }
        throw new KNXIllegalArgumentException("invalid priority value");
    }

    public static Priority get(String value) {
        if ("system".equalsIgnoreCase(value)) {
            return SYSTEM;
        }
        if ("normal".equalsIgnoreCase(value)) {
            return NORMAL;
        }
        if ("urgent".equalsIgnoreCase(value)) {
            return URGENT;
        }
        if ("low".equalsIgnoreCase(value)) {
            return LOW;
        }
        throw new KNXIllegalArgumentException("invalid priority value");
    }

    public String toString() {
        return this.value == 0 ? "system" : (this.value == 1 ? "normal" : (this.value == 2 ? "urgent" : "low"));
    }
}

